/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.core.internal.util;

import java.io.File;
import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.egit.core.CoreText;
import org.eclipse.jgit.lib.Repository;

public class ProjectUtil {
    public static IProject[] getValidProjects(Repository repository) throws CoreException {
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        ArrayList<IProject> result = new ArrayList<IProject>();
        File parentFile = repository.getWorkTree();
        IProject[] iProjectArray = projects;
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            File file;
            IProject p = iProjectArray[n2];
            String projectFilePath = p.getLocation().append(".project").toOSString();
            File projectFile = new File(projectFilePath);
            if (projectFile.exists() && (file = p.getLocation().toFile()).getAbsolutePath().startsWith(parentFile.getAbsolutePath())) {
                result.add(p);
            }
            ++n2;
        }
        return result.toArray(new IProject[result.size()]);
    }

    public static void refreshValidProjects(IProject[] projects, IProgressMonitor monitor) throws CoreException {
        try {
            monitor.beginTask(CoreText.ProjectUtil_refreshingProjects, projects.length);
            IProject[] iProjectArray = projects;
            int n = projects.length;
            int n2 = 0;
            while (n2 < n) {
                IProject p = iProjectArray[n2];
                if (monitor.isCanceled()) {
                    break;
                }
                String projectFilePath = p.getLocation().append(".project").toOSString();
                File projectFile = new File(projectFilePath);
                if (projectFile.exists()) {
                    p.refreshLocal(2, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                } else {
                    p.delete(false, true, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                }
                monitor.worked(1);
                ++n2;
            }
        }
        finally {
            monitor.done();
        }
    }

    public static void refreshResources(IResource[] resources, IProgressMonitor monitor) throws CoreException {
        try {
            monitor.beginTask(CoreText.ProjectUtil_refreshing, resources.length);
            IResource[] iResourceArray = resources;
            int n = resources.length;
            int n2 = 0;
            while (n2 < n) {
                IResource resource = iResourceArray[n2];
                if (monitor.isCanceled()) {
                    break;
                }
                resource.refreshLocal(2, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                monitor.worked(1);
                ++n2;
            }
        }
        finally {
            monitor.done();
        }
    }
}

