/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.core.op;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.egit.core.Activator;
import org.eclipse.egit.core.CoreText;
import org.eclipse.egit.core.internal.util.ProjectUtil;
import org.eclipse.egit.core.op.IEGitOperation;
import org.eclipse.jgit.api.CheckoutCommand;
import org.eclipse.jgit.api.CheckoutResult;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.util.FileUtils;
import org.eclipse.osgi.util.NLS;
import org.eclipse.team.core.TeamException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BranchOperation
implements IEGitOperation {
    private final Repository repository;
    private final String refName;
    private final ObjectId commitId;
    private CheckoutResult result;

    public BranchOperation(Repository repository, String refName) {
        this.repository = repository;
        this.refName = refName;
        this.commitId = null;
    }

    public BranchOperation(Repository repository, ObjectId commit) {
        this.repository = repository;
        this.refName = null;
        this.commitId = commit;
    }

    @Override
    public void execute(IProgressMonitor m) throws CoreException {
        Object monitor = m == null ? new NullProgressMonitor() : m;
        if (this.refName != null && !this.refName.startsWith("refs/")) {
            throw new TeamException(NLS.bind((String)CoreText.BranchOperation_CheckoutOnlyBranchOrTag, (Object)this.refName));
        }
        IWorkspaceRunnable action = new IWorkspaceRunnable(){

            public void run(IProgressMonitor pm) throws CoreException {
                IProject[] validProjects = ProjectUtil.getValidProjects(BranchOperation.this.repository);
                pm.beginTask(NLS.bind((String)CoreText.BranchOperation_performingBranch, (Object)BranchOperation.this.refName), 1);
                CheckoutCommand co = new Git(BranchOperation.this.repository).checkout();
                co.setName(BranchOperation.this.getTarget());
                try {
                    try {
                        co.call();
                    }
                    catch (JGitInternalException e) {
                        throw new CoreException(Activator.error(e.getMessage(), e));
                    }
                    catch (GitAPIException e) {
                        throw new CoreException(Activator.error(e.getMessage(), e));
                    }
                }
                finally {
                    BranchOperation.this.result = co.getResult();
                }
                if (BranchOperation.this.result.getStatus() == CheckoutResult.Status.NONDELETED) {
                    BranchOperation.this.retryDelete(BranchOperation.this.result.getUndeletedList());
                }
                pm.worked(1);
                ProjectUtil.refreshValidProjects(validProjects, (IProgressMonitor)new SubProgressMonitor(pm, 1));
                pm.worked(1);
                pm.done();
            }
        };
        ResourcesPlugin.getWorkspace().run(action, monitor);
    }

    @Override
    public ISchedulingRule getSchedulingRule() {
        return ResourcesPlugin.getWorkspace().getRoot();
    }

    public CheckoutResult getResult() {
        return this.result;
    }

    private String getTarget() {
        if (this.refName != null) {
            return this.refName;
        }
        return this.commitId.name();
    }

    void retryDelete(List<String> pathList) {
        long startTime = System.currentTimeMillis();
        for (String path : pathList) {
            if (System.currentTimeMillis() - startTime > 1000L) break;
            File fileToDelete = new File(this.repository.getWorkTree(), path);
            if (!fileToDelete.exists()) continue;
            try {
                FileUtils.delete((File)fileToDelete, (int)3);
            }
            catch (IOException iOException) {}
        }
    }
}

