/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.core.op;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URISyntaxException;
import java.util.Collection;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.egit.core.CoreText;
import org.eclipse.egit.core.EclipseGitProgressTransformer;
import org.eclipse.jgit.dircache.DirCacheCheckout;
import org.eclipse.jgit.errors.NotSupportedException;
import org.eclipse.jgit.errors.TransportException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.RefUpdate;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.storage.file.FileBasedConfig;
import org.eclipse.jgit.storage.file.FileRepository;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.FetchResult;
import org.eclipse.jgit.transport.RefSpec;
import org.eclipse.jgit.transport.RemoteConfig;
import org.eclipse.jgit.transport.Transport;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.jgit.util.FileUtils;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CloneOperation {
    private final URIish uri;
    private final boolean allSelected;
    private final Collection<Ref> selectedBranches;
    private final File workdir;
    private final File gitdir;
    private final Ref ref;
    private final String remoteName;
    private final int timeout;
    private FileRepository local;
    private RemoteConfig remoteConfig;
    private FetchResult fetchResult;
    private CredentialsProvider credentialsProvider;

    public CloneOperation(URIish uri, boolean allSelected, Collection<Ref> selectedBranches, File workdir, Ref ref, String remoteName, int timeout) {
        this.uri = uri;
        this.allSelected = allSelected;
        this.selectedBranches = selectedBranches;
        this.workdir = workdir;
        this.gitdir = new File(workdir, ".git");
        this.ref = ref;
        this.remoteName = remoteName;
        this.timeout = timeout;
    }

    public void setCredentialsProvider(CredentialsProvider credentialsProvider) {
        this.credentialsProvider = credentialsProvider;
    }

    public void run(IProgressMonitor pm) throws InvocationTargetException, InterruptedException {
        Object monitor = pm == null ? new NullProgressMonitor() : pm;
        try {
            try {
                monitor.beginTask(NLS.bind((String)CoreText.CloneOperation_title, (Object)this.uri), 5000);
                try {
                    this.doInit((IProgressMonitor)new SubProgressMonitor(monitor, 100));
                    this.doFetch((IProgressMonitor)new SubProgressMonitor(monitor, 4000));
                    this.doCheckout((IProgressMonitor)new SubProgressMonitor(monitor, 900));
                }
                finally {
                    this.closeLocal();
                }
            }
            catch (Exception e) {
                try {
                    FileUtils.delete((File)this.workdir, (int)1);
                }
                catch (IOException ioe) {
                    throw new InvocationTargetException(ioe);
                }
                if (monitor.isCanceled()) {
                    throw new InterruptedException();
                }
                throw new InvocationTargetException(e);
            }
        }
        finally {
            monitor.done();
        }
    }

    public File getGitDir() {
        return this.gitdir;
    }

    private void closeLocal() {
        if (this.local != null) {
            this.local.close();
            this.local = null;
        }
    }

    private void doInit(IProgressMonitor monitor) throws URISyntaxException, IOException {
        monitor.setTaskName(CoreText.CloneOperation_initializingRepository);
        this.local = new FileRepository(this.gitdir);
        this.local.create();
        if (this.ref.getName().startsWith("refs/heads/")) {
            RefUpdate head = this.local.updateRef("HEAD");
            head.disableRefLog();
            head.link(this.ref.getName());
        }
        FileBasedConfig config = this.local.getConfig();
        this.remoteConfig = new RemoteConfig((Config)config, this.remoteName);
        this.remoteConfig.addURI(this.uri);
        String dst = "refs/remotes/" + this.remoteConfig.getName();
        RefSpec wcrs = new RefSpec();
        wcrs = wcrs.setForceUpdate(true);
        wcrs = wcrs.setSourceDestination("refs/heads/*", String.valueOf(dst) + "/*");
        if (this.allSelected) {
            this.remoteConfig.addFetchRefSpec(wcrs);
        } else {
            for (Ref selectedRef : this.selectedBranches) {
                if (!wcrs.matchSource(selectedRef)) continue;
                this.remoteConfig.addFetchRefSpec(wcrs.expandFromSource(selectedRef));
            }
        }
        config.setBoolean("core", null, "bare", false);
        this.remoteConfig.update((Config)config);
        if (this.ref.getName().startsWith("refs/heads/")) {
            String branchName = this.ref.getName().substring("refs/heads/".length());
            config.setString("branch", branchName, "remote", this.remoteName);
            config.setString("branch", branchName, "merge", this.ref.getName());
        }
        config.save();
    }

    private void doFetch(IProgressMonitor monitor) throws NotSupportedException, TransportException {
        Transport tn = Transport.open((Repository)this.local, (RemoteConfig)this.remoteConfig);
        if (this.credentialsProvider != null) {
            tn.setCredentialsProvider(this.credentialsProvider);
        }
        tn.setTimeout(this.timeout);
        try {
            EclipseGitProgressTransformer pm = new EclipseGitProgressTransformer(monitor);
            this.fetchResult = tn.fetch((ProgressMonitor)pm, null);
        }
        finally {
            tn.close();
        }
    }

    private void doCheckout(IProgressMonitor monitor) throws IOException {
        RevCommit mapCommit;
        Ref head = this.fetchResult.getAdvertisedRef(this.ref.getName());
        if (head == null || head.getObjectId() == null) {
            return;
        }
        RevWalk rw = new RevWalk((Repository)this.local);
        try {
            mapCommit = rw.parseCommit((AnyObjectId)head.getObjectId());
        }
        finally {
            rw.release();
        }
        boolean detached = !head.getName().startsWith("refs/heads/");
        RefUpdate u = this.local.updateRef("HEAD", detached);
        u.setNewObjectId((AnyObjectId)mapCommit.getId());
        u.forceUpdate();
        monitor.setTaskName(CoreText.CloneOperation_checkingOutFiles);
        DirCacheCheckout dirCacheCheckout = new DirCacheCheckout((Repository)this.local, null, this.local.lockDirCache(), (ObjectId)mapCommit.getTree());
        dirCacheCheckout.setFailOnConflict(true);
        boolean result = dirCacheCheckout.checkout();
        if (!result) {
            throw new IOException("Internal error occured on checking out files");
        }
        monitor.setTaskName(CoreText.CloneOperation_writingIndex);
    }
}

