/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.core.op;

import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.egit.core.CoreText;
import org.eclipse.egit.core.internal.trace.GitTraceLocation;
import org.eclipse.egit.core.op.IEGitOperation;
import org.eclipse.egit.core.project.RepositoryMapping;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.ConcurrentRefUpdateException;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.api.errors.NoHeadException;
import org.eclipse.jgit.api.errors.NoMessageException;
import org.eclipse.jgit.api.errors.WrongRepositoryStateException;
import org.eclipse.jgit.errors.UnmergedPathException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.CommitBuilder;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectInserter;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.RefUpdate;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.Tree;
import org.eclipse.jgit.lib.TreeEntry;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.util.ChangeIdUtil;
import org.eclipse.jgit.util.RawParseUtils;
import org.eclipse.osgi.util.NLS;
import org.eclipse.team.core.TeamException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommitOperation
implements IEGitOperation {
    private IFile[] filesToCommit;
    private boolean commitWorkingDirChanges = false;
    private String author;
    private String committer;
    private String message;
    private boolean amending = false;
    private boolean commitAll = false;
    private RevCommit previousCommit;
    private Repository[] repos;
    private Collection<IFile> notIndexed;
    private Collection<IFile> notTracked;
    private boolean createChangeId;

    public CommitOperation(IFile[] filesToCommit, Collection<IFile> notIndexed, Collection<IFile> notTracked, String author, String committer, String message) {
        this.filesToCommit = filesToCommit;
        this.notIndexed = notIndexed;
        this.notTracked = notTracked;
        this.author = author;
        this.committer = committer;
        this.message = message;
    }

    @Override
    public void execute(IProgressMonitor m) throws CoreException {
        Object monitor = m == null ? new NullProgressMonitor() : m;
        IWorkspaceRunnable action = new IWorkspaceRunnable(){

            public void run(IProgressMonitor actMonitor) throws CoreException {
                Date commitDate = new Date();
                TimeZone timeZone = TimeZone.getDefault();
                PersonIdent authorIdent = RawParseUtils.parsePersonIdent((String)CommitOperation.this.author);
                PersonIdent committerIdent = RawParseUtils.parsePersonIdent((String)CommitOperation.this.committer);
                if (CommitOperation.this.commitAll) {
                    Repository[] repositoryArray = CommitOperation.this.repos;
                    int n = repositoryArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Repository repo = repositoryArray[n2];
                        Git git = new Git(repo);
                        try {
                            git.commit().setAll(true).setAuthor(new PersonIdent(authorIdent, commitDate, timeZone)).setCommitter(new PersonIdent(committerIdent, commitDate, timeZone)).setMessage(CommitOperation.this.message).call();
                        }
                        catch (NoHeadException e) {
                            throw new TeamException(e.getLocalizedMessage(), (Throwable)e);
                        }
                        catch (NoMessageException e) {
                            throw new TeamException(e.getLocalizedMessage(), (Throwable)e);
                        }
                        catch (UnmergedPathException e) {
                            throw new TeamException(e.getLocalizedMessage(), (Throwable)e);
                        }
                        catch (ConcurrentRefUpdateException e) {
                            throw new TeamException(CoreText.MergeOperation_InternalError, (Throwable)e);
                        }
                        catch (JGitInternalException e) {
                            throw new TeamException(CoreText.MergeOperation_InternalError, (Throwable)e);
                        }
                        catch (WrongRepositoryStateException e) {
                            throw new TeamException(e.getLocalizedMessage(), (Throwable)e);
                        }
                        ++n2;
                    }
                } else if (CommitOperation.this.amending || CommitOperation.this.filesToCommit != null && CommitOperation.this.filesToCommit.length > 0) {
                    actMonitor.beginTask(CoreText.CommitOperation_PerformingCommit, CommitOperation.this.filesToCommit.length * 2);
                    actMonitor.setTaskName(CoreText.CommitOperation_PerformingCommit);
                    HashMap treeMap = new HashMap();
                    try {
                        if (!CommitOperation.this.prepareTrees(CommitOperation.this.filesToCommit, treeMap, actMonitor)) {
                            for (Repository repo : treeMap.keySet()) {
                                repo.getIndex().read();
                            }
                            return;
                        }
                    }
                    catch (IOException e) {
                        throw new TeamException(CoreText.CommitOperation_errorPreparingTrees, (Throwable)e);
                    }
                    try {
                        CommitOperation.this.doCommits(CommitOperation.this.message, treeMap);
                        actMonitor.worked(CommitOperation.this.filesToCommit.length);
                    }
                    catch (IOException e) {
                        throw new TeamException(CoreText.CommitOperation_errorCommittingChanges, (Throwable)e);
                    }
                }
            }
        };
        ResourcesPlugin.getWorkspace().run(action, monitor);
    }

    @Override
    public ISchedulingRule getSchedulingRule() {
        return ResourcesPlugin.getWorkspace().getRoot();
    }

    /*
     * Unable to fully structure code
     */
    private boolean prepareTrees(IFile[] selectedItems, HashMap<Repository, Tree> treeMap, IProgressMonitor monitor) throws IOException, UnsupportedEncodingException {
        if (selectedItems.length == 0) {
            var7_4 = this.repos;
            var6_5 = this.repos.length;
            var5_6 = 0;
            while (var5_6 < var6_5) {
                repo = var7_4[var5_6];
                treeMap.put((Repository)repo, repo.mapTree("HEAD"));
                ++var5_6;
            }
        }
        var7_4 = selectedItems;
        var6_5 = selectedItems.length;
        var5_6 = 0;
        while (var5_6 < var6_5) {
            file = var7_4[var5_6];
            if (monitor.isCanceled()) {
                return false;
            }
            monitor.worked(1);
            project = file.getProject();
            repositoryMapping = RepositoryMapping.getMapping((IResource)project);
            repository = repositoryMapping.getRepository();
            projTree = treeMap.get(repository);
            if (projTree == null) {
                projTree = repository.mapTree("HEAD");
                if (projTree == null) {
                    projTree = new Tree(repository);
                }
                treeMap.put(repository, projTree);
                if (GitTraceLocation.CORE.isActive()) {
                    GitTraceLocation.getTrace().trace(GitTraceLocation.CORE.getLocation(), "Orig tree id: " + projTree.getId());
                }
            }
            index = repository.getIndex();
            string = repoRelativePath = repositoryMapping.getRepoRelativePath((IResource)file);
            treeMember = projTree.findBlobMember(repoRelativePath);
            treeWithDeletedEntry = null;
            if (treeMember != null) {
                treeWithDeletedEntry = treeMember.getParent();
                treeMember.delete();
            }
            idxEntry = index.getEntry(string);
            if (!this.notIndexed.contains(file)) ** GOTO lbl54
            thisfile = new File(repositoryMapping.getWorkTree(), idxEntry.getName());
            if (!thisfile.isFile()) {
                index.remove(repositoryMapping.getWorkTree(), thisfile);
                if (GitTraceLocation.CORE.isActive()) {
                    GitTraceLocation.getTrace().trace(GitTraceLocation.CORE.getLocation(), "Phantom file, so removing from index");
                }
                while (treeWithDeletedEntry.memberCount() == 0) {
                    toDelete = treeWithDeletedEntry;
                    treeWithDeletedEntry = treeWithDeletedEntry.getParent();
                    toDelete.delete();
                }
            } else {
                idxEntry.update(thisfile);
lbl54:
                // 2 sources

                if (this.notTracked.contains(file)) {
                    idxEntry = index.add(repositoryMapping.getWorkTree(), new File(repositoryMapping.getWorkTree(), repoRelativePath));
                }
                if (idxEntry != null) {
                    projTree.addFile(repoRelativePath);
                    newMember = projTree.findBlobMember(repoRelativePath);
                    newMember.setId(idxEntry.getObjectId());
                    if (GitTraceLocation.CORE.isActive()) {
                        GitTraceLocation.getTrace().trace(GitTraceLocation.CORE.getLocation(), "New member id for " + repoRelativePath + ": " + newMember.getId() + " idx id: " + idxEntry.getObjectId());
                    }
                }
            }
            ++var5_6;
        }
        return true;
    }

    private void doCommits(String actMessage, HashMap<Repository, Tree> treeMap) throws IOException, TeamException {
        String commitMessage = actMessage;
        Date commitDate = new Date();
        TimeZone timeZone = TimeZone.getDefault();
        PersonIdent authorIdent = RawParseUtils.parsePersonIdent((String)this.author);
        PersonIdent committerIdent = RawParseUtils.parsePersonIdent((String)this.committer);
        for (Map.Entry<Repository, Tree> entry : treeMap.entrySet()) {
            ObjectId commitId;
            ObjectId[] parentIds;
            Tree tree = entry.getValue();
            Repository repo = tree.getRepository();
            repo.getIndex().write();
            this.writeTreeWithSubTrees(tree);
            ObjectId currentHeadId = repo.resolve("HEAD");
            if (this.amending) {
                RevCommit[] parents = this.previousCommit.getParents();
                parentIds = new ObjectId[parents.length];
                int i = 0;
                while (i < parents.length) {
                    parentIds[i] = parents[i].getId();
                    ++i;
                }
            } else {
                parentIds = currentHeadId != null ? new ObjectId[]{currentHeadId} : new ObjectId[]{};
            }
            if (this.createChangeId) {
                ObjectId parentId = parentIds.length > 0 ? parentIds[0] : null;
                ObjectId changeId = ChangeIdUtil.computeChangeId((ObjectId)tree.getId(), (ObjectId)parentId, (PersonIdent)authorIdent, (PersonIdent)committerIdent, (String)commitMessage);
                commitMessage = ChangeIdUtil.insertId((String)commitMessage, (ObjectId)changeId);
                if (changeId != null) {
                    commitMessage = commitMessage.replaceAll("\nChange-Id: I0000000000000000000000000000000000000000\n", "\nChange-Id: I" + changeId.getName() + "\n");
                }
            }
            CommitBuilder commit = new CommitBuilder();
            commit.setTreeId((AnyObjectId)tree.getTreeId());
            commit.setParentIds(parentIds);
            commit.setMessage(commitMessage);
            commit.setAuthor(new PersonIdent(authorIdent, commitDate, timeZone));
            commit.setCommitter(new PersonIdent(committerIdent, commitDate, timeZone));
            ObjectInserter inserter = repo.newObjectInserter();
            try {
                commitId = inserter.insert(commit);
                inserter.flush();
            }
            finally {
                inserter.release();
            }
            RefUpdate ru = repo.updateRef("HEAD");
            ru.setNewObjectId((AnyObjectId)commitId);
            ru.setRefLogMessage(this.buildReflogMessage(commitMessage), false);
            if (ru.forceUpdate() != RefUpdate.Result.LOCK_FAILURE) continue;
            throw new TeamException(NLS.bind((String)CoreText.CommitOperation_failedToUpdate, (Object)ru.getName(), (Object)commitId));
        }
    }

    private void writeTreeWithSubTrees(Tree tree) throws TeamException {
        if (tree.getId() == null) {
            if (GitTraceLocation.CORE.isActive()) {
                GitTraceLocation.getTrace().trace(GitTraceLocation.CORE.getLocation(), "writing tree for: " + tree.getFullName());
            }
            try {
                TreeEntry[] treeEntryArray = tree.members();
                int n = treeEntryArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TreeEntry entry = treeEntryArray[n2];
                    if (entry.isModified()) {
                        if (entry instanceof Tree) {
                            this.writeTreeWithSubTrees((Tree)entry);
                        } else if (GitTraceLocation.CORE.isActive()) {
                            GitTraceLocation.getTrace().trace(GitTraceLocation.CORE.getLocation(), "BAD JUJU: " + entry.getFullName());
                        }
                    }
                    ++n2;
                }
                ObjectInserter inserter = tree.getRepository().newObjectInserter();
                try {
                    tree.setId(inserter.insert(2, tree.format()));
                    inserter.flush();
                }
                finally {
                    inserter.release();
                }
            }
            catch (IOException e) {
                throw new TeamException(CoreText.CommitOperation_errorWritingTrees, (Throwable)e);
            }
        }
    }

    private String buildReflogMessage(String commitMessage) {
        String firstLine = commitMessage;
        int newlineIndex = commitMessage.indexOf("\n");
        if (newlineIndex > 0) {
            firstLine = commitMessage.substring(0, newlineIndex);
        }
        String commitStr = this.amending ? "commit (amend):" : "commit: ";
        String result = String.valueOf(commitStr) + firstLine;
        return result;
    }

    public void setAmending(boolean amending) {
        this.amending = amending;
    }

    public void setPreviousCommit(RevCommit previousCommit) {
        this.previousCommit = previousCommit;
    }

    public void setCommitAll(boolean commitAll) {
        this.commitAll = commitAll;
    }

    public void setRepos(Repository[] repos) {
        this.repos = repos;
    }

    public void setComputeChangeId(boolean createChangeId) {
        this.createChangeId = createChangeId;
    }

    static /* synthetic */ boolean access$9(CommitOperation commitOperation) {
        return commitOperation.commitWorkingDirChanges;
    }
}

