/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.core.op;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.MultiRule;
import org.eclipse.egit.core.Activator;
import org.eclipse.egit.core.CoreText;
import org.eclipse.egit.core.GitProvider;
import org.eclipse.egit.core.internal.trace.GitTraceLocation;
import org.eclipse.egit.core.op.IEGitOperation;
import org.eclipse.egit.core.project.GitProjectData;
import org.eclipse.egit.core.project.RepositoryFinder;
import org.eclipse.egit.core.project.RepositoryMapping;
import org.eclipse.osgi.util.NLS;
import org.eclipse.team.core.RepositoryProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConnectProviderOperation
implements IEGitOperation {
    private final Map<IProject, File> projects = new HashMap<IProject, File>();

    public ConnectProviderOperation(IProject proj) {
        this(proj, proj.getLocation().append(".git").toFile());
    }

    public ConnectProviderOperation(IProject proj, File pathToRepo) {
        this.projects.put(proj, pathToRepo);
    }

    public ConnectProviderOperation(Map<IProject, File> projects) {
        this.projects.putAll(projects);
    }

    @Override
    public void execute(IProgressMonitor m) throws CoreException {
        Object monitor = m == null ? new NullProgressMonitor() : m;
        monitor.beginTask(CoreText.ConnectProviderOperation_connecting, 100 * this.projects.size());
        try {
            for (IProject project : this.projects.keySet()) {
                File suggestedRepo;
                Collection<RepositoryMapping> repos;
                RepositoryMapping actualMapping;
                monitor.setTaskName(NLS.bind((String)CoreText.ConnectProviderOperation_ConnectingProject, (Object)project.getName()));
                if (GitTraceLocation.CORE.isActive()) {
                    GitTraceLocation.getTrace().trace(GitTraceLocation.CORE.getLocation(), "Locating repository for " + project);
                }
                if ((actualMapping = this.findActualRepository(repos = new RepositoryFinder(project).find((IProgressMonitor)new SubProgressMonitor(monitor, 40)), suggestedRepo = this.projects.get(project))) != null) {
                    GitProjectData projectData = new GitProjectData(project);
                    try {
                        projectData.setRepositoryMappings(Arrays.asList(actualMapping));
                        projectData.store();
                    }
                    catch (CoreException ce) {
                        try {
                            GitProjectData.delete(project);
                        }
                        catch (IOException e) {
                            MultiStatus status = new MultiStatus(Activator.getPluginId(), 4, e.getMessage(), (Throwable)e);
                            status.add((IStatus)new Status(4, Activator.getPluginId(), ce.getMessage(), (Throwable)ce));
                            throw new CoreException((IStatus)status);
                        }
                        throw ce;
                    }
                    catch (RuntimeException ce) {
                        try {
                            GitProjectData.delete(project);
                        }
                        catch (IOException e) {
                            MultiStatus status = new MultiStatus(Activator.getPluginId(), 4, e.getMessage(), (Throwable)e);
                            status.add((IStatus)new Status(4, Activator.getPluginId(), ce.getMessage(), (Throwable)ce));
                            throw new CoreException((IStatus)status);
                        }
                        throw ce;
                    }
                    RepositoryProvider.map((IProject)project, (String)GitProvider.class.getName());
                    projectData = GitProjectData.get(project);
                    project.refreshLocal(2, (IProgressMonitor)new SubProgressMonitor(monitor, 50));
                    monitor.worked(10);
                    continue;
                }
                if (GitTraceLocation.CORE.isActive()) {
                    GitTraceLocation.getTrace().trace(GitTraceLocation.CORE.getLocation(), "Attempted to share project without repository ignored :" + project);
                }
                monitor.worked(60);
            }
        }
        finally {
            monitor.done();
        }
    }

    @Override
    public ISchedulingRule getSchedulingRule() {
        Set<IProject> projectSet = this.projects.keySet();
        return new MultiRule((ISchedulingRule[])projectSet.toArray(new IProject[projectSet.size()]));
    }

    private RepositoryMapping findActualRepository(Collection<RepositoryMapping> repos, File suggestedRepo) {
        for (RepositoryMapping rm : repos) {
            if (!rm.getGitDirAbsolutePath().equals((Object)Path.fromOSString((String)suggestedRepo.getPath()))) continue;
            return rm;
        }
        return null;
    }
}

