/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.core.op;

import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.egit.core.Activator;
import org.eclipse.egit.core.CoreText;
import org.eclipse.egit.core.op.IEGitOperation;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.CannotDeleteCurrentBranchException;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.api.errors.NotMergedException;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.osgi.util.NLS;

public class DeleteBranchOperation
implements IEGitOperation {
    public static final int OK = 0;
    public static final int REJECTED_CURRENT = 1;
    public static final int REJECTED_UNMERGED = 2;
    public static final int NOT_TRIED = -1;
    private int status = -1;
    private final Repository repository;
    private final Ref branch;
    private final boolean force;

    public DeleteBranchOperation(Repository repository, Ref branch, boolean force) {
        this.repository = repository;
        this.branch = branch;
        this.force = force;
    }

    public int getStatus() {
        return this.status;
    }

    public void execute(IProgressMonitor m) throws CoreException {
        Object monitor = m == null ? new NullProgressMonitor() : m;
        IWorkspaceRunnable action = new IWorkspaceRunnable(){

            public void run(IProgressMonitor actMonitor) throws CoreException {
                String taskName = NLS.bind((String)CoreText.DeleteBranchOperation_TaskName, (Object)DeleteBranchOperation.this.branch.getName());
                actMonitor.beginTask(taskName, 1);
                try {
                    new Git(DeleteBranchOperation.this.repository).branchDelete().setBranchNames(new String[]{DeleteBranchOperation.this.branch.getName()}).setForce(DeleteBranchOperation.this.force).call();
                    DeleteBranchOperation.this.status = 0;
                }
                catch (NotMergedException notMergedException) {
                    DeleteBranchOperation.this.status = 2;
                }
                catch (CannotDeleteCurrentBranchException cannotDeleteCurrentBranchException) {
                    DeleteBranchOperation.this.status = 1;
                }
                catch (JGitInternalException e) {
                    throw new CoreException(Activator.error(e.getMessage(), e));
                }
                actMonitor.worked(1);
                actMonitor.done();
            }
        };
        ResourcesPlugin.getWorkspace().run(action, monitor);
    }

    public ISchedulingRule getSchedulingRule() {
        return ResourcesPlugin.getWorkspace().getRoot();
    }
}

