/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.core.op;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceRuleFactory;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.MultiRule;
import org.eclipse.egit.core.Activator;
import org.eclipse.egit.core.CoreText;
import org.eclipse.egit.core.internal.util.ProjectUtil;
import org.eclipse.egit.core.op.IEGitOperation;
import org.eclipse.egit.core.project.RepositoryMapping;
import org.eclipse.jgit.dircache.DirCache;
import org.eclipse.jgit.dircache.DirCacheCheckout;
import org.eclipse.jgit.dircache.DirCacheEntry;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiscardChangesOperation
implements IEGitOperation {
    IResource[] files;
    ISchedulingRule schedulingRule;

    public DiscardChangesOperation(IResource[] files) {
        this.files = files;
        this.schedulingRule = DiscardChangesOperation.calcRefreshRule(files);
    }

    @Override
    public ISchedulingRule getSchedulingRule() {
        return this.schedulingRule;
    }

    private static ISchedulingRule calcRefreshRule(IResource[] resources) {
        ArrayList<ISchedulingRule> rules = new ArrayList<ISchedulingRule>();
        IResourceRuleFactory ruleFactory = ResourcesPlugin.getWorkspace().getRuleFactory();
        IResource[] iResourceArray = resources;
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            IResource resource = iResourceArray[n2];
            ISchedulingRule rule = ruleFactory.refreshRule(resource);
            if (rule != null) {
                rules.add(rule);
            }
            ++n2;
        }
        if (rules.size() == 0) {
            return null;
        }
        return new MultiRule((ISchedulingRule[])rules.toArray(new IResource[rules.size()]));
    }

    @Override
    public void execute(IProgressMonitor m) throws CoreException {
        Object monitor = m == null ? new NullProgressMonitor() : m;
        IWorkspaceRunnable action = new IWorkspaceRunnable(){

            public void run(IProgressMonitor actMonitor) throws CoreException {
                DiscardChangesOperation.this.discardChanges(actMonitor);
            }
        };
        ResourcesPlugin.getWorkspace().run(action, this.getSchedulingRule(), 1, monitor);
    }

    private void discardChanges(IProgressMonitor monitor) throws CoreException {
        monitor.beginTask(CoreText.DiscardChangesOperation_discardingChanges, 2);
        boolean errorOccured = false;
        ArrayList<IResource> allFiles = new ArrayList<IResource>();
        IResource[] iResourceArray = this.files;
        int n = this.files.length;
        int n2 = 0;
        while (n2 < n) {
            IResource res = iResourceArray[n2];
            allFiles.addAll(this.getAllMembers(res));
            ++n2;
        }
        for (IResource res : allFiles) {
            Repository repo = DiscardChangesOperation.getRepository(res);
            if (repo == null) {
                IStatus status = Activator.error(CoreText.DiscardChangesOperation_repoNotFound, null);
                throw new CoreException(status);
            }
            try {
                this.discardChange(res, repo);
            }
            catch (IOException e) {
                errorOccured = true;
                String message = NLS.bind((String)CoreText.DiscardChangesOperation_discardFailed, (Object)res.getFullPath());
                Activator.logError(message, e);
            }
        }
        monitor.worked(1);
        try {
            ProjectUtil.refreshResources(this.files, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        }
        catch (CoreException e) {
            errorOccured = true;
            Activator.logError(CoreText.DiscardChangesOperation_refreshFailed, e);
        }
        monitor.worked(1);
        monitor.done();
        if (errorOccured) {
            IStatus status = Activator.error(CoreText.DiscardChangesOperation_discardFailedSeeLog, null);
            throw new CoreException(status);
        }
    }

    private static Repository getRepository(IResource resource) {
        IProject project = resource.getProject();
        RepositoryMapping repositoryMapping = RepositoryMapping.getMapping((IResource)project);
        if (repositoryMapping != null) {
            return repositoryMapping.getRepository();
        }
        return null;
    }

    private void discardChange(IResource res, Repository repository) throws IOException {
        String resRelPath = RepositoryMapping.getMapping(res).getRepoRelativePath(res);
        DirCache dc = repository.lockDirCache();
        try {
            DirCacheEntry entry = dc.getEntry(resRelPath);
            if (entry != null) {
                File file = new File(res.getLocationURI());
                DirCacheCheckout.checkoutEntry((Repository)repository, (File)file, (DirCacheEntry)entry);
            }
        }
        finally {
            dc.unlock();
        }
    }

    private ArrayList<IResource> getAllMembers(IResource res) {
        ArrayList<IResource> ret = new ArrayList<IResource>();
        if (res.getLocation().toFile().isFile()) {
            ret.add(res);
        } else {
            this.getAllMembersHelper(res, ret);
        }
        return ret;
    }

    private void getAllMembersHelper(IResource res, ArrayList<IResource> ret) {
        if (res instanceof IContainer) {
            ArrayList<IResource> tmp = new ArrayList<IResource>();
            IContainer cont = (IContainer)res;
            try {
                IResource[] iResourceArray = cont.members();
                int n = iResourceArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IResource r = iResourceArray[n2];
                    if (r.getLocation().toFile().isFile()) {
                        tmp.add(r);
                    } else {
                        this.getAllMembersHelper(r, tmp);
                    }
                    ++n2;
                }
            }
            catch (CoreException coreException) {
                return;
            }
            ret.addAll(tmp);
        }
    }
}

