/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.core.op;

import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.egit.core.CoreText;
import org.eclipse.jgit.errors.NotSupportedException;
import org.eclipse.jgit.errors.TransportException;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.FetchConnection;
import org.eclipse.jgit.transport.Transport;
import org.eclipse.jgit.transport.URIish;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListRemoteOperation {
    private final Repository localDb;
    private final URIish uri;
    private final int timeout;
    private Map<String, Ref> remoteRefsMap;
    private CredentialsProvider credentialsProvider;

    public ListRemoteOperation(Repository localDb, URIish uri, int timeout) {
        this.localDb = localDb;
        this.uri = uri;
        this.timeout = timeout;
    }

    public Collection<Ref> getRemoteRefs() {
        this.checkState();
        return this.remoteRefsMap.values();
    }

    public Ref getRemoteRef(String refName) {
        this.checkState();
        return this.remoteRefsMap.get(refName);
    }

    public void setCredentialsProvider(CredentialsProvider credentialsProvider) {
        this.credentialsProvider = credentialsProvider;
    }

    public void run(IProgressMonitor pm) throws InvocationTargetException, InterruptedException {
        Transport transport = null;
        FetchConnection connection = null;
        try {
            try {
                transport = Transport.open((Repository)this.localDb, (URIish)this.uri);
                if (this.credentialsProvider != null) {
                    transport.setCredentialsProvider(this.credentialsProvider);
                }
                transport.setTimeout(this.timeout);
                if (pm != null) {
                    pm.beginTask(CoreText.ListRemoteOperation_title, -1);
                }
                connection = transport.openFetch();
                this.remoteRefsMap = connection.getRefsMap();
            }
            catch (NotSupportedException e) {
                throw new InvocationTargetException(e);
            }
            catch (TransportException e) {
                throw new InvocationTargetException(e);
            }
        }
        finally {
            if (connection != null) {
                connection.close();
            }
            if (transport != null) {
                transport.close();
            }
            if (pm != null) {
                pm.done();
            }
        }
    }

    private void checkState() {
        if (this.remoteRefsMap == null) {
            throw new IllegalStateException("Error occurred during remote repo listing, no refs available");
        }
    }
}

