/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.core.op;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.egit.core.CoreText;
import org.eclipse.egit.core.EclipseGitProgressTransformer;
import org.eclipse.egit.core.op.PushOperationResult;
import org.eclipse.egit.core.op.PushOperationSpecification;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.InvalidRemoteException;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.PushResult;
import org.eclipse.jgit.transport.RefSpec;
import org.eclipse.jgit.transport.RemoteConfig;
import org.eclipse.jgit.transport.RemoteRefUpdate;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.osgi.util.NLS;

public class PushOperation {
    private static final int WORK_UNITS_PER_TRANSPORT = 10;
    private final Repository localDb;
    private final PushOperationSpecification specification;
    private final boolean dryRun;
    private final RemoteConfig rc;
    private final int timeout;
    private PushOperationResult operationResult;
    private CredentialsProvider credentialsProvider;

    public PushOperation(Repository localDb, PushOperationSpecification specification, boolean dryRun, int timeout) {
        this.localDb = localDb;
        this.specification = specification;
        this.dryRun = dryRun;
        this.rc = null;
        this.timeout = timeout;
    }

    public PushOperation(Repository localDb, RemoteConfig rc, boolean dryRun, int timeout) {
        this.localDb = localDb;
        this.specification = null;
        this.dryRun = dryRun;
        this.rc = rc;
        this.timeout = timeout;
    }

    public void setCredentialsProvider(CredentialsProvider credentialsProvider) {
        this.credentialsProvider = credentialsProvider;
    }

    public PushOperationResult getOperationResult() {
        if (this.operationResult == null) {
            throw new IllegalStateException(CoreText.OperationNotYetExecuted);
        }
        return this.operationResult;
    }

    public PushOperationSpecification getSpecification() {
        return this.specification;
    }

    public void run(IProgressMonitor actMonitor) throws InvocationTargetException {
        if (this.operationResult != null) {
            throw new IllegalStateException(CoreText.OperationAlreadyExecuted);
        }
        if (this.specification != null) {
            for (URIish uri : this.specification.getURIs()) {
                for (RemoteRefUpdate update : this.specification.getRefUpdates(uri)) {
                    if (update.getStatus() == RemoteRefUpdate.Status.NOT_ATTEMPTED) continue;
                    throw new IllegalStateException(CoreText.RemoteRefUpdateCantBeReused);
                }
            }
        }
        Object monitor = actMonitor == null ? new NullProgressMonitor() : actMonitor;
        int totalWork = this.specification != null ? this.specification.getURIsNumber() * 10 : 1;
        if (this.dryRun) {
            monitor.beginTask(CoreText.PushOperation_taskNameDryRun, totalWork);
        } else {
            monitor.beginTask(CoreText.PushOperation_taskNameNormalRun, totalWork);
        }
        this.operationResult = new PushOperationResult();
        Git git = new Git(this.localDb);
        if (this.specification != null) {
            for (URIish uri : this.specification.getURIs()) {
                SubProgressMonitor subMonitor = new SubProgressMonitor(monitor, 10, 4);
                try {
                    ArrayList<RefSpec> specs = new ArrayList<RefSpec>(3);
                    for (RemoteRefUpdate update : this.specification.getRefUpdates(uri)) {
                        RefSpec spec = new RefSpec();
                        spec = spec.setSourceDestination(update.getSrcRef(), update.getRemoteName());
                        spec = spec.setForceUpdate(update.isForceUpdate());
                        specs.add(spec);
                    }
                    if (monitor.isCanceled()) {
                        this.operationResult.addOperationResult(uri, CoreText.PushOperation_resultCancelled);
                        continue;
                    }
                    EclipseGitProgressTransformer gitSubMonitor = new EclipseGitProgressTransformer((IProgressMonitor)subMonitor);
                    try {
                        Iterable results = git.push().setRemote(uri.toPrivateString()).setRefSpecs(specs).setDryRun(this.dryRun).setTimeout(this.timeout).setProgressMonitor((ProgressMonitor)gitSubMonitor).setCredentialsProvider(this.credentialsProvider).call();
                        for (PushResult result : results) {
                            this.operationResult.addOperationResult(result.getURI(), result);
                            this.specification.addURIRefUpdates(result.getURI(), result.getRemoteUpdates());
                        }
                    }
                    catch (JGitInternalException e) {
                        String errorMessage = e.getCause() != null ? e.getCause().getMessage() : e.getMessage();
                        String userMessage = NLS.bind((String)CoreText.PushOperation_InternalExceptionOccuredMessage, (Object)errorMessage);
                        this.operationResult.addOperationResult(uri, userMessage);
                    }
                    catch (InvalidRemoteException e) {
                        this.operationResult.addOperationResult(uri, e.getMessage());
                    }
                    monitor.worked(10);
                }
                finally {
                    subMonitor.beginTask("", 10);
                    subMonitor.done();
                    subMonitor.done();
                }
            }
        } else {
            EclipseGitProgressTransformer gitMonitor = new EclipseGitProgressTransformer((IProgressMonitor)monitor);
            try {
                Iterable results = git.push().setRemote(this.rc.getName()).setDryRun(this.dryRun).setTimeout(this.timeout).setProgressMonitor((ProgressMonitor)gitMonitor).setCredentialsProvider(this.credentialsProvider).call();
                for (PushResult result : results) {
                    this.operationResult.addOperationResult(result.getURI(), result);
                }
            }
            catch (JGitInternalException e) {
                String errorMessage = e.getCause() != null ? e.getCause().getMessage() : e.getMessage();
                String userMessage = NLS.bind((String)CoreText.PushOperation_InternalExceptionOccuredMessage, (Object)errorMessage);
                URIish uri = this.rc.getPushURIs().isEmpty() ? (URIish)this.rc.getURIs().get(0) : (URIish)this.rc.getPushURIs().get(0);
                this.operationResult.addOperationResult(uri, userMessage);
            }
            catch (InvalidRemoteException e) {
                URIish uri = this.rc.getPushURIs().isEmpty() ? (URIish)this.rc.getURIs().get(0) : (URIish)this.rc.getPushURIs().get(0);
                this.operationResult.addOperationResult(uri, e.getMessage());
            }
        }
        monitor.done();
    }
}

