/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.core.op;

import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.egit.core.Activator;
import org.eclipse.egit.core.CoreText;
import org.eclipse.egit.core.EclipseGitProgressTransformer;
import org.eclipse.egit.core.op.IEGitOperation;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.RebaseCommand;
import org.eclipse.jgit.api.RebaseResult;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.api.errors.NoHeadException;
import org.eclipse.jgit.api.errors.RefNotFoundException;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;

public class RebaseOperation
implements IEGitOperation {
    private final Repository repository;
    private final Ref ref;
    private final RebaseCommand.Operation operation;
    private RebaseResult result;

    public RebaseOperation(Repository repository, Ref ref) {
        this.repository = repository;
        this.operation = RebaseCommand.Operation.BEGIN;
        this.ref = ref;
    }

    public RebaseOperation(Repository repository, RebaseCommand.Operation operation) {
        this.repository = repository;
        this.operation = operation;
        this.ref = null;
    }

    public void execute(IProgressMonitor m) throws CoreException {
        if (this.result != null) {
            throw new CoreException((IStatus)new Status(4, Activator.getPluginId(), CoreText.OperationAlreadyExecuted));
        }
        Object monitor = m == null ? new NullProgressMonitor() : m;
        IWorkspaceRunnable action = new IWorkspaceRunnable(){

            public void run(IProgressMonitor actMonitor) throws CoreException {
                RebaseCommand cmd = new Git(RebaseOperation.this.repository).rebase().setProgressMonitor((ProgressMonitor)new EclipseGitProgressTransformer(actMonitor));
                try {
                    if (RebaseOperation.this.operation == RebaseCommand.Operation.BEGIN) {
                        RebaseOperation.this.result = cmd.setUpstream(RebaseOperation.this.ref.getName()).call();
                    } else {
                        RebaseOperation.this.result = cmd.setOperation(RebaseOperation.this.operation).call();
                    }
                }
                catch (NoHeadException e) {
                    throw new CoreException(Activator.error(e.getMessage(), e));
                }
                catch (RefNotFoundException e) {
                    throw new CoreException(Activator.error(e.getMessage(), e));
                }
                catch (JGitInternalException e) {
                    throw new CoreException(Activator.error(e.getMessage(), e));
                }
                catch (GitAPIException e) {
                    throw new CoreException(Activator.error(e.getMessage(), e));
                }
            }
        };
        ResourcesPlugin.getWorkspace().run(action, monitor);
    }

    public ISchedulingRule getSchedulingRule() {
        return ResourcesPlugin.getWorkspace().getRoot();
    }

    public RebaseResult getResult() {
        return this.result;
    }
}

