/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.core.op;

import java.io.IOException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.egit.core.CoreText;
import org.eclipse.egit.core.internal.util.ProjectUtil;
import org.eclipse.egit.core.op.IEGitOperation;
import org.eclipse.jgit.dircache.DirCache;
import org.eclipse.jgit.dircache.DirCacheBuilder;
import org.eclipse.jgit.dircache.DirCacheCheckout;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.RefUpdate;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.RepositoryState;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.osgi.util.NLS;
import org.eclipse.team.core.TeamException;

public class ResetOperation
implements IEGitOperation {
    private final Repository repository;
    private final String refName;
    private final ResetType type;
    private RevCommit commit;

    public ResetOperation(Repository repository, String refName, ResetType type) {
        this.repository = repository;
        this.refName = refName;
        this.type = type;
    }

    public ISchedulingRule getSchedulingRule() {
        if (this.type == ResetType.HARD) {
            return ResourcesPlugin.getWorkspace().getRoot();
        }
        return null;
    }

    public void execute(IProgressMonitor m) throws CoreException {
        Object monitor = m == null ? new NullProgressMonitor() : m;
        if (this.type == ResetType.HARD) {
            IWorkspaceRunnable action = new IWorkspaceRunnable(){

                public void run(IProgressMonitor actMonitor) throws CoreException {
                    ResetOperation.this.reset(actMonitor);
                }
            };
            ResourcesPlugin.getWorkspace().run(action, monitor);
        } else {
            this.reset((IProgressMonitor)monitor);
        }
    }

    private void reset(IProgressMonitor monitor) throws CoreException {
        monitor.beginTask(NLS.bind((String)CoreText.ResetOperation_performingReset, (Object)this.type.toString().toLowerCase(), (Object)this.refName), 3);
        IProject[] validProjects = null;
        if (this.type == ResetType.HARD) {
            validProjects = ProjectUtil.getValidProjects(this.repository);
        }
        boolean merging = false;
        if (this.repository.getRepositoryState().equals((Object)RepositoryState.MERGING) || this.repository.getRepositoryState().equals((Object)RepositoryState.MERGING_RESOLVED)) {
            merging = true;
        }
        this.mapObjects();
        monitor.worked(1);
        this.writeRef();
        monitor.worked(1);
        switch (this.type) {
            case HARD: {
                this.checkoutIndex();
                monitor.worked(1);
                if (merging) {
                    this.resetMerge();
                }
                monitor.worked(1);
                ProjectUtil.refreshValidProjects(validProjects, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                monitor.worked(1);
                break;
            }
            case MIXED: {
                this.resetIndex();
                monitor.worked(2);
                if (merging) {
                    this.resetMerge();
                }
                monitor.worked(1);
                break;
            }
            case SOFT: {
                monitor.worked(3);
            }
        }
        monitor.done();
    }

    private void resetMerge() throws CoreException {
        try {
            this.repository.writeMergeHeads(null);
            this.repository.writeMergeCommitMsg(null);
        }
        catch (IOException e) {
            throw new TeamException(CoreText.ResetOperation_resetMergeFailed, (Throwable)e);
        }
    }

    private void mapObjects() throws TeamException {
        ObjectId commitId;
        try {
            commitId = this.repository.resolve(this.refName);
        }
        catch (IOException e) {
            throw new TeamException(NLS.bind((String)CoreText.ResetOperation_lookingUpRef, (Object)this.refName), (Throwable)e);
        }
        RevWalk rw = new RevWalk(this.repository);
        try {
            try {
                this.commit = rw.parseCommit((AnyObjectId)commitId);
            }
            catch (IOException e) {
                throw new TeamException(NLS.bind((String)CoreText.ResetOperation_lookingUpCommit, (Object)commitId), (Throwable)e);
            }
        }
        finally {
            rw.release();
        }
    }

    private void writeRef() throws TeamException {
        try {
            RefUpdate ru = this.repository.updateRef("HEAD");
            ru.setNewObjectId((AnyObjectId)this.commit.getId());
            String name = this.refName;
            if (name.startsWith("refs/heads/")) {
                name = name.substring(11);
            }
            if (name.startsWith("refs/remotes/")) {
                name = name.substring(13);
            }
            String message = "reset --" + this.type.toString().toLowerCase() + " " + name;
            ru.setRefLogMessage(message, false);
            if (ru.forceUpdate() == RefUpdate.Result.LOCK_FAILURE) {
                throw new TeamException(NLS.bind((String)CoreText.ResetOperation_cantUpdate, (Object)ru.getName()));
            }
        }
        catch (IOException e) {
            throw new TeamException(NLS.bind((String)CoreText.ResetOperation_updatingFailed, (Object)"HEAD"), (Throwable)e);
        }
    }

    private void resetIndex() throws TeamException {
        DirCache dc = null;
        try {
            try {
                dc = this.repository.lockDirCache();
                dc.clear();
                DirCacheBuilder dcb = dc.builder();
                dcb.addTree(new byte[0], 0, this.repository.newObjectReader(), (AnyObjectId)this.commit.getTree());
                dcb.commit();
            }
            catch (IOException e) {
                throw new TeamException(CoreText.ResetOperation_readingIndex, (Throwable)e);
            }
        }
        finally {
            if (dc != null) {
                dc.unlock();
            }
        }
    }

    private void checkoutIndex() throws TeamException {
        DirCache dc = null;
        try {
            try {
                dc = this.repository.lockDirCache();
                DirCacheCheckout checkout = new DirCacheCheckout(this.repository, dc, (ObjectId)this.commit.getTree());
                checkout.setFailOnConflict(false);
                checkout.checkout();
            }
            catch (IOException e) {
                throw new TeamException(CoreText.ResetOperation_mappingTreeForCommit, (Throwable)e);
            }
        }
        finally {
            if (dc != null) {
                dc.unlock();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ResetType {
        SOFT,
        MIXED,
        HARD;

    }
}

