/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.core.project;

import java.io.File;
import java.io.IOException;
import java.util.Properties;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.egit.core.GitProvider;
import org.eclipse.egit.core.project.GitProjectData;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.team.core.RepositoryProvider;

public class RepositoryMapping {
    private final String containerPathString;
    private IPath containerPath;
    private final String gitDirPathString;
    private IPath gitDirPath;
    private IPath gitDirAbsolutePath;
    private Repository db;
    private String workdirPrefix;
    private IContainer container;

    static boolean isInitialKey(String key) {
        return key.endsWith(".gitdir");
    }

    public RepositoryMapping(Properties p, String initialKey) {
        int dot = initialKey.lastIndexOf(46);
        this.containerPathString = initialKey.substring(0, dot);
        this.gitDirPathString = p.getProperty(initialKey);
    }

    public RepositoryMapping(IContainer mappedContainer, File gitDir) {
        IPath cLoc = mappedContainer.getLocation().removeTrailingSeparator();
        IPath gLoc = Path.fromOSString((String)gitDir.getAbsolutePath()).removeTrailingSeparator();
        IPath gLocParent = gLoc.removeLastSegments(1);
        this.container = mappedContainer;
        this.containerPathString = this.container.getProjectRelativePath().toPortableString();
        if (cLoc.isPrefixOf(gLoc)) {
            int matchingSegments = gLoc.matchingFirstSegments(cLoc);
            IPath remainder = gLoc.removeFirstSegments(matchingSegments);
            String device = remainder.getDevice();
            this.gitDirPathString = device == null ? remainder.toPortableString() : remainder.toPortableString().substring(device.length());
        } else if (gLocParent.isPrefixOf(cLoc)) {
            int cnt = cLoc.segmentCount() - cLoc.matchingFirstSegments(gLocParent);
            StringBuilder p = new StringBuilder("");
            while (cnt-- > 0) {
                p.append("../");
            }
            p.append(gLoc.segment(gLoc.segmentCount() - 1));
            this.gitDirPathString = p.toString();
        } else {
            this.gitDirPathString = gLoc.toPortableString();
        }
    }

    public IPath getContainerPath() {
        if (this.containerPath == null) {
            this.containerPath = Path.fromPortableString((String)this.containerPathString);
        }
        return this.containerPath;
    }

    IPath getGitDirPath() {
        if (this.gitDirPath == null) {
            this.gitDirPath = Path.fromPortableString((String)this.gitDirPathString);
        }
        return this.gitDirPath;
    }

    public File getWorkTree() {
        return this.getRepository().getWorkTree();
    }

    synchronized void clear() {
        this.db = null;
        this.workdirPrefix = null;
        this.container = null;
    }

    public synchronized Repository getRepository() {
        return this.db;
    }

    synchronized void setRepository(Repository r) {
        this.db = r;
        try {
            this.workdirPrefix = this.getWorkTree().getCanonicalPath();
        }
        catch (IOException iOException) {
            this.workdirPrefix = this.getWorkTree().getAbsolutePath();
        }
        this.workdirPrefix = this.workdirPrefix.replace('\\', '/');
        if (!this.workdirPrefix.endsWith("/")) {
            this.workdirPrefix = String.valueOf(this.workdirPrefix) + "/";
        }
    }

    public synchronized IContainer getContainer() {
        return this.container;
    }

    synchronized void setContainer(IContainer c) {
        this.container = c;
    }

    public void fireRepositoryChanged() {
        GitProjectData.fireRepositoryChanged(this);
    }

    synchronized void store(Properties p) {
        p.setProperty(String.valueOf(this.containerPathString) + ".gitdir", this.gitDirPathString);
    }

    public String toString() {
        return "RepositoryMapping[" + this.containerPathString + " -> " + this.gitDirPathString + "]";
    }

    public String getRepoRelativePath(IResource rsrc) {
        int pfxLen = this.workdirPrefix.length();
        IPath location = rsrc.getLocation();
        if (location == null) {
            return null;
        }
        String p = location.toString();
        int pLen = p.length();
        if (pLen > pfxLen) {
            return p.substring(pfxLen);
        }
        if (p.length() == pfxLen - 1) {
            return "";
        }
        return null;
    }

    public static RepositoryMapping getMapping(IResource resource) {
        IProject project = resource.getProject();
        if (project == null) {
            return null;
        }
        RepositoryProvider rp = RepositoryProvider.getProvider((IProject)project);
        if (!(rp instanceof GitProvider)) {
            return null;
        }
        if (((GitProvider)rp).getData() == null) {
            return null;
        }
        return ((GitProvider)rp).getData().getRepositoryMapping(resource);
    }

    public String getGitDir() {
        return this.gitDirPathString;
    }

    public IPath getGitDirAbsolutePath() {
        if (this.gitDirAbsolutePath == null) {
            this.gitDirAbsolutePath = this.container.getLocation().append(this.getGitDirPath());
        }
        return this.gitDirAbsolutePath;
    }
}

