/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.core.securestorage;

import java.io.IOException;
import org.eclipse.egit.core.securestorage.UserPasswordCredentials;
import org.eclipse.equinox.security.storage.EncodingUtils;
import org.eclipse.equinox.security.storage.ISecurePreferences;
import org.eclipse.equinox.security.storage.StorageException;
import org.eclipse.jgit.transport.URIish;

public class EGitSecureStore {
    private static final String USER = "user";
    private static final String PASSWORD = "password";
    private static final String GIT_PATH_PREFIX = "/GIT/";
    private final ISecurePreferences preferences;

    public EGitSecureStore(ISecurePreferences preferences) {
        this.preferences = preferences;
    }

    public void putCredentials(URIish uri, UserPasswordCredentials credentials) throws StorageException, IOException {
        String pathName = this.calcNodePath(uri);
        ISecurePreferences node = this.preferences.node(pathName);
        node.put(USER, credentials.getUser(), false);
        node.put(PASSWORD, credentials.getPassword(), true);
        node.flush();
    }

    public UserPasswordCredentials getCredentials(URIish uri) throws StorageException {
        String pathName = this.calcNodePath(uri);
        if (!this.preferences.nodeExists(pathName)) {
            return null;
        }
        ISecurePreferences node = this.preferences.node(pathName);
        String user = node.get(USER, "");
        String password = node.get(PASSWORD, "");
        if (uri.getUser() != null && !user.equals(uri.getUser())) {
            return null;
        }
        return new UserPasswordCredentials(user, password);
    }

    private String calcNodePath(URIish uri) {
        URIish storedURI = uri.setUser(null).setPass(null);
        String pathName = GIT_PATH_PREFIX + EncodingUtils.encodeSlashes((String)storedURI.toString());
        return pathName;
    }

    public void clearCredentials(URIish uri) throws IOException {
        String pathName = this.calcNodePath(uri);
        if (!this.preferences.nodeExists(pathName)) {
            return;
        }
        ISecurePreferences node = this.preferences.node(pathName);
        node.removeNode();
        node.flush();
    }
}

