/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.core.synchronize;

import java.io.IOException;
import java.util.ArrayList;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.egit.core.CoreText;
import org.eclipse.egit.core.synchronize.GitBlobResourceVariant;
import org.eclipse.egit.core.synchronize.GitResourceVariant;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.treewalk.AbstractTreeIterator;
import org.eclipse.jgit.treewalk.FileTreeIterator;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.treewalk.filter.NotIgnoredFilter;
import org.eclipse.jgit.treewalk.filter.TreeFilter;
import org.eclipse.osgi.util.NLS;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.variants.IResourceVariant;

public class GitFolderResourceVariant
extends GitResourceVariant {
    private IResourceVariant[] members;

    GitFolderResourceVariant(Repository repo, RevCommit revCommit, ObjectId objectId, String path) throws IOException {
        super(repo, revCommit, objectId, path);
    }

    public boolean isContainer() {
        return true;
    }

    public IStorage getStorage(IProgressMonitor monitor) throws TeamException {
        return null;
    }

    public IResourceVariant[] getMembers(IProgressMonitor progress) throws IOException {
        if (this.members != null) {
            try {
                IResourceVariant[] iResourceVariantArray = this.members;
                return iResourceVariantArray;
            }
            finally {
                progress.done();
            }
        }
        Repository repo = this.getRepository();
        TreeWalk tw = new TreeWalk(repo);
        tw.reset();
        int nth = tw.addTree((AnyObjectId)this.getObjectId());
        int iteratorNth = tw.addTree((AbstractTreeIterator)new FileTreeIterator(repo));
        tw.setFilter((TreeFilter)new NotIgnoredFilter(iteratorNth));
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress);
        monitor.beginTask(NLS.bind((String)CoreText.GitFolderResourceVariant_fetchingMembers, (Object)this), tw.getTreeCount());
        int i = 0;
        ArrayList<GitResourceVariant> result = new ArrayList<GitResourceVariant>();
        try {
            while (tw.next()) {
                if (monitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
                ObjectId newObjectId = tw.getObjectId(nth);
                String path = String.valueOf(this.getPath()) + "/" + new String(tw.getRawPath());
                if (!newObjectId.equals((AnyObjectId)ObjectId.zeroId())) {
                    if (tw.isSubtree()) {
                        result.add(new GitFolderResourceVariant(repo, this.getRevCommit(), newObjectId, path));
                    } else {
                        result.add(new GitBlobResourceVariant(repo, this.getRevCommit(), newObjectId, path));
                    }
                }
                if (i % 10 == 0) {
                    monitor.worked(10);
                }
                ++i;
            }
            IResourceVariant[] iResourceVariantArray = this.members = result.toArray(new IResourceVariant[result.size()]);
            return iResourceVariantArray;
        }
        finally {
            monitor.done();
        }
    }
}

