/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.core.synchronize;

import java.io.File;
import java.io.IOException;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.team.core.variants.IResourceVariant;

abstract class GitResourceVariant
implements IResourceVariant {
    private final String path;
    private final Repository repo;
    private final ObjectId objectId;
    private final RevCommit revCommit;
    private String name;
    private IPath fullPath;
    private static final IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();

    GitResourceVariant(Repository repo, RevCommit revCommit, ObjectId objectId, String path) throws IOException {
        this.path = path;
        this.repo = repo;
        this.objectId = objectId;
        this.revCommit = revCommit;
    }

    public String getContentIdentifier() {
        return String.valueOf(this.revCommit.abbreviate(7).name()) + "...";
    }

    public String getName() {
        if (this.name == null && this.path != null) {
            int lastSeparator = this.path.lastIndexOf(47);
            this.name = lastSeparator > -1 ? this.path.substring(lastSeparator + 1) : this.path;
        }
        return this.name;
    }

    public RevCommit getRevCommit() {
        return this.revCommit;
    }

    public int hashCode() {
        return this.objectId.getName().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof GitResourceVariant) {
            return this.objectId.equals((AnyObjectId)((GitResourceVariant)obj).getObjectId());
        }
        return false;
    }

    public byte[] asBytes() {
        return this.getObjectId().getName().getBytes();
    }

    public String toString() {
        return String.valueOf(this.path) + "(" + this.objectId.getName() + ")";
    }

    protected ObjectId getObjectId() {
        return this.objectId;
    }

    protected Repository getRepository() {
        return this.repo;
    }

    protected String getPath() {
        return this.path;
    }

    protected IPath getFullPath() {
        if (this.fullPath == null) {
            Path location = new Path(this.repo.getWorkTree() + File.separator + this.path);
            Object resource = this.isContainer() ? workspaceRoot.getContainerForLocation((IPath)location) : workspaceRoot.getFileForLocation((IPath)location);
            this.fullPath = resource != null ? resource.getFullPath() : new Path(this.path);
        }
        return this.fullPath;
    }

    public boolean exists() {
        return true;
    }
}

