/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.core.synchronize;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.egit.core.CoreText;
import org.eclipse.egit.core.synchronize.GitBlobResourceVariant;
import org.eclipse.egit.core.synchronize.GitFolderResourceVariant;
import org.eclipse.egit.core.synchronize.dto.GitSynchronizeData;
import org.eclipse.egit.core.synchronize.dto.GitSynchronizeDataSet;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.treewalk.filter.PathFilter;
import org.eclipse.jgit.treewalk.filter.TreeFilter;
import org.eclipse.osgi.util.NLS;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.variants.IResourceVariant;
import org.eclipse.team.core.variants.ResourceVariantByteStore;
import org.eclipse.team.core.variants.ResourceVariantTree;

abstract class GitResourceVariantTree
extends ResourceVariantTree {
    private final GitSynchronizeDataSet gsds;
    private final Map<IResource, IResourceVariant> cache = new HashMap<IResource, IResourceVariant>();

    GitResourceVariantTree(ResourceVariantByteStore store, GitSynchronizeDataSet gsds) {
        super(store);
        this.gsds = gsds;
    }

    public IResource[] roots() {
        HashSet<IProject> roots = new HashSet<IProject>();
        for (GitSynchronizeData gsd : this.gsds) {
            roots.addAll(gsd.getProjects());
        }
        return roots.toArray(new IResource[roots.size()]);
    }

    protected IResourceVariant fetchVariant(IResource resource, int depth, IProgressMonitor monitor) throws TeamException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor);
        if (resource == null || resource.getLocation() == null) {
            subMonitor.done();
            return null;
        }
        subMonitor.beginTask(NLS.bind((String)CoreText.GitResourceVariantTree_fetchingVariant, (Object)resource.getName()), -1);
        try {
            IResourceVariant iResourceVariant = this.fetchVariant(resource, (IProgressMonitor)subMonitor);
            return iResourceVariant;
        }
        finally {
            subMonitor.done();
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private IResourceVariant fetchVariant(IResource resource, IProgressMonitor monitor) throws TeamException {
        if (this.cache.containsKey(resource)) {
            return this.cache.get(resource);
        }
        GitSynchronizeData gsd = this.gsds.getData(resource.getProject());
        if (gsd == null) {
            return null;
        }
        Repository repo = gsd.getRepository();
        String path = this.getPath(resource, repo);
        RevCommit revCommit = this.getRevCommit(gsd);
        if (revCommit == null) {
            return null;
        }
        if (path.length() == 0) {
            return this.handleRepositoryRoot(resource, repo, revCommit);
        }
        try {
            void var9_13;
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            TreeWalk tw = this.initializeTreeWalk(repo, path);
            int nth = tw.addTree((AnyObjectId)revCommit.getTree());
            Object var9_10 = null;
            if (resource.getType() == 1) {
                tw.setRecursive(true);
                if (tw.next() && !tw.getObjectId(nth).equals((AnyObjectId)ObjectId.zeroId())) {
                    GitBlobResourceVariant gitBlobResourceVariant = new GitBlobResourceVariant(repo, revCommit, tw.getObjectId(nth), path);
                }
            } else {
                while (true) {
                    if (!tw.next() || path.equals(tw.getPathString())) {
                        ObjectId objectId = tw.getObjectId(nth);
                        if (objectId.equals((AnyObjectId)ObjectId.zeroId())) break;
                        GitFolderResourceVariant gitFolderResourceVariant = new GitFolderResourceVariant(repo, revCommit, objectId, path);
                        break;
                    }
                    if (monitor.isCanceled()) {
                        throw new OperationCanceledException();
                    }
                    if (!tw.isSubtree()) continue;
                    tw.enterSubtree();
                }
            }
            if (var9_13 != null) {
                this.cache.put(resource, (IResourceVariant)var9_13);
            }
            return var9_13;
        }
        catch (IOException e) {
            throw new TeamException(NLS.bind((String)CoreText.GitResourceVariantTree_couldNotFindResourceVariant, (Object)resource), (Throwable)e);
        }
    }

    protected IResourceVariant[] fetchMembers(IResourceVariant variant, IProgressMonitor progress) throws TeamException {
        if (variant == null || !(variant instanceof GitFolderResourceVariant)) {
            return new IResourceVariant[0];
        }
        GitFolderResourceVariant gitVariant = (GitFolderResourceVariant)variant;
        try {
            return gitVariant.getMembers(progress);
        }
        catch (IOException e) {
            throw new TeamException(NLS.bind((String)CoreText.GitResourceVariantTree_couldNotFetchMembers, (Object)gitVariant), (Throwable)e);
        }
    }

    public IResourceVariant getResourceVariant(IResource resource) throws TeamException {
        return this.fetchVariant(resource, 0, null);
    }

    protected abstract RevCommit getRevCommit(GitSynchronizeData var1) throws TeamException;

    private IResourceVariant handleRepositoryRoot(IResource resource, Repository repo, RevCommit revCommit) throws TeamException {
        try {
            return new GitFolderResourceVariant(repo, revCommit, (ObjectId)revCommit.getTree(), resource.getLocation().toString());
        }
        catch (IOException e) {
            throw new TeamException(NLS.bind((String)CoreText.GitResourceVariantTree_couldNotFindResourceVariant, (Object)resource), (Throwable)e);
        }
    }

    private TreeWalk initializeTreeWalk(Repository repo, String path) {
        TreeWalk tw = new TreeWalk(repo);
        tw.reset();
        tw.setFilter((TreeFilter)PathFilter.create((String)path));
        return tw;
    }

    private String getPath(IResource resource, Repository repo) {
        return Repository.stripWorkDir((File)repo.getWorkTree(), (File)resource.getLocation().toFile());
    }
}

