/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.core.synchronize;

import org.eclipse.core.resources.IResource;
import org.eclipse.egit.core.CoreText;
import org.eclipse.egit.core.synchronize.GitBaseResourceVariantTree;
import org.eclipse.egit.core.synchronize.GitRemoteResourceVariantTree;
import org.eclipse.egit.core.synchronize.GitResourceVariantComparator;
import org.eclipse.egit.core.synchronize.GitSyncInfo;
import org.eclipse.egit.core.synchronize.dto.GitSynchronizeData;
import org.eclipse.egit.core.synchronize.dto.GitSynchronizeDataSet;
import org.eclipse.team.core.Team;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.synchronize.SyncInfo;
import org.eclipse.team.core.variants.IResourceVariant;
import org.eclipse.team.core.variants.IResourceVariantComparator;
import org.eclipse.team.core.variants.IResourceVariantTree;
import org.eclipse.team.core.variants.ResourceVariantTreeSubscriber;

public class GitResourceVariantTreeSubscriber
extends ResourceVariantTreeSubscriber {
    private IResourceVariantTree remoteTree;
    private IResourceVariantTree baseTree;
    private GitSynchronizeDataSet gsds;
    private IResource[] roots;

    public GitResourceVariantTreeSubscriber(GitSynchronizeDataSet data) {
        this.gsds = data;
    }

    public boolean isSupervised(IResource resource) throws TeamException {
        return this.gsds.contains(resource.getProject()) && !Team.isIgnoredHint((IResource)resource);
    }

    public IResource[] roots() {
        if (this.roots != null) {
            return this.roots;
        }
        this.roots = this.gsds.getAllProjects();
        return this.roots;
    }

    public void reset(GitSynchronizeDataSet data) {
        this.gsds = data;
        this.roots = null;
        this.baseTree = null;
        this.remoteTree = null;
    }

    public String getName() {
        return CoreText.GitBranchResourceVariantTreeSubscriber_gitRepository;
    }

    public IResourceVariantComparator getResourceComparator() {
        return new GitResourceVariantComparator(this.gsds);
    }

    protected IResourceVariantTree getBaseTree() {
        if (this.baseTree == null) {
            this.baseTree = new GitBaseResourceVariantTree(this.gsds);
        }
        return this.baseTree;
    }

    protected IResourceVariantTree getRemoteTree() {
        if (this.remoteTree == null) {
            this.remoteTree = new GitRemoteResourceVariantTree(this.gsds);
        }
        return this.remoteTree;
    }

    protected SyncInfo getSyncInfo(IResource local, IResourceVariant base, IResourceVariant remote) throws TeamException {
        GitSynchronizeData gsd = this.gsds.getData(local.getProject());
        Object info = gsd.shouldIncludeLocal() ? new SyncInfo(local, base, remote, this.getResourceComparator()) : new GitSyncInfo(local, base, remote, this.getResourceComparator(), gsd);
        info.init();
        return info;
    }
}

