/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.core.synchronize;

import java.io.File;
import java.io.IOException;
import org.eclipse.core.resources.IResource;
import org.eclipse.egit.core.Activator;
import org.eclipse.egit.core.synchronize.GitResourceVariant;
import org.eclipse.egit.core.synchronize.dto.GitSynchronizeData;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevFlag;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.treewalk.filter.AndTreeFilter;
import org.eclipse.jgit.treewalk.filter.PathFilter;
import org.eclipse.jgit.treewalk.filter.TreeFilter;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.synchronize.SyncInfo;
import org.eclipse.team.core.variants.IResourceVariant;
import org.eclipse.team.core.variants.IResourceVariantComparator;

class GitSyncInfo
extends SyncInfo {
    private final GitSynchronizeData gsd;

    public GitSyncInfo(IResource local, IResourceVariant base, IResourceVariant remote, IResourceVariantComparator comparator, GitSynchronizeData gsd) {
        super(local, base, remote, comparator);
        this.gsd = gsd;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof GitSyncInfo) {
            boolean equalGsd;
            GitSynchronizeData otherGsd = ((GitSyncInfo)((Object)other)).gsd;
            boolean bl = equalGsd = this.gsd.getProjects().equals(otherGsd.getProjects()) && this.gsd.getRepository().equals(otherGsd.getRepository()) && this.gsd.getDstRevCommit().equals((AnyObjectId)otherGsd.getDstRevCommit()) && this.gsd.getSrcRevCommit().equals((AnyObjectId)otherGsd.getSrcRevCommit());
            return super.equals(other) && equalGsd;
        }
        return false;
    }

    public int hashCode() {
        return this.gsd.getSrcRevCommit().hashCode() ^ this.getLocal().hashCode();
    }

    protected int calculateKind() throws TeamException {
        String localPath;
        Repository repo = this.gsd.getRepository();
        if (this.getLocal().exists()) {
            File local = this.getLocal().getLocation().toFile();
            localPath = Repository.stripWorkDir((File)repo.getWorkTree(), (File)local);
        } else if (this.getRemote() != null) {
            localPath = ((GitResourceVariant)this.getRemote()).getFullPath().toString();
        } else if (this.getBase() != null) {
            localPath = ((GitResourceVariant)this.getBase()).getFullPath().toString();
        } else {
            return super.calculateKind();
        }
        if (localPath.length() == 0) {
            return 0;
        }
        TreeWalk tw = new TreeWalk(repo);
        tw.setFilter(AndTreeFilter.create((TreeFilter)TreeFilter.ANY_DIFF, (TreeFilter)PathFilter.create((String)localPath)));
        tw.setRecursive(true);
        try {
            int srcNth = tw.addTree((AnyObjectId)this.gsd.getSrcRevCommit().getTree());
            int dstNth = tw.addTree((AnyObjectId)this.gsd.getDstRevCommit().getTree());
            if (tw.next()) {
                return this.calculateKindImpl(repo, tw, srcNth, dstNth);
            }
        }
        catch (IOException e) {
            Activator.logError(e.getMessage(), e);
        }
        return 0;
    }

    private int calculateKindImpl(Repository repo, TreeWalk tw, int srcNth, int dstNth) throws IOException {
        ObjectId srcId = tw.getObjectId(srcNth);
        ObjectId dstId = tw.getObjectId(dstNth);
        if (srcId.equals((AnyObjectId)ObjectId.zeroId())) {
            return 9;
        }
        if (dstId.equals((AnyObjectId)ObjectId.zeroId())) {
            return 5;
        }
        if (!srcId.equals((AnyObjectId)dstId)) {
            RevWalk rw = new RevWalk(repo);
            RevFlag srcFlag = rw.newFlag("source");
            RevFlag dstFlag = rw.newFlag("destination");
            this.initializeRevWalk(rw, srcFlag, dstFlag);
            RevCommit commit = rw.next();
            if (commit.has(srcFlag)) {
                return 7;
            }
            if (commit.has(dstFlag)) {
                return 11;
            }
            return 15;
        }
        return 0;
    }

    private void initializeRevWalk(RevWalk rw, RevFlag srcFlag, RevFlag dstFlag) throws IOException {
        RevCommit srcCommit = rw.parseCommit((AnyObjectId)this.gsd.getSrcRevCommit());
        srcCommit.add(srcFlag);
        RevCommit dstCommit = rw.parseCommit((AnyObjectId)this.gsd.getDstRevCommit());
        dstCommit.add(dstFlag);
        rw.markStart(srcCommit);
        rw.markStart(dstCommit);
        rw.carry(srcFlag);
        rw.carry(dstFlag);
    }
}

