/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.core.synchronize.dto;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.egit.core.RevUtils;
import org.eclipse.egit.core.project.RepositoryMapping;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.ObjectWalk;
import org.eclipse.jgit.revwalk.RevCommit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GitSynchronizeData {
    private static final IWorkspaceRoot ROOT = ResourcesPlugin.getWorkspace().getRoot();
    private final boolean includeLocal;
    private final Repository repo;
    private final RevCommit srcRev;
    private final RevCommit dstRev;
    private final RevCommit commonAncestorRev;
    private final Set<IProject> projects;
    private final String repoParentPath;

    public GitSynchronizeData(Repository repository, String srcRev, String dstRev, boolean includeLocal) throws IOException {
        IProject[] workspaceProjects;
        Assert.isNotNull((Object)repository);
        Assert.isNotNull((Object)srcRev);
        Assert.isNotNull((Object)dstRev);
        this.repo = repository;
        ObjectWalk ow = new ObjectWalk(this.repo);
        this.srcRev = ow.parseCommit((AnyObjectId)this.repo.resolve(srcRev));
        this.dstRev = ow.parseCommit((AnyObjectId)this.repo.resolve(dstRev));
        this.commonAncestorRev = RevUtils.getCommonAncestor(this.repo, (AnyObjectId)this.srcRev, (AnyObjectId)this.dstRev);
        this.includeLocal = includeLocal;
        this.repoParentPath = this.repo.getDirectory().getParentFile().getAbsolutePath();
        this.projects = new HashSet<IProject>();
        IProject[] iProjectArray = workspaceProjects = ROOT.getProjects();
        int n = workspaceProjects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            RepositoryMapping mapping = RepositoryMapping.getMapping((IResource)project);
            if (mapping != null && mapping.getRepository() == this.repo) {
                this.projects.add(project);
            }
            ++n2;
        }
    }

    public Repository getRepository() {
        return this.repo;
    }

    public RevCommit getSrcRevCommit() {
        return this.srcRev;
    }

    public RevCommit getDstRevCommit() {
        return this.dstRev;
    }

    public Set<IProject> getProjects() {
        return Collections.unmodifiableSet(this.projects);
    }

    public boolean contains(File file) {
        return file.getAbsoluteFile().toString().startsWith(this.repoParentPath);
    }

    public boolean shouldIncludeLocal() {
        return this.includeLocal;
    }

    public RevCommit getCommonAncestorRev() {
        return this.commonAncestorRev;
    }
}

