/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.core.synchronize.dto;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.egit.core.synchronize.dto.GitSynchronizeData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GitSynchronizeDataSet
implements Iterable<GitSynchronizeData> {
    private final Set<GitSynchronizeData> gsd = new HashSet<GitSynchronizeData>();
    private final Map<String, GitSynchronizeData> projectMapping = new HashMap<String, GitSynchronizeData>();

    public GitSynchronizeDataSet() {
    }

    public GitSynchronizeDataSet(GitSynchronizeData data) {
        this();
        this.add(data);
    }

    public void add(GitSynchronizeData data) {
        this.gsd.add(data);
        for (IProject proj : data.getProjects()) {
            this.projectMapping.put(proj.getName(), data);
        }
    }

    public boolean contains(IProject project) {
        return this.projectMapping.containsKey(project.getName());
    }

    public int size() {
        return this.gsd.size();
    }

    public GitSynchronizeData getData(String projectName) {
        return this.projectMapping.get(projectName);
    }

    public GitSynchronizeData getData(IProject project) {
        return this.projectMapping.get(project.getName());
    }

    @Override
    public Iterator<GitSynchronizeData> iterator() {
        return this.gsd.iterator();
    }

    public IProject[] getAllProjects() {
        HashSet<IProject> resource = new HashSet<IProject>();
        for (GitSynchronizeData data : this.gsd) {
            resource.addAll(data.getProjects());
        }
        return resource.toArray(new IProject[resource.size()]);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (GitSynchronizeData data : this.gsd) {
            builder.append(data.getRepository().getWorkTree());
            builder.append(" ");
        }
        return builder.toString();
    }
}

