/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui;

import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import org.eclipse.jgit.transport.OpenSshConfig;
import org.eclipse.jgit.transport.SshConfigSessionFactory;
import org.eclipse.jgit.util.FS;
import org.eclipse.jsch.core.IJSchService;
import org.eclipse.jsch.ui.UserInfoPrompter;

class EclipseSshSessionFactory
extends SshConfigSessionFactory {
    private final IJSchService provider;

    EclipseSshSessionFactory(IJSchService p) {
        this.provider = p;
    }

    protected JSch createDefaultJSch(FS fs) throws JSchException {
        this.provider.createSession("127.0.0.1", 0, "eclipse");
        return this.provider.getJSch();
    }

    protected Session createSession(OpenSshConfig.Host hc, String user, String host, int port, FS fs) throws JSchException {
        JSch jsch = this.getJSch(hc, FS.DETECTED);
        if (jsch == this.provider.getJSch()) {
            return this.provider.createSession(host, port, user);
        }
        return jsch.getSession(user, host, port);
    }

    protected void configure(OpenSshConfig.Host hc, Session session) {
        if (!hc.isBatchMode()) {
            new UserInfoPrompter(session);
        }
    }
}

