/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.UIText;
import org.eclipse.egit.ui.internal.components.RefContentProposal;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.jface.bindings.keys.ParseException;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.fieldassist.ContentProposalAdapter;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.fieldassist.IContentProposal;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.fieldassist.TextContentAdapter;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class UIUtils {
    private static final char[] VALUE_HELP_ACTIVATIONCHARS = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123457890*@ <>".toCharArray();

    public static Font getFont(String id) {
        return PlatformUI.getWorkbench().getThemeManager().getCurrentTheme().getFontRegistry().get(id);
    }

    public static Font getBoldFont(String id) {
        return PlatformUI.getWorkbench().getThemeManager().getCurrentTheme().getFontRegistry().getBold(id);
    }

    public static void addBulbDecorator(Control control, String tooltip) {
        ControlDecoration dec = new ControlDecoration(control, 16512);
        dec.setImage(FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_CONTENT_PROPOSAL").getImage());
        dec.setShowOnlyOnFocus(true);
        dec.setShowHover(true);
        dec.setDescriptionText(tooltip);
    }

    public static IPreviousValueProposalHandler addPreviousValuesContentProposalToText(final Text textField, final String preferenceKey) {
        KeyStroke stroke;
        try {
            stroke = KeyStroke.getInstance((String)"M1+SPACE");
            UIUtils.addBulbDecorator((Control)textField, NLS.bind((String)UIText.UIUtils_PressShortcutMessage, (Object)stroke.format()));
        }
        catch (ParseException e1) {
            Activator.handleError(e1.getMessage(), e1, false);
            stroke = null;
            UIUtils.addBulbDecorator((Control)textField, UIText.UIUtils_StartTypingForPreviousValuesMessage);
        }
        IContentProposalProvider cp = new IContentProposalProvider(){

            public IContentProposal[] getProposals(String contents, int position) {
                Pattern pattern;
                ArrayList<1> resultList = new ArrayList<1>();
                String patternString = contents;
                while (patternString.length() > 0 && patternString.charAt(0) == ' ') {
                    patternString = patternString.substring(1);
                }
                patternString = Pattern.quote(patternString);
                if (!(patternString = patternString.replaceAll("\\x2A", ".*")).endsWith(".*")) {
                    patternString = String.valueOf(patternString) + ".*";
                }
                try {
                    pattern = Pattern.compile(patternString, 2);
                }
                catch (PatternSyntaxException patternSyntaxException) {
                    pattern = null;
                }
                String[] proposals = Activator.getDefault().getDialogSettings().getArray(preferenceKey);
                if (proposals != null) {
                    String[] stringArray = proposals;
                    int n = proposals.length;
                    int n2 = 0;
                    while (n2 < n) {
                        final String uriString = stringArray[n2];
                        if (pattern == null || pattern.matcher(uriString).matches()) {
                            IContentProposal propsal = new IContentProposal(){

                                public String getLabel() {
                                    return null;
                                }

                                public String getDescription() {
                                    return null;
                                }

                                public int getCursorPosition() {
                                    return 0;
                                }

                                public String getContent() {
                                    return uriString;
                                }
                            };
                            resultList.add(propsal);
                        }
                        ++n2;
                    }
                }
                return resultList.toArray(new IContentProposal[resultList.size()]);
            }
        };
        ContentProposalAdapter adapter = new ContentProposalAdapter((Control)textField, (IControlContentAdapter)new TextContentAdapter(), cp, stroke, VALUE_HELP_ACTIVATIONCHARS);
        adapter.setProposalAcceptanceStyle(2);
        return new IPreviousValueProposalHandler(){

            public void updateProposals() {
                String value = textField.getText();
                if (value.length() > 0) {
                    IDialogSettings settings;
                    String[] existingValues;
                    if (value.length() > 2000) {
                        value = value.substring(0, 1999);
                    }
                    if ((existingValues = (settings = Activator.getDefault().getDialogSettings()).getArray(preferenceKey)) == null) {
                        existingValues = new String[]{value};
                        settings.put(preferenceKey, existingValues);
                    } else {
                        ArrayList<String> values = new ArrayList<String>(existingValues.length + 1);
                        String[] stringArray = existingValues;
                        int n = existingValues.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String existingValue = stringArray[n2];
                            values.add(existingValue);
                            ++n2;
                        }
                        if (values.indexOf(value) == 0) {
                            return;
                        }
                        values.remove(value);
                        values.add(0, value);
                        while (values.size() > 10) {
                            values.remove(values.size() - 1);
                        }
                        settings.put(preferenceKey, values.toArray(new String[values.size()]));
                    }
                }
            }
        };
    }

    public static final void addRefContentProposalToText(Text textField, final Repository repository, final IRefListProvider refListProvider) {
        KeyStroke stroke;
        try {
            stroke = KeyStroke.getInstance((String)"M1+SPACE");
            UIUtils.addBulbDecorator((Control)textField, NLS.bind((String)UIText.UIUtils_PressShortcutMessage, (Object)stroke.format()));
        }
        catch (ParseException e1) {
            Activator.handleError(e1.getMessage(), e1, false);
            stroke = null;
            UIUtils.addBulbDecorator((Control)textField, UIText.UIUtils_StartTypingForPreviousValuesMessage);
        }
        IContentProposalProvider cp = new IContentProposalProvider(){

            public IContentProposal[] getProposals(String contents, int position) {
                Pattern pattern;
                ArrayList<RefContentProposal> resultList = new ArrayList<RefContentProposal>();
                String patternString = contents;
                while (patternString.length() > 0 && patternString.charAt(0) == ' ') {
                    patternString = patternString.substring(1);
                }
                patternString = Pattern.quote(patternString);
                if (!(patternString = patternString.replaceAll("\\x2A", ".*")).endsWith(".*")) {
                    patternString = String.valueOf(patternString) + ".*";
                }
                try {
                    pattern = Pattern.compile(patternString, 2);
                }
                catch (PatternSyntaxException patternSyntaxException) {
                    pattern = null;
                }
                List<Ref> proposals = refListProvider.getRefList();
                if (proposals != null) {
                    for (Ref ref : proposals) {
                        String shortenedName = Repository.shortenRefName((String)ref.getName());
                        if (pattern != null && !pattern.matcher(ref.getName()).matches() && !pattern.matcher(shortenedName).matches()) continue;
                        RefContentProposal propsal = new RefContentProposal(repository, ref);
                        resultList.add(propsal);
                    }
                }
                return resultList.toArray(new IContentProposal[resultList.size()]);
            }
        };
        ContentProposalAdapter adapter = new ContentProposalAdapter((Control)textField, (IControlContentAdapter)new TextContentAdapter(), cp, stroke, VALUE_HELP_ACTIVATIONCHARS);
        adapter.setProposalAcceptanceStyle(2);
    }

    public static interface IPreviousValueProposalHandler {
        public void updateProposals();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface IRefListProvider {
        public List<Ref> getRefList();
    }
}

