/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.credentials;

import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.egit.core.Activator;
import org.eclipse.egit.core.securestorage.UserPasswordCredentials;
import org.eclipse.egit.ui.UIText;
import org.eclipse.egit.ui.credentials.LoginService;
import org.eclipse.equinox.security.storage.StorageException;
import org.eclipse.jgit.errors.UnsupportedCredentialItem;
import org.eclipse.jgit.transport.CredentialItem;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class EGitCredentialsProvider
extends CredentialsProvider {
    public boolean isInteractive() {
        return true;
    }

    public boolean supports(CredentialItem ... items) {
        CredentialItem[] credentialItemArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            CredentialItem i = credentialItemArray[n2];
            if (!(i instanceof CredentialItem.Username) && !(i instanceof CredentialItem.Password)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public boolean get(URIish uri, CredentialItem ... items) throws UnsupportedCredentialItem {
        CredentialItem.Username userItem = null;
        CredentialItem.Password passwordItem = null;
        CredentialItem[] credentialItemArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            CredentialItem item = credentialItemArray[n2];
            if (item instanceof CredentialItem.Username) {
                userItem = (CredentialItem.Username)item;
            } else if (item instanceof CredentialItem.Password) {
                passwordItem = (CredentialItem.Password)item;
            } else {
                throw new UnsupportedCredentialItem(uri, item.getPromptText());
            }
            ++n2;
        }
        UserPasswordCredentials credentials = this.getCredentialsFromSecureStore(uri);
        if (credentials == null && (credentials = this.getCredentialsFromUser(uri)) == null) {
            return false;
        }
        if (userItem != null) {
            userItem.setValue(credentials.getUser());
        }
        if (passwordItem != null) {
            passwordItem.setValue(credentials.getPassword().toCharArray());
        }
        return true;
    }

    private UserPasswordCredentials getCredentialsFromUser(final URIish uri) {
        final AtomicReference<Object> aRef = new AtomicReference<Object>(null);
        PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

            public void run() {
                Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                aRef.set(LoginService.login(shell, uri));
            }
        });
        return aRef.get();
    }

    private UserPasswordCredentials getCredentialsFromSecureStore(URIish uri) {
        UserPasswordCredentials credentials = null;
        try {
            credentials = Activator.getDefault().getSecureStore().getCredentials(uri);
        }
        catch (StorageException e) {
            Activator.logError((String)UIText.EGitCredentialsProvider_errorReadingCredentials, (Throwable)e);
        }
        return credentials;
    }
}

