/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal;

import java.io.IOException;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.CompareUI;
import org.eclipse.compare.ITypedElement;
import org.eclipse.core.resources.IEncodedStorage;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.egit.core.internal.storage.GitFileRevision;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.UIText;
import org.eclipse.egit.ui.internal.FileRevisionTypedElement;
import org.eclipse.egit.ui.internal.GitCompareFileRevisionEditorInput;
import org.eclipse.egit.ui.internal.merge.GitCompareEditorInput;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.util.OpenStrategy;
import org.eclipse.jgit.dircache.DirCache;
import org.eclipse.jgit.dircache.DirCacheEntry;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevTree;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.osgi.util.NLS;
import org.eclipse.team.core.history.IFileRevision;
import org.eclipse.team.ui.synchronize.SaveableCompareEditorInput;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IReusableEditor;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.actions.ActionFactory;

public class CompareUtils {
    private static final String REUSE_COMPARE_EDITOR_PREFID = "org.eclipse.team.ui.reuse_open_compare_editors";
    private static final String TEAM_UI_PLUGIN = "org.eclipse.team.ui";

    public static ITypedElement getFileRevisionTypedElement(String gitPath, RevCommit commit, Repository db) {
        return CompareUtils.getFileRevisionTypedElement(gitPath, commit, db, null);
    }

    public static ITypedElement getFileRevisionTypedElement(String gitPath, RevCommit commit, Repository db, ObjectId blobId) {
        Object right = new GitCompareFileRevisionEditorInput.EmptyTypedElement(NLS.bind((String)UIText.GitHistoryPage_FileNotInCommit, (Object)CompareUtils.getName(gitPath), (Object)commit));
        try {
            IFileRevision nextFile = CompareUtils.getFileRevision(gitPath, commit, db, blobId);
            if (nextFile != null) {
                right = new FileRevisionTypedElement(nextFile);
            }
        }
        catch (IOException e) {
            Activator.error(NLS.bind((String)UIText.GitHistoryPage_errorLookingUpPath, (Object)gitPath, (Object)commit.getId()), e);
        }
        return right;
    }

    private static String getName(String gitPath) {
        int last = gitPath.lastIndexOf(47);
        return last >= 0 ? gitPath.substring(last + 1) : gitPath;
    }

    public static IFileRevision getFileRevision(String gitPath, RevCommit commit, Repository db, ObjectId blobId) throws IOException {
        TreeWalk w = TreeWalk.forPath((Repository)db, (String)gitPath, (RevTree)commit.getTree());
        if (w != null) {
            GitFileRevision fileRevision = GitFileRevision.inCommit((Repository)db, (RevCommit)commit, (String)gitPath, (ObjectId)blobId);
            return fileRevision;
        }
        return null;
    }

    public static Object getAdapter(Object element, Class adapterType) {
        return CompareUtils.getAdapter(element, adapterType, false);
    }

    public static String truncatedRevision(String ci) {
        if (ci.length() > 10) {
            return String.valueOf(ci.substring(0, 7)) + "...";
        }
        return ci;
    }

    public static String getResourceEncoding(Repository db, String repoPath) {
        IPath absolutePath;
        if (db.isBare()) {
            return null;
        }
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceRoot root = workspace.getRoot();
        IFile resource = root.getFileForLocation(absolutePath = new Path(db.getWorkTree().getAbsolutePath()).append(repoPath));
        if (resource == null) {
            return null;
        }
        return CompareUtils.getResourceEncoding((IResource)resource);
    }

    public static String getResourceEncoding(IResource resource) {
        String charset;
        IEncodedStorage encodedStorage = (IEncodedStorage)resource;
        try {
            charset = encodedStorage.getCharset();
            if (charset == null) {
                charset = resource.getParent().getDefaultCharset();
            }
        }
        catch (CoreException coreException) {
            charset = "UTF-8";
        }
        return charset;
    }

    private static Object getAdapter(Object element, Class adapterType, boolean load) {
        Object adapted;
        if (adapterType.isInstance(element)) {
            return element;
        }
        if (element instanceof IAdaptable && adapterType.isInstance(adapted = ((IAdaptable)element).getAdapter(adapterType))) {
            return adapted;
        }
        if (load ? adapterType.isInstance(adapted = Platform.getAdapterManager().loadAdapter(element, adapterType.getName())) : adapterType.isInstance(adapted = Platform.getAdapterManager().getAdapter(element, adapterType))) {
            return adapted;
        }
        return null;
    }

    public static void openInCompare(IWorkbenchPage workBenchPage, CompareEditorInput input) {
        IEditorPart editor = CompareUtils.findReusableCompareEditor(input, workBenchPage);
        if (editor != null) {
            IEditorInput otherInput = editor.getEditorInput();
            if (otherInput.equals(input)) {
                if (OpenStrategy.activateOnOpen()) {
                    workBenchPage.activate((IWorkbenchPart)editor);
                } else {
                    workBenchPage.bringToTop((IWorkbenchPart)editor);
                }
            } else {
                CompareUI.reuseCompareEditor((CompareEditorInput)input, (IReusableEditor)((IReusableEditor)editor));
                if (OpenStrategy.activateOnOpen()) {
                    workBenchPage.activate((IWorkbenchPart)editor);
                } else {
                    workBenchPage.bringToTop((IWorkbenchPart)editor);
                }
            }
        } else {
            CompareUI.openCompareEditor((CompareEditorInput)input);
        }
    }

    private static IEditorPart findReusableCompareEditor(CompareEditorInput input, IWorkbenchPage page) {
        IEditorPart part;
        IEditorReference[] editorRefs = page.getEditorReferences();
        int i = 0;
        while (i < editorRefs.length) {
            part = editorRefs[i].getEditor(false);
            if (part != null && (part.getEditorInput() instanceof GitCompareFileRevisionEditorInput || part.getEditorInput() instanceof GitCompareEditorInput) && part instanceof IReusableEditor && part.getEditorInput().equals(input)) {
                return part;
            }
            ++i;
        }
        if (CompareUtils.isReuseOpenEditor()) {
            i = 0;
            while (i < editorRefs.length) {
                part = editorRefs[i].getEditor(false);
                if (part != null && part.getEditorInput() instanceof SaveableCompareEditorInput && part instanceof IReusableEditor && !part.isDirty()) {
                    return part;
                }
                ++i;
            }
        }
        return null;
    }

    private static boolean isReuseOpenEditor() {
        boolean defaultReuse = new DefaultScope().getNode(TEAM_UI_PLUGIN).getBoolean(REUSE_COMPARE_EDITOR_PREFID, false);
        return new InstanceScope().getNode(TEAM_UI_PLUGIN).getBoolean(REUSE_COMPARE_EDITOR_PREFID, defaultReuse);
    }

    private static void setReuseOpenEditor(boolean value) {
        new InstanceScope().getNode(TEAM_UI_PLUGIN).putBoolean(REUSE_COMPARE_EDITOR_PREFID, value);
    }

    public static ITypedElement getFileCachedRevisionTypedElement(String gitPath, Repository db) {
        try {
            DirCache dc = db.lockDirCache();
            DirCacheEntry entry = dc.getEntry(gitPath);
            dc.unlock();
            if (entry != null) {
                return new FileRevisionTypedElement((IFileRevision)GitFileRevision.inIndex((Repository)db, (String)gitPath));
            }
        }
        catch (IOException e) {
            Activator.error(NLS.bind((String)UIText.GitHistoryPage_errorLookingUpPath, (Object)gitPath), e);
        }
        return new GitCompareFileRevisionEditorInput.EmptyTypedElement(NLS.bind((String)UIText.CompareWithIndexAction_FileNotInIndex, (Object)(String.valueOf(gitPath.substring(gitPath.lastIndexOf("/"))) + 1)));
    }

    public static class ReuseCompareEditorAction
    extends Action
    implements IEclipsePreferences.IPreferenceChangeListener,
    ActionFactory.IWorkbenchAction {
        IEclipsePreferences node = new InstanceScope().getNode("org.eclipse.team.ui");

        public ReuseCompareEditorAction() {
            this.node.addPreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)this);
            this.setText(UIText.GitHistoryPage_ReuseCompareEditorMenuLabel);
            this.setChecked(CompareUtils.isReuseOpenEditor());
        }

        public void run() {
            CompareUtils.setReuseOpenEditor(this.isChecked());
        }

        public void dispose() {
            this.node.removePreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)this);
        }

        public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
            this.setChecked(CompareUtils.isReuseOpenEditor());
        }
    }
}

