/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal;

import java.io.File;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.UIText;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jgit.util.SystemReader;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class ConfigurationChecker {
    public static void checkConfiguration() {
        if (!ConfigurationChecker.runsOnWindows()) {
            return;
        }
        if (!Activator.getDefault().getPreferenceStore().getString("show_home_drive_warning").equals("prompt")) {
            return;
        }
        Job job = new Job(UIText.ConfigurationChecker_checkConfiguration){

            protected IStatus run(IProgressMonitor monitor) {
                PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        ConfigurationChecker.check();
                    }
                });
                return Status.OK_STATUS;
            }
        };
        job.schedule();
    }

    private static void check() {
        String home = System.getenv("HOME");
        if (home != null) {
            return;
        }
        home = ConfigurationChecker.calcHomeDir();
        String title = NLS.bind((String)UIText.ConfigurationChecker_checkHomeDirectory, (Object)home);
        String message = NLS.bind((String)UIText.ConfigurationChecker_homeNotSet, (Object)home);
        String toggleMessage = UIText.ConfigurationChecker_doNotShowAgain;
        IPreferenceStore store = Activator.getDefault().getPreferenceStore();
        MessageDialogWithToggle.openInformation((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)title, (String)message, (String)toggleMessage, (boolean)true, (IPreferenceStore)store, (String)"show_home_drive_warning");
    }

    private static String calcHomeDir() {
        String homeDrive = System.getenv("HOMEDRIVE");
        if (homeDrive != null) {
            String homePath = SystemReader.getInstance().getenv("HOMEPATH");
            return new File(homeDrive, homePath).getAbsolutePath();
        }
        return System.getenv("HOMESHARE");
    }

    private static boolean runsOnWindows() {
        String os;
        try {
            os = System.getProperty("os.name");
        }
        catch (RuntimeException runtimeException) {
            return false;
        }
        return os.indexOf("Windows") != -1;
    }
}

