/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.actions;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.egit.core.op.IEGitOperation;
import org.eclipse.egit.ui.Activator;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractResourceOperationAction
implements IObjectActionDelegate {
    protected IWorkbenchPart wp;
    private IEGitOperation op;
    private List selection;

    public void selectionChanged(IAction act, ISelection sel) {
        this.selection = sel instanceof IStructuredSelection && !sel.isEmpty() ? ((IStructuredSelection)sel).toList() : Collections.EMPTY_LIST;
    }

    public void setActivePart(IAction act, IWorkbenchPart part) {
        this.wp = part;
    }

    protected abstract IEGitOperation createOperation(List<IResource> var1);

    protected abstract String getJobName();

    protected void postOperation() {
    }

    public void run(IAction act) {
        this.op = this.createOperation(this.getSelectedResources());
        if (this.op == null) {
            return;
        }
        String jobname = this.getJobName();
        Job job = new Job(jobname){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    AbstractResourceOperationAction.this.op.execute(monitor);
                    AbstractResourceOperationAction.this.postOperation();
                }
                catch (CoreException e) {
                    return Activator.createErrorStatus(e.getStatus().getMessage(), e);
                }
                return Status.OK_STATUS;
            }
        };
        job.setUser(true);
        job.setRule(this.op.getSchedulingRule());
        job.schedule();
    }

    private List<IResource> getSelectedResources() {
        ArrayList<IResource> resources = new ArrayList<IResource>();
        for (Object object : this.selection) {
            if (!(object instanceof IResource)) continue;
            resources.add((IResource)object);
        }
        return resources;
    }
}

