/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.actions;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.egit.core.EclipseGitProgressTransformer;
import org.eclipse.egit.core.IteratorService;
import org.eclipse.egit.core.op.CommitOperation;
import org.eclipse.egit.core.project.RepositoryMapping;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.JobFamilies;
import org.eclipse.egit.ui.UIText;
import org.eclipse.egit.ui.internal.actions.RepositoryActionHandler;
import org.eclipse.egit.ui.internal.decorators.GitLightweightDecorator;
import org.eclipse.egit.ui.internal.dialogs.BasicConfigurationDialog;
import org.eclipse.egit.ui.internal.dialogs.CommitDialog;
import org.eclipse.egit.ui.internal.trace.GitTraceLocation;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.IndexDiff;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.RepositoryState;
import org.eclipse.jgit.lib.UserConfig;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommitActionHandler
extends RepositoryActionHandler {
    private Map<Repository, IndexDiff> indexDiffs;
    private Set<IFile> notIndexed;
    private Set<IFile> indexChanges;
    private Set<IFile> notTracked;
    private Set<IFile> files;
    private RevCommit previousCommit;
    private boolean amendAllowed;
    private boolean amending;

    public Object execute(final ExecutionEvent event) throws ExecutionException {
        if (!PlatformUI.getWorkbench().saveAllEditors(true)) {
            return null;
        }
        BasicConfigurationDialog.show();
        this.resetState();
        final IProject[] projects = this.getProjectsInRepositoryOfSelectedResources(event);
        try {
            PlatformUI.getWorkbench().getProgressService().busyCursorWhile(new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        CommitActionHandler.this.buildIndexHeadDiffList(projects, monitor);
                    }
                    catch (IOException e) {
                        throw new InvocationTargetException(e);
                    }
                }
            });
        }
        catch (InvocationTargetException e) {
            Activator.handleError(UIText.CommitAction_errorComputingDiffs, e.getCause(), true);
            return null;
        }
        catch (InterruptedException interruptedException) {
            return null;
        }
        Repository[] repos = this.getRepositoriesFor(this.getProjectsForSelectedResources(event));
        Repository repository = null;
        Repository mergeRepository = null;
        this.amendAllowed = repos.length == 1;
        boolean isMergedResolved = false;
        Repository[] repositoryArray = repos;
        int n = repos.length;
        int n2 = 0;
        while (n2 < n) {
            Repository repo;
            repository = repo = repositoryArray[n2];
            RepositoryState state = repo.getRepositoryState();
            if (!state.canCommit()) {
                MessageDialog.openError((Shell)this.getShell(event), (String)UIText.CommitAction_cannotCommit, (String)NLS.bind((String)UIText.CommitAction_repositoryState, (Object)state.getDescription()));
                return null;
            }
            if (state.equals((Object)RepositoryState.MERGING_RESOLVED)) {
                isMergedResolved = true;
                mergeRepository = repo;
            }
            ++n2;
        }
        this.loadPreviousCommit(event);
        if (this.files.isEmpty()) {
            if (this.amendAllowed && this.previousCommit != null) {
                boolean result = MessageDialog.openQuestion((Shell)this.getShell(event), (String)UIText.CommitAction_noFilesToCommit, (String)UIText.CommitAction_amendCommit);
                if (!result) {
                    return null;
                }
                this.amending = true;
            } else {
                MessageDialog.openWarning((Shell)this.getShell(event), (String)UIText.CommitAction_noFilesToCommit, (String)UIText.CommitAction_amendNotPossible);
                return null;
            }
        }
        String author = null;
        String committer = null;
        if (repository != null) {
            UserConfig config = (UserConfig)repository.getConfig().get(UserConfig.KEY);
            author = config.getAuthorName();
            String authorEmail = config.getAuthorEmail();
            author = String.valueOf(author) + " <" + authorEmail + ">";
            committer = config.getCommitterName();
            String committerEmail = config.getCommitterEmail();
            committer = String.valueOf(committer) + " <" + committerEmail + ">";
        }
        CommitDialog commitDialog = new CommitDialog(this.getShell(event));
        commitDialog.setAmending(this.amending);
        commitDialog.setAmendAllowed(this.amendAllowed);
        commitDialog.setFiles(this.files, this.indexDiffs);
        commitDialog.setPreselectedFiles(this.getSelectedFiles(event));
        commitDialog.setAuthor(author);
        commitDialog.setCommitter(committer);
        commitDialog.setAllowToChangeSelection(!isMergedResolved);
        if (this.previousCommit != null) {
            commitDialog.setPreviousCommitMessage(this.previousCommit.getFullMessage());
            PersonIdent previousAuthor = this.previousCommit.getAuthorIdent();
            commitDialog.setPreviousAuthor(String.valueOf(previousAuthor.getName()) + " <" + previousAuthor.getEmailAddress() + ">");
        }
        if (isMergedResolved) {
            commitDialog.setCommitMessage(this.getMergeResolveMessage(mergeRepository, event));
        }
        if (commitDialog.open() != 0) {
            return null;
        }
        final CommitOperation commitOperation = new CommitOperation(commitDialog.getSelectedFiles(), this.notIndexed, this.notTracked, commitDialog.getAuthor(), commitDialog.getCommitter(), commitDialog.getCommitMessage());
        if (commitDialog.isAmending()) {
            commitOperation.setAmending(true);
            commitOperation.setPreviousCommit(this.previousCommit);
            commitOperation.setRepos(repos);
        }
        commitOperation.setComputeChangeId(commitDialog.getCreateChangeId());
        commitOperation.setCommitAll(isMergedResolved);
        if (isMergedResolved) {
            commitOperation.setRepos(repos);
        }
        String jobname = UIText.CommitAction_CommittingChanges;
        Job job = new Job(jobname){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    try {
                        commitOperation.execute(monitor);
                        IProject[] iProjectArray = CommitActionHandler.this.getProjectsForSelectedResources(event);
                        int n = iProjectArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IProject proj = iProjectArray[n2];
                            RepositoryMapping.getMapping((IResource)proj).fireRepositoryChanged();
                            ++n2;
                        }
                    }
                    catch (CoreException e) {
                        IStatus iStatus = Activator.createErrorStatus(UIText.CommitAction_CommittingFailed, e);
                        GitLightweightDecorator.refresh();
                        return iStatus;
                    }
                    catch (ExecutionException e) {
                        IStatus iStatus = Activator.createErrorStatus(UIText.CommitAction_CommittingFailed, e);
                        GitLightweightDecorator.refresh();
                        return iStatus;
                    }
                }
                finally {
                    GitLightweightDecorator.refresh();
                }
                return Status.OK_STATUS;
            }

            public boolean belongsTo(Object family) {
                if (family.equals(JobFamilies.COMMIT)) {
                    return true;
                }
                return super.belongsTo(family);
            }
        };
        job.setUser(true);
        job.schedule();
        return null;
    }

    private void resetState() {
        this.files = new LinkedHashSet<IFile>();
        this.notIndexed = new LinkedHashSet<IFile>();
        this.indexChanges = new LinkedHashSet<IFile>();
        this.notTracked = new LinkedHashSet<IFile>();
        this.amending = false;
        this.previousCommit = null;
        this.indexDiffs = new HashMap<Repository, IndexDiff>();
    }

    private Set<IFile> getSelectedFiles(ExecutionEvent event) throws ExecutionException {
        LinkedHashSet<IFile> preselectionCandidates = new LinkedHashSet<IFile>();
        IResource[] selectedResources = this.getSelectedResources(event);
        block0: for (IFile file : this.files) {
            IResource[] iResourceArray = selectedResources;
            int n = selectedResources.length;
            int n2 = 0;
            while (n2 < n) {
                IResource resource = iResourceArray[n2];
                if (resource.contains((ISchedulingRule)file)) {
                    preselectionCandidates.add(file);
                    continue block0;
                }
                ++n2;
            }
        }
        return preselectionCandidates;
    }

    private void loadPreviousCommit(ExecutionEvent event) throws ExecutionException {
        IProject project = this.getProjectsForSelectedResources(event)[0];
        Repository repo = RepositoryMapping.getMapping((IResource)project).getRepository();
        try {
            ObjectId parentId = repo.resolve("HEAD");
            if (parentId != null) {
                this.previousCommit = new RevWalk(repo).parseCommit((AnyObjectId)parentId);
            }
        }
        catch (IOException e) {
            Activator.handleError(UIText.CommitAction_errorRetrievingCommit, e, true);
        }
    }

    private void buildIndexHeadDiffList(IProject[] selectedProjects, IProgressMonitor monitor) throws IOException, OperationCanceledException {
        HashMap<Repository, HashSet<IProject>> repositories = new HashMap<Repository, HashSet<IProject>>();
        IProject[] iProjectArray = selectedProjects;
        int n = selectedProjects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            RepositoryMapping repositoryMapping = RepositoryMapping.getMapping((IResource)project);
            assert (repositoryMapping != null);
            Repository repository = repositoryMapping.getRepository();
            HashSet<IProject> projects = (HashSet<IProject>)repositories.get(repository);
            if (projects == null) {
                projects = new HashSet<IProject>();
                repositories.put(repository, projects);
            }
            projects.add(project);
            ++n2;
        }
        monitor.beginTask(UIText.CommitActionHandler_calculatingChanges, repositories.size() * 1000);
        for (Map.Entry entry : repositories.entrySet()) {
            Repository repository = (Repository)entry.getKey();
            EclipseGitProgressTransformer jgitMonitor = new EclipseGitProgressTransformer(monitor);
            HashSet projects = (HashSet)entry.getValue();
            CountingVisitor counter = new CountingVisitor();
            for (IProject p : projects) {
                try {
                    p.accept((IResourceVisitor)counter);
                }
                catch (CoreException coreException) {}
            }
            IndexDiff indexDiff = new IndexDiff(repository, "HEAD", IteratorService.createInitialIterator((Repository)repository));
            indexDiff.diff((ProgressMonitor)jgitMonitor, counter.count, 0, NLS.bind((String)UIText.CommitActionHandler_repository, (Object)repository.getDirectory().getPath()));
            this.indexDiffs.put(repository, indexDiff);
            for (IProject project : projects) {
                this.includeList(project, indexDiff.getAdded(), this.indexChanges);
                this.includeList(project, indexDiff.getChanged(), this.indexChanges);
                this.includeList(project, indexDiff.getRemoved(), this.indexChanges);
                this.includeList(project, indexDiff.getMissing(), this.notIndexed);
                this.includeList(project, indexDiff.getModified(), this.notIndexed);
                this.includeList(project, indexDiff.getUntracked(), this.notTracked);
            }
            if (!monitor.isCanceled()) continue;
            throw new OperationCanceledException();
        }
        monitor.done();
    }

    private void includeList(IProject project, Set<String> added, Set<IFile> category) {
        String repoRelativePath = RepositoryMapping.getMapping((IResource)project).getRepoRelativePath((IResource)project);
        if (repoRelativePath.length() > 0) {
            repoRelativePath = String.valueOf(repoRelativePath) + "/";
        }
        for (String filename : added) {
            try {
                if (!filename.startsWith(repoRelativePath)) continue;
                String projectRelativePath = filename.substring(repoRelativePath.length());
                IFile member = project.getFile(projectRelativePath);
                if (!this.files.contains(member)) {
                    this.files.add(member);
                }
                category.add(member);
            }
            catch (Exception e) {
                if (!GitTraceLocation.UI.isActive()) continue;
                GitTraceLocation.getTrace().trace(GitTraceLocation.UI.getLocation(), e.getMessage(), (Throwable)e);
            }
        }
    }

    public boolean isEnabled() {
        return this.getProjectsInRepositoryOfSelectedResources().length > 0;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getMergeResolveMessage(Repository mergeRepository, ExecutionEvent event) throws ExecutionException {
        File mergeMsg = new File(mergeRepository.getDirectory(), "MERGE_MSG");
        try {
            String string;
            FileReader reader = new FileReader(mergeMsg);
            BufferedReader br = new BufferedReader(reader);
            try {
                StringBuilder message = new StringBuilder();
                String newLine = this.newLine();
                while (true) {
                    String s;
                    if ((s = br.readLine()) == null) {
                        string = message.toString();
                        break;
                    }
                    message.append(s).append(newLine);
                }
            }
            catch (IOException e) {
                try {
                    MessageDialog.openError((Shell)this.getShell(event), (String)UIText.CommitAction_MergeHeadErrorTitle, (String)UIText.CommitAction_ErrorReadingMergeMsg);
                    throw new IllegalStateException(e);
                }
                catch (Throwable throwable) {
                    try {
                        br.close();
                        throw throwable;
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
            }
            try {
                br.close();
                return string;
            }
            catch (IOException iOException) {}
            return string;
        }
        catch (FileNotFoundException e2) {
            MessageDialog.openError((Shell)this.getShell(event), (String)UIText.CommitAction_MergeHeadErrorTitle, (String)UIText.CommitAction_MergeHeadErrorMessage);
            throw new IllegalStateException(e2);
        }
    }

    private String newLine() {
        return System.getProperty("line.separator");
    }

    static class CountingVisitor
    implements IResourceVisitor {
        int count;

        CountingVisitor() {
        }

        public boolean visit(IResource resource) throws CoreException {
            ++this.count;
            return true;
        }
    }
}

