/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.actions;

import java.io.IOException;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.CompareUI;
import org.eclipse.compare.ITypedElement;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.egit.core.project.RepositoryMapping;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.internal.CompareUtils;
import org.eclipse.egit.ui.internal.GitCompareFileRevisionEditorInput;
import org.eclipse.egit.ui.internal.actions.RepositoryActionHandler;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.team.ui.synchronize.SaveableCompareEditorInput;

public class CompareWithHeadActionHandler
extends RepositoryActionHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        ITypedElement next;
        IResource resource = this.getSelectedResources(event)[0];
        RepositoryMapping mapping = RepositoryMapping.getMapping((IResource)resource.getProject());
        Repository repository = mapping.getRepository();
        String gitPath = mapping.getRepoRelativePath(resource);
        IFile baseFile = (IFile)resource;
        ITypedElement base = SaveableCompareEditorInput.createFileElement((IFile)baseFile);
        try {
            Ref head = repository.getRef("HEAD");
            RevWalk rw = new RevWalk(repository);
            RevCommit commit = rw.parseCommit((AnyObjectId)head.getObjectId());
            next = CompareUtils.getFileRevisionTypedElement(gitPath, commit, repository);
        }
        catch (IOException e) {
            Activator.handleError(e.getMessage(), e, true);
            return null;
        }
        GitCompareFileRevisionEditorInput in = new GitCompareFileRevisionEditorInput(base, next, null);
        CompareUI.openCompareEditor((CompareEditorInput)in);
        return null;
    }

    public boolean isEnabled() {
        IResource[] selectedResources = this.getSelectedResources();
        if (selectedResources.length != 1) {
            return false;
        }
        IResource resource = selectedResources[0];
        if (!(resource instanceof IFile)) {
            return false;
        }
        RepositoryMapping mapping = RepositoryMapping.getMapping((IResource)resource.getProject());
        return mapping != null;
    }
}

