/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.actions;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.CompareUI;
import org.eclipse.compare.IContentChangeListener;
import org.eclipse.compare.IContentChangeNotifier;
import org.eclipse.compare.ITypedElement;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.egit.core.internal.storage.GitFileRevision;
import org.eclipse.egit.core.project.RepositoryMapping;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.UIText;
import org.eclipse.egit.ui.internal.EditableRevision;
import org.eclipse.egit.ui.internal.GitCompareFileRevisionEditorInput;
import org.eclipse.egit.ui.internal.actions.RepositoryActionHandler;
import org.eclipse.egit.ui.internal.dialogs.CompareTreeView;
import org.eclipse.jgit.dircache.DirCache;
import org.eclipse.jgit.dircache.DirCacheEditor;
import org.eclipse.jgit.dircache.DirCacheEntry;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectInserter;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.osgi.util.NLS;
import org.eclipse.team.core.history.IFileRevision;
import org.eclipse.team.ui.synchronize.SaveableCompareEditorInput;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class CompareWithIndexActionHandler
extends RepositoryActionHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        if (this.getRepository(true, event) == null) {
            return null;
        }
        IResource[] resources = this.getSelectedResources(event);
        if (resources.length == 1 && resources[0] instanceof IFile) {
            ITypedElement next;
            IFile baseFile = (IFile)resources[0];
            ITypedElement base = SaveableCompareEditorInput.createFileElement((IFile)baseFile);
            try {
                next = this.getHeadTypedElement(baseFile);
            }
            catch (IOException e) {
                Activator.handleError(UIText.CompareWithIndexAction_errorOnAddToIndex, e, true);
                return null;
            }
            GitCompareFileRevisionEditorInput in = new GitCompareFileRevisionEditorInput(base, next, null);
            CompareUI.openCompareEditor((CompareEditorInput)in);
        } else {
            try {
                CompareTreeView view = (CompareTreeView)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("org.eclipse.egit.ui.CompareTreeView");
                view.setInput(resources, "%%%INDEX%%%");
            }
            catch (PartInitException e) {
                Activator.handleError(e.getMessage(), e, true);
            }
        }
        return null;
    }

    private ITypedElement getHeadTypedElement(IFile baseFile) throws IOException {
        RepositoryMapping mapping = RepositoryMapping.getMapping((IResource)baseFile.getProject());
        final Repository repository = mapping.getRepository();
        final String gitPath = mapping.getRepoRelativePath((IResource)baseFile);
        DirCache dc = repository.lockDirCache();
        final DirCacheEntry entry = dc.getEntry(gitPath);
        dc.unlock();
        if (entry == null) {
            return new GitCompareFileRevisionEditorInput.EmptyTypedElement(NLS.bind((String)UIText.CompareWithIndexAction_FileNotInIndex, (Object)baseFile.getName()));
        }
        GitFileRevision nextFile = GitFileRevision.inIndex((Repository)repository, (String)gitPath);
        final EditableRevision next = new EditableRevision((IFileRevision)nextFile);
        IContentChangeListener listener = new IContentChangeListener(){

            public void contentChanged(IContentChangeNotifier source) {
                final byte[] newContent = next.getModifiedContent();
                DirCache cache = null;
                try {
                    try {
                        cache = repository.lockDirCache();
                        DirCacheEditor editor = cache.editor();
                        editor.add(new DirCacheEditor.PathEdit(gitPath){

                            public void apply(DirCacheEntry ent) {
                                ent.copyMetaData(entry);
                                ObjectInserter inserter = repository.newObjectInserter();
                                ent.copyMetaData(entry);
                                ent.setLength(newContent.length);
                                ent.setLastModified(System.currentTimeMillis());
                                ByteArrayInputStream in = new ByteArrayInputStream(newContent);
                                try {
                                    try {
                                        ent.setObjectId((AnyObjectId)inserter.insert(3, (long)newContent.length, (InputStream)in));
                                        inserter.flush();
                                    }
                                    catch (IOException ex) {
                                        throw new RuntimeException(ex);
                                    }
                                }
                                catch (Throwable throwable) {
                                    try {
                                        ((InputStream)in).close();
                                    }
                                    catch (IOException iOException) {}
                                    throw throwable;
                                }
                                try {
                                    ((InputStream)in).close();
                                }
                                catch (IOException iOException) {}
                            }
                        });
                        try {
                            editor.commit();
                        }
                        catch (RuntimeException e) {
                            if (e.getCause() instanceof IOException) {
                                throw (IOException)e.getCause();
                            }
                            throw e;
                        }
                    }
                    catch (IOException e) {
                        Activator.handleError(UIText.CompareWithIndexAction_errorOnAddToIndex, e, true);
                        if (cache != null) {
                            cache.unlock();
                        }
                    }
                }
                finally {
                    if (cache != null) {
                        cache.unlock();
                    }
                }
            }
        };
        next.addContentChangeListener(listener);
        return next;
    }

    public boolean isEnabled() {
        return this.getRepository() != null;
    }
}

