/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.actions;

import java.io.IOException;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.egit.core.project.RepositoryMapping;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.UIText;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.RepositoryState;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.ide.ResourceUtil;

abstract class RepositoryActionHandler
extends AbstractHandler {
    private IStructuredSelection mySelection;

    RepositoryActionHandler() {
    }

    public void setSelection(ISelection selection) {
        this.mySelection = this.convertSelection(null, selection);
    }

    private IProject[] getProjectsForSelectedResources(IStructuredSelection selection) {
        HashSet<IProject> ret = new HashSet<IProject>();
        IResource[] iResourceArray = (IResource[])this.getSelectedAdaptables((ISelection)selection, IResource.class);
        int n = iResourceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IResource resource = iResourceArray[n2];
            ret.add(resource.getProject());
            ++n2;
        }
        return ret.toArray(new IProject[ret.size()]);
    }

    protected IProject[] getProjectsForSelectedResources(ExecutionEvent event) throws ExecutionException {
        IStructuredSelection selection = this.getSelection(event);
        return this.getProjectsForSelectedResources(selection);
    }

    protected IProject[] getProjectsForSelectedResources() {
        IStructuredSelection selection = this.getSelection();
        return this.getProjectsForSelectedResources(selection);
    }

    protected Repository[] getRepositoriesFor(IProject[] projects) {
        HashSet<Repository> ret = new HashSet<Repository>();
        IProject[] iProjectArray = projects;
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            RepositoryMapping repositoryMapping = RepositoryMapping.getMapping((IResource)project);
            if (repositoryMapping == null) {
                return new Repository[0];
            }
            ret.add(repositoryMapping.getRepository());
            ++n2;
        }
        return ret.toArray(new Repository[ret.size()]);
    }

    protected IProject[] getProjectsInRepositoryOfSelectedResources(ExecutionEvent event) throws ExecutionException {
        IStructuredSelection selection = this.getSelection(event);
        return this.getProjectsInRepositoryOfSelectedResources(selection);
    }

    protected IProject[] getProjectsInRepositoryOfSelectedResources() {
        IStructuredSelection selection = this.getSelection();
        return this.getProjectsInRepositoryOfSelectedResources(selection);
    }

    private IProject[] getProjectsInRepositoryOfSelectedResources(IStructuredSelection selection) {
        IProject[] projects;
        HashSet<IProject> ret = new HashSet<IProject>();
        Repository[] repositories = this.getRepositoriesFor(this.getProjectsForSelectedResources(selection));
        IProject[] iProjectArray = projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            RepositoryMapping mapping = RepositoryMapping.getMapping((IResource)project);
            Repository[] repositoryArray = repositories;
            int n3 = repositories.length;
            int n4 = 0;
            while (n4 < n3) {
                Repository repository = repositoryArray[n4];
                if (mapping != null && mapping.getRepository() == repository) {
                    ret.add(project);
                    break;
                }
                ++n4;
            }
            ++n2;
        }
        return ret.toArray(new IProject[ret.size()]);
    }

    protected Repository getRepository(boolean warn, ExecutionEvent event) throws ExecutionException {
        IStructuredSelection selection = this.getSelection(event);
        Shell shell = this.getShell(event);
        return this.getRepository(warn, selection, shell);
    }

    protected Repository getRepository() {
        IStructuredSelection selection = this.getSelection();
        return this.getRepository(false, selection, null);
    }

    private Repository getRepository(boolean warn, IStructuredSelection selection, Shell shell) {
        RepositoryMapping mapping = null;
        IProject[] iProjectArray = this.getProjectsForSelectedResources(selection);
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            RepositoryMapping repositoryMapping = RepositoryMapping.getMapping((IResource)project);
            if (mapping == null) {
                mapping = repositoryMapping;
            }
            if (repositoryMapping == null) {
                return null;
            }
            if (mapping.getRepository() != repositoryMapping.getRepository()) {
                if (warn) {
                    MessageDialog.openError((Shell)shell, (String)UIText.RepositoryAction_multiRepoSelectionTitle, (String)UIText.RepositoryAction_multiRepoSelection);
                }
                return null;
            }
            ++n2;
        }
        if (mapping == null) {
            if (warn) {
                MessageDialog.openError((Shell)shell, (String)UIText.RepositoryAction_errorFindingRepoTitle, (String)UIText.RepositoryAction_errorFindingRepo);
            }
            return null;
        }
        Repository repository = mapping.getRepository();
        return repository;
    }

    protected Repository[] getRepositories(ExecutionEvent event) throws ExecutionException {
        IProject[] selectedProjects = this.getSelectedProjects(event);
        HashSet<Repository> repos = new HashSet<Repository>(selectedProjects.length);
        IProject[] iProjectArray = selectedProjects;
        int n = selectedProjects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            RepositoryMapping repositoryMapping = RepositoryMapping.getMapping((IResource)project);
            if (repositoryMapping == null) {
                return new Repository[0];
            }
            repos.add(repositoryMapping.getRepository());
            ++n2;
        }
        return repos.toArray(new Repository[repos.size()]);
    }

    protected IStructuredSelection getSelection(ExecutionEvent event) throws ExecutionException {
        IResource resource;
        if (event == null) {
            throw new IllegalArgumentException("event must not be NULL");
        }
        ISelection selection = HandlerUtil.getActiveMenuSelection((ExecutionEvent)event);
        if (selection == null) {
            selection = HandlerUtil.getCurrentSelectionChecked((ExecutionEvent)event);
        }
        if (selection instanceof TextSelection && (resource = ResourceUtil.getResource((Object)HandlerUtil.getVariable((ExecutionEvent)event, (String)"activeEditorInput"))) != null) {
            return new StructuredSelection((Object)resource);
        }
        if (selection instanceof IStructuredSelection) {
            return (IStructuredSelection)selection;
        }
        return StructuredSelection.EMPTY;
    }

    protected IStructuredSelection getSelection() {
        if (this.mySelection != null) {
            return this.mySelection;
        }
        return this.convertSelection(this.getEvaluationContext(), null);
    }

    private IStructuredSelection convertSelection(IEvaluationContext aContext, Object aSelection) {
        Object selection;
        if (aContext == null && aSelection == null) {
            return StructuredSelection.EMPTY;
        }
        IEvaluationContext ctx = aContext;
        if (aSelection == null && ctx != null) {
            selection = ctx.getVariable("activeMenuSelection");
            if (selection == null) {
                selection = ctx.getVariable("selection");
            }
        } else if (aSelection != null) {
            selection = aSelection;
        } else {
            return StructuredSelection.EMPTY;
        }
        if (selection instanceof TextSelection) {
            IResource resource;
            if (ctx == null) {
                ctx = this.getEvaluationContext();
            }
            if ((resource = ResourceUtil.getResource((Object)ctx.getVariable("activeEditorInput"))) != null) {
                return new StructuredSelection((Object)resource);
            }
        }
        if (selection instanceof IStructuredSelection) {
            return (IStructuredSelection)selection;
        }
        return StructuredSelection.EMPTY;
    }

    private IEvaluationContext getEvaluationContext() {
        IWorkbenchWindow activeWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (activeWorkbenchWindow == null) {
            return null;
        }
        IHandlerService hsr = (IHandlerService)activeWorkbenchWindow.getService(IHandlerService.class);
        IEvaluationContext ctx = hsr.getCurrentState();
        return ctx;
    }

    private Object[] getSelectedAdaptables(ISelection selection, Class c) {
        ArrayList<Object> result = null;
        if (selection != null && !selection.isEmpty()) {
            result = new ArrayList<Object>();
            Iterator elements = ((IStructuredSelection)selection).iterator();
            while (elements.hasNext()) {
                Object adapter = this.getAdapter(elements.next(), c);
                if (!c.isInstance(adapter)) continue;
                result.add(adapter);
            }
        }
        if (result != null && !result.isEmpty()) {
            return result.toArray((Object[])Array.newInstance(c, result.size()));
        }
        return (Object[])Array.newInstance(c, 0);
    }

    private Object getAdapter(Object adaptable, Class c) {
        IAdaptable a;
        Object adapter;
        if (c.isInstance(adaptable)) {
            return adaptable;
        }
        if (adaptable instanceof IAdaptable && c.isInstance(adapter = (a = (IAdaptable)adaptable).getAdapter(c))) {
            return adapter;
        }
        return null;
    }

    private IProject[] getSelectedProjects(ExecutionEvent event) throws ExecutionException {
        IStructuredSelection selection = this.getSelection(event);
        return this.getSelectedProjects(selection);
    }

    private IProject[] getSelectedProjects(IStructuredSelection selection) {
        IResource[] selectedResources = this.getSelectedResources(selection);
        if (selectedResources.length == 0) {
            return new IProject[0];
        }
        ArrayList<IProject> projects = new ArrayList<IProject>();
        int i = 0;
        while (i < selectedResources.length) {
            IResource resource = selectedResources[i];
            if (resource.getType() == 4) {
                projects.add((IProject)resource);
            }
            ++i;
        }
        return projects.toArray(new IProject[projects.size()]);
    }

    protected IResource[] getSelectedResources(ExecutionEvent event) throws ExecutionException {
        IStructuredSelection selection = this.getSelection(event);
        return this.getSelectedResources(selection);
    }

    protected IResource[] getSelectedResources() {
        IStructuredSelection selection = this.getSelection();
        return this.getSelectedResources(selection);
    }

    private IResource[] getSelectedResources(IStructuredSelection selection) {
        HashSet<IResource> result = new HashSet<IResource>();
        for (Object o : selection.toList()) {
            IResource resource = (IResource)this.getAdapter(o, IResource.class);
            if (resource == null) continue;
            result.add(resource);
        }
        return result.toArray(new IResource[result.size()]);
    }

    protected Shell getShell(ExecutionEvent event) throws ExecutionException {
        return HandlerUtil.getActiveShellChecked((ExecutionEvent)event);
    }

    protected IWorkbenchPage getPartPage(ExecutionEvent event) throws ExecutionException {
        return this.getPart(event).getSite().getPage();
    }

    protected IWorkbenchPart getPart(ExecutionEvent event) throws ExecutionException {
        return HandlerUtil.getActivePartChecked((ExecutionEvent)event);
    }

    protected boolean canMerge(Repository repository, ExecutionEvent event) throws ExecutionException {
        String message = null;
        try {
            Ref head = repository.getRef("HEAD");
            if (head == null || !head.isSymbolic()) {
                message = UIText.MergeAction_HeadIsNoBranch;
            } else if (!repository.getRepositoryState().equals((Object)RepositoryState.SAFE)) {
                message = NLS.bind((String)UIText.MergeAction_WrongRepositoryState, (Object)repository.getRepositoryState());
            }
        }
        catch (IOException e) {
            Activator.logError(e.getMessage(), e);
            message = e.getMessage();
        }
        if (message != null) {
            MessageDialog.openError((Shell)this.getShell(event), (String)UIText.MergeAction_CannotMerge, (String)message);
        }
        return message == null;
    }
}

