/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.branch;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.egit.core.op.BranchOperation;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.JobFamilies;
import org.eclipse.egit.ui.UIText;
import org.eclipse.egit.ui.internal.branch.BranchResultDialog;
import org.eclipse.egit.ui.internal.decorators.GitLightweightDecorator;
import org.eclipse.egit.ui.internal.dialogs.BranchSelectionDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class BranchOperationUI {
    private BranchOperation bop;
    private final Repository repository;
    private String refName;
    private ObjectId commitId;

    public BranchOperationUI(Repository repository, String refName) {
        this.repository = repository;
        this.refName = refName;
    }

    public BranchOperationUI(Repository repository) {
        this.repository = repository;
    }

    public BranchOperationUI(Repository repository, ObjectId commitId) {
        this.repository = repository;
        this.commitId = commitId;
    }

    public void start() {
        String jobname;
        if (!this.repository.getRepositoryState().canCheckout()) {
            MessageDialog.openError((Shell)this.getShell(), (String)UIText.BranchAction_cannotCheckout, (String)NLS.bind((String)UIText.BranchAction_repositoryState, (Object)this.repository.getRepositoryState().getDescription()));
            return;
        }
        if (this.commitId == null && this.refName == null) {
            BranchSelectionDialog dialog = new BranchSelectionDialog(this.getShell(), this.repository);
            if (dialog.open() != 0) {
                return;
            }
            this.refName = dialog.getRefName();
        }
        if (this.refName != null) {
            this.bop = new BranchOperation(this.repository, this.refName);
            jobname = NLS.bind((String)UIText.BranchAction_checkingOut, (Object)this.refName);
        } else {
            this.bop = new BranchOperation(this.repository, this.commitId);
            jobname = NLS.bind((String)UIText.BranchAction_checkingOut, (Object)this.commitId.name());
        }
        Job job = new Job(jobname){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    try {
                        BranchOperationUI.this.bop.execute(monitor);
                    }
                    catch (CoreException e) {
                        switch (BranchOperationUI.this.bop.getResult().getStatus()) {
                            case CONFLICTS: 
                            case NONDELETED: {
                                break;
                            }
                            default: {
                                IStatus iStatus = Activator.createErrorStatus(UIText.BranchAction_branchFailed, e);
                                GitLightweightDecorator.refresh();
                                return iStatus;
                            }
                        }
                        GitLightweightDecorator.refresh();
                    }
                }
                finally {
                    GitLightweightDecorator.refresh();
                }
                return Status.OK_STATUS;
            }

            public boolean belongsTo(Object family) {
                if (family.equals(JobFamilies.CHECKOUT)) {
                    return true;
                }
                return super.belongsTo(family);
            }
        };
        job.setUser(true);
        job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent cevent) {
                BranchResultDialog.show(BranchOperationUI.this.bop.getResult(), BranchOperationUI.this.repository, BranchOperationUI.this.refName);
            }
        });
        job.schedule();
    }

    public void run(IProgressMonitor monitor) throws CoreException {
        if (!this.repository.getRepositoryState().canCheckout()) {
            PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    MessageDialog.openError((Shell)BranchOperationUI.this.getShell(), (String)UIText.BranchAction_cannotCheckout, (String)NLS.bind((String)UIText.BranchAction_repositoryState, (Object)BranchOperationUI.this.repository.getRepositoryState().getDescription()));
                }
            });
            return;
        }
        if (this.refName == null) {
            BranchSelectionDialog dialog = new BranchSelectionDialog(this.getShell(), this.repository);
            if (dialog.open() != 0) {
                return;
            }
            this.refName = dialog.getRefName();
        }
        this.bop = new BranchOperation(this.repository, this.refName);
        this.bop.execute(monitor);
        BranchResultDialog.show(this.bop.getResult(), this.repository, this.refName);
    }

    private Shell getShell() {
        return PlatformUI.getWorkbench().getDisplay().getActiveShell();
    }
}

