/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.clone;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.egit.core.RepositoryUtil;
import org.eclipse.egit.core.op.CloneOperation;
import org.eclipse.egit.core.securestorage.UserPasswordCredentials;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.UIIcons;
import org.eclipse.egit.ui.UIText;
import org.eclipse.egit.ui.internal.SecureStoreUtils;
import org.eclipse.egit.ui.internal.clone.CloneDestinationPage;
import org.eclipse.egit.ui.internal.clone.SourceBranchPage;
import org.eclipse.egit.ui.internal.components.RepositorySelectionPage;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.jgit.transport.UsernamePasswordCredentialsProvider;
import org.eclipse.jgit.util.FileUtils;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;

public class GitCloneWizard
extends Wizard {
    public static final Object CLONE_JOB_FAMILY = new Object();
    private static final String HELP_CONTEXT = "org.eclipse.egit.ui.GitCloneWizard";
    private RepositorySelectionPage cloneSource;
    private SourceBranchPage validSource;
    private CloneDestinationPage cloneDestination;
    private String alreadyClonedInto;
    private boolean callerRunsCloneOperation;
    private CloneOperation cloneOperation;

    public GitCloneWizard() {
        this.setWindowTitle(UIText.GitCloneWizard_title);
        this.setDefaultPageImageDescriptor(UIIcons.WIZBAN_IMPORT_REPO);
        this.setNeedsProgressMonitor(true);
        this.cloneSource = new RepositorySelectionPage(true, null);
        this.cloneSource.setHelpContext(HELP_CONTEXT);
        this.validSource = new SourceBranchPage(){

            public void setVisible(boolean visible) {
                if (visible) {
                    this.setSelection(GitCloneWizard.this.cloneSource.getSelection());
                    this.setCredentials(GitCloneWizard.this.cloneSource.getCredentials());
                }
                super.setVisible(visible);
            }
        };
        this.validSource.setHelpContext(HELP_CONTEXT);
        this.cloneDestination = new CloneDestinationPage(){

            public void setVisible(boolean visible) {
                if (visible) {
                    this.setSelection(GitCloneWizard.this.cloneSource.getSelection(), GitCloneWizard.this.validSource.getAvailableBranches(), GitCloneWizard.this.validSource.getSelectedBranches(), GitCloneWizard.this.validSource.getHEAD());
                }
                super.setVisible(visible);
            }
        };
        this.cloneDestination.setHelpContext(HELP_CONTEXT);
    }

    public void setCallerRunsCloneOperation(boolean newValue) {
        this.callerRunsCloneOperation = newValue;
    }

    public boolean performCancel() {
        File test;
        if (this.alreadyClonedInto != null && (test = new File(this.alreadyClonedInto)).exists() && MessageDialog.openQuestion((Shell)this.getShell(), (String)UIText.GitCloneWizard_abortingCloneTitle, (String)UIText.GitCloneWizard_abortingCloneMsg)) {
            try {
                FileUtils.delete((File)test, (int)3);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return true;
    }

    public void addPages() {
        this.addPage((IWizardPage)this.cloneSource);
        this.addPage((IWizardPage)this.validSource);
        this.addPage((IWizardPage)this.cloneDestination);
    }

    public boolean canFinish() {
        return this.cloneDestination.isPageComplete();
    }

    public boolean performFinish() {
        try {
            if (this.cloneSource.getStoreInSecureStore() && !SecureStoreUtils.storeCredentials(this.cloneSource.getCredentials(), this.cloneSource.getSelection().getURI())) {
                return false;
            }
            boolean bl = this.performClone();
            return bl;
        }
        finally {
            this.setWindowTitle(UIText.GitCloneWizard_title);
        }
    }

    boolean performClone() {
        List<Object> selectedBranches;
        boolean allSelected;
        URIish uri = this.cloneSource.getSelection().getURI();
        this.setWindowTitle(NLS.bind((String)UIText.GitCloneWizard_jobName, (Object)uri.toString()));
        if (this.validSource.isSourceRepoEmpty()) {
            allSelected = true;
            selectedBranches = Collections.emptyList();
        } else {
            allSelected = this.validSource.isAllSelected();
            selectedBranches = this.validSource.getSelectedBranches();
        }
        File workdir = this.cloneDestination.getDestinationFile();
        Ref ref = this.cloneDestination.getInitialBranch();
        String remoteName = this.cloneDestination.getRemote();
        workdir.mkdirs();
        if (!workdir.isDirectory()) {
            String errorMessage = NLS.bind((String)UIText.GitCloneWizard_errorCannotCreate, (Object)workdir.getPath());
            ErrorDialog.openError((Shell)this.getShell(), (String)this.getWindowTitle(), (String)UIText.GitCloneWizard_failed, (IStatus)new Status(4, Activator.getPluginId(), 0, errorMessage, null));
            return false;
        }
        int timeout = Activator.getDefault().getPreferenceStore().getInt("remote_connection_timeout");
        CloneOperation op = new CloneOperation(uri, allSelected, selectedBranches, workdir, ref, remoteName, timeout);
        UserPasswordCredentials credentials = this.cloneSource.getCredentials();
        if (credentials != null) {
            op.setCredentialsProvider((CredentialsProvider)new UsernamePasswordCredentialsProvider(credentials.getUser(), credentials.getPassword()));
        }
        this.alreadyClonedInto = workdir.getPath();
        this.cloneSource.saveUriInPrefs();
        if (!this.callerRunsCloneOperation) {
            this.runAsJob(uri, op);
        } else {
            this.cloneOperation = op;
        }
        return true;
    }

    public void runCloneOperation(IWizardContainer container) {
        try {
            container.run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    GitCloneWizard.this.executeCloneOperation(GitCloneWizard.this.cloneOperation, monitor);
                }
            });
        }
        catch (InvocationTargetException e) {
            Activator.handleError(UIText.GitCloneWizard_failed, e.getCause(), true);
        }
        catch (InterruptedException interruptedException) {}
    }

    private void runAsJob(URIish uri, final CloneOperation op) {
        Job job = new Job(NLS.bind((String)UIText.GitCloneWizard_jobName, (Object)uri.toString())){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    return GitCloneWizard.this.executeCloneOperation(op, monitor);
                }
                catch (InterruptedException interruptedException) {
                    return Status.CANCEL_STATUS;
                }
                catch (InvocationTargetException e) {
                    Throwable thr = e.getCause();
                    return new Status(4, Activator.getPluginId(), 0, thr.getMessage(), thr);
                }
            }

            public boolean belongsTo(Object family) {
                return CLONE_JOB_FAMILY.equals(family);
            }
        };
        job.setUser(true);
        job.schedule();
    }

    private IStatus executeCloneOperation(CloneOperation op, IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        RepositoryUtil util = Activator.getDefault().getRepositoryUtil();
        op.run(monitor);
        util.addConfiguredRepository(op.getGitDir());
        return Status.OK_STATUS;
    }
}

