/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.clone;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.egit.core.op.ConnectProviderOperation;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.UIIcons;
import org.eclipse.egit.ui.UIText;
import org.eclipse.egit.ui.internal.ConfigurationChecker;
import org.eclipse.egit.ui.internal.clone.GitCreateGeneralProjectPage;
import org.eclipse.egit.ui.internal.clone.GitProjectsImportPage;
import org.eclipse.egit.ui.internal.clone.GitSelectRepositoryPage;
import org.eclipse.egit.ui.internal.clone.GitSelectWizardPage;
import org.eclipse.egit.ui.internal.clone.ProjectRecord;
import org.eclipse.egit.ui.internal.clone.ProjectUtils;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.ui.IImportWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.NewProjectAction;

public class GitImportWizard
extends Wizard
implements IImportWizard {
    private GitSelectRepositoryPage selectRepoPage = new GitSelectRepositoryPage();
    private GitSelectWizardPage importWithDirectoriesPage = new GitSelectWizardPage();
    private GitProjectsImportPage projectsImportPage = new GitProjectsImportPage();
    private GitCreateGeneralProjectPage createGeneralProjectPage = new GitCreateGeneralProjectPage();

    public GitImportWizard() {
        this.setWindowTitle(UIText.GitImportWizard_WizardTitle);
        this.setDefaultPageImageDescriptor(UIIcons.WIZBAN_IMPORT_REPO);
        this.selectRepoPage.setWizard((IWizard)this);
        this.setNeedsProgressMonitor(true);
        ConfigurationChecker.checkConfiguration();
    }

    public void addPages() {
        this.addPage((IWizardPage)this.selectRepoPage);
        this.addPage((IWizardPage)this.importWithDirectoriesPage);
        this.addPage((IWizardPage)this.projectsImportPage);
        this.addPage((IWizardPage)this.createGeneralProjectPage);
    }

    public boolean performFinish() {
        try {
            this.getContainer().run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    GitImportWizard.this.importProjects(monitor);
                }
            });
        }
        catch (InvocationTargetException e) {
            Activator.handleError(e.getCause().getMessage(), e.getCause(), true);
            return false;
        }
        catch (InterruptedException e) {
            Activator.handleError(UIText.GitCreateProjectViaWizardWizard_AbortedMessage, e, true);
            return false;
        }
        return true;
    }

    public IWizardPage getNextPage(IWizardPage page) {
        if (page == this.selectRepoPage) {
            this.importWithDirectoriesPage.setRepository(this.selectRepoPage.getRepository());
            return this.importWithDirectoriesPage;
        }
        if (page == this.importWithDirectoriesPage) {
            switch (this.importWithDirectoriesPage.getWizardSelection()) {
                case 0: {
                    this.projectsImportPage.setProjectsList(this.importWithDirectoriesPage.getPath());
                    return this.projectsImportPage;
                }
                case 1: {
                    return null;
                }
                case 2: {
                    this.createGeneralProjectPage.setPath(this.importWithDirectoriesPage.getPath());
                    return this.createGeneralProjectPage;
                }
            }
        } else if (page == this.createGeneralProjectPage || page == this.projectsImportPage) {
            return null;
        }
        return super.getNextPage(page);
    }

    public boolean canFinish() {
        switch (this.importWithDirectoriesPage.getWizardSelection()) {
            case 0: {
                return this.projectsImportPage.isPageComplete();
            }
            case 1: {
                return true;
            }
            case 2: {
                return this.createGeneralProjectPage.isPageComplete();
            }
        }
        return super.canFinish();
    }

    private void importProjects(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        switch (this.importWithDirectoriesPage.getWizardSelection()) {
            case 0: {
                final HashSet<ProjectRecord> projectsToCreate = new HashSet<ProjectRecord>();
                final ArrayList workingSets = new ArrayList();
                final Repository[] repository = new Repository[1];
                PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

                    public void run() {
                        projectsToCreate.addAll(GitImportWizard.this.projectsImportPage.getCheckedProjects());
                        IWorkingSet[] workingSetArray = GitImportWizard.this.projectsImportPage.getSelectedWorkingSets();
                        workingSets.addAll(Arrays.asList(workingSetArray));
                        repository[0] = GitImportWizard.this.selectRepoPage.getRepository();
                    }
                });
                ProjectUtils.createProjects(projectsToCreate, repository[0], workingSets.toArray(new IWorkingSet[workingSets.size()]), monitor);
                break;
            }
            case 1: {
                final File[] repoDir = new File[1];
                PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

                    public void run() {
                        repoDir[0] = GitImportWizard.this.selectRepoPage.getRepository().getDirectory();
                    }
                });
                final List<IProject> previousProjects = Arrays.asList(ResourcesPlugin.getWorkspace().getRoot().getProjects());
                PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

                    public void run() {
                        new NewProjectAction(PlatformUI.getWorkbench().getActiveWorkbenchWindow()).run();
                    }
                });
                IWorkspaceRunnable wsr = new IWorkspaceRunnable(){

                    public void run(IProgressMonitor actMonitor) throws CoreException {
                        IProject[] currentProjects;
                        IProject[] iProjectArray = currentProjects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
                        int n = currentProjects.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IProject current = iProjectArray[n2];
                            if (!previousProjects.contains(current)) {
                                ConnectProviderOperation cpo = new ConnectProviderOperation(current, repoDir[0]);
                                cpo.execute(actMonitor);
                            }
                            ++n2;
                        }
                    }
                };
                try {
                    ResourcesPlugin.getWorkspace().run(wsr, monitor);
                    break;
                }
                catch (CoreException e) {
                    throw new InvocationTargetException(e);
                }
            }
            case 2: {
                final String[] projectName = new String[1];
                final boolean[] defaultLocation = new boolean[1];
                final String[] path = new String[1];
                final File[] repoDir = new File[1];
                PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

                    public void run() {
                        projectName[0] = GitImportWizard.this.createGeneralProjectPage.getProjectName();
                        defaultLocation[0] = GitImportWizard.this.createGeneralProjectPage.isDefaultLocation();
                        path[0] = GitImportWizard.this.importWithDirectoriesPage.getPath();
                        repoDir[0] = GitImportWizard.this.selectRepoPage.getRepository().getDirectory();
                    }
                });
                try {
                    IWorkspaceRunnable wsr = new IWorkspaceRunnable(){

                        public void run(IProgressMonitor actMonitor) throws CoreException {
                            IProjectDescription desc = ResourcesPlugin.getWorkspace().newProjectDescription(projectName[0]);
                            desc.setLocation((IPath)new Path(path[0]));
                            IProject prj = ResourcesPlugin.getWorkspace().getRoot().getProject(desc.getName());
                            prj.create(desc, actMonitor);
                            prj.open(actMonitor);
                            ConnectProviderOperation cpo = new ConnectProviderOperation(prj, repoDir[0]);
                            cpo.execute((IProgressMonitor)new NullProgressMonitor());
                            ResourcesPlugin.getWorkspace().getRoot().refreshLocal(1, actMonitor);
                        }
                    };
                    ResourcesPlugin.getWorkspace().run(wsr, monitor);
                    break;
                }
                catch (CoreException e) {
                    throw new InvocationTargetException(e);
                }
            }
        }
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }
}

