/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.components;

import org.eclipse.core.runtime.Platform;
import org.eclipse.egit.ui.UIIcons;
import org.eclipse.egit.ui.internal.components.CenteredImageLabelProvider;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public abstract class CheckboxLabelProvider
extends CenteredImageLabelProvider {
    private final Image imageCheckedEnabled;
    private final Image imageUncheckedEnabled;
    private final Image imageCheckedDisabled;
    private final Image imageUncheckedDisabled;
    private final ResourceManager resourceManager = new LocalResourceManager(JFaceResources.getResources());

    private static Image createCheckboxImage(ResourceManager resourceManager, Control control, boolean checked, boolean enabled) {
        String checkboxhack = System.getProperty("egit.swt.checkboxhack");
        if (checkboxhack == null) {
            checkboxhack = Platform.getOS().equals("macosx") ? "hardwired" : "screenshot";
        }
        if (checkboxhack == "hardwired") {
            if (enabled) {
                if (checked) {
                    return UIIcons.CHECKBOX_ENABLED_CHECKED.createImage();
                }
                return UIIcons.CHECKBOX_ENABLED_UNCHECKED.createImage();
            }
            if (checked) {
                return UIIcons.CHECKBOX_DISABLED_CHECKED.createImage();
            }
            return UIIcons.CHECKBOX_DISABLED_UNCHECKED.createImage();
        }
        Shell s = new Shell(control.getShell(), 8);
        Color greenScreen = resourceManager.createColor(new RGB(222, 223, 224));
        s.setBackground(greenScreen);
        Button b = new Button((Composite)s, 32);
        b.setSelection(checked);
        b.setEnabled(enabled);
        b.setBackground(greenScreen);
        b.setLocation(0, 0);
        Point bSize = b.computeSize(-1, -1);
        bSize.x = Math.max(bSize.x, bSize.y);
        bSize.y = Math.max(bSize.x, bSize.y);
        b.setSize(bSize);
        s.setSize(bSize);
        s.open();
        GC gc = new GC((Drawable)b);
        Image image = new Image((Device)control.getShell().getDisplay(), bSize.x, bSize.y);
        gc.copyArea(image, 0, 0);
        gc.dispose();
        s.close();
        ImageData imageData = image.getImageData();
        imageData.transparentPixel = imageData.palette.getPixel(greenScreen.getRGB());
        Image checkboxImage = resourceManager.createImage(ImageDescriptor.createFromImageData((ImageData)imageData));
        image.dispose();
        return checkboxImage;
    }

    public CheckboxLabelProvider(Control control) {
        this.imageCheckedEnabled = CheckboxLabelProvider.createCheckboxImage(this.resourceManager, control, true, true);
        this.imageUncheckedEnabled = CheckboxLabelProvider.createCheckboxImage(this.resourceManager, control, false, true);
        this.imageCheckedDisabled = CheckboxLabelProvider.createCheckboxImage(this.resourceManager, control, true, false);
        this.imageUncheckedDisabled = CheckboxLabelProvider.createCheckboxImage(this.resourceManager, control, false, false);
    }

    public void dispose() {
        super.dispose();
        this.resourceManager.dispose();
    }

    protected Image getImage(Object element) {
        if (this.isEnabled(element)) {
            if (this.isChecked(element)) {
                return this.imageCheckedEnabled;
            }
            return this.imageUncheckedEnabled;
        }
        if (this.isChecked(element)) {
            return this.imageCheckedDisabled;
        }
        return this.imageUncheckedDisabled;
    }

    protected abstract boolean isChecked(Object var1);

    protected boolean isEnabled(Object element) {
        return true;
    }
}

