/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.decorators;

import java.io.IOException;
import java.util.Collections;
import java.util.Set;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.egit.core.AdaptableFileTreeIterator;
import org.eclipse.egit.core.ContainerTreeIterator;
import org.eclipse.egit.core.IteratorService;
import org.eclipse.egit.core.project.RepositoryMapping;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.internal.decorators.DecoratableResource;
import org.eclipse.egit.ui.internal.decorators.DecoratableResourceHelper;
import org.eclipse.egit.ui.internal.decorators.IDecoratableResource;
import org.eclipse.egit.ui.internal.trace.GitTraceLocation;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jgit.dircache.DirCacheIterator;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.FileMode;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.RepositoryState;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.treewalk.AbstractTreeIterator;
import org.eclipse.jgit.treewalk.EmptyTreeIterator;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.treewalk.WorkingTreeIterator;
import org.eclipse.jgit.treewalk.filter.AndTreeFilter;
import org.eclipse.jgit.treewalk.filter.PathFilterGroup;
import org.eclipse.jgit.treewalk.filter.TreeFilter;

class DecoratableResourceAdapter
extends DecoratableResource {
    private final RepositoryMapping mapping;
    private final Repository repository;
    private final ObjectId headId;
    private final IPreferenceStore store;
    private final boolean trace = GitTraceLocation.DECORATION.isActive();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public DecoratableResourceAdapter(IResource resourceToWrap) throws IOException {
        super(resourceToWrap);
        long start = 0L;
        if (this.trace) {
            GitTraceLocation.getTrace().trace(GitTraceLocation.DECORATION.getLocation(), "Decorate " + this.resource.getFullPath());
            start = System.currentTimeMillis();
        }
        try {
            this.mapping = RepositoryMapping.getMapping((IResource)this.resource);
            this.repository = this.mapping.getRepository();
            this.headId = this.repository.resolve("HEAD");
            this.store = Activator.getDefault().getPreferenceStore();
            String repoName = Activator.getDefault().getRepositoryUtil().getRepositoryName(this.repository);
            RepositoryState state = this.repository.getRepositoryState();
            this.repositoryName = state != RepositoryState.SAFE ? String.valueOf(repoName) + '|' + state.getDescription() : repoName;
            this.branch = this.getShortBranch();
            TreeWalk treeWalk = this.createThreeWayTreeWalk();
            if (treeWalk == null) {
                return;
            }
            switch (this.resource.getType()) {
                case 1: {
                    if (!treeWalk.next()) {
                        return;
                    }
                    this.extractResourceProperties(treeWalk);
                    return;
                }
                case 4: {
                    this.tracked = true;
                }
                case 2: {
                    this.extractContainerProperties(treeWalk);
                }
            }
            return;
        }
        finally {
            if (this.trace) {
                GitTraceLocation.getTrace().trace(GitTraceLocation.DECORATION.getLocation(), "Decoration took " + (System.currentTimeMillis() - start) + " ms");
            }
        }
    }

    private String getShortBranch() throws IOException {
        Ref head = this.repository.getRef("HEAD");
        if (head != null && !head.isSymbolic()) {
            String refString = Activator.getDefault().getRepositoryUtil().mapCommitToRef(this.repository, this.repository.getFullBranch(), false);
            if (refString != null) {
                return String.valueOf(this.repository.getFullBranch().substring(0, 7)) + "... (" + refString + ")";
            }
            return String.valueOf(this.repository.getFullBranch().substring(0, 7)) + "...";
        }
        return this.repository.getBranch();
    }

    private void extractResourceProperties(TreeWalk treeWalk) throws IOException {
        DecoratableResourceHelper.decorateResource(this, treeWalk);
    }

    private void extractContainerProperties(TreeWalk treeWalk) throws IOException {
        treeWalk.setFilter(AndTreeFilter.create((TreeFilter)treeWalk.getFilter(), (TreeFilter)new RecursiveStateFilter()));
        treeWalk.setRecursive(true);
        treeWalk.next();
    }

    private boolean addResourceFilter(TreeWalk treeWalk, IResource resourceToFilterBy) {
        String repoRelativePath = this.mapping.getRepoRelativePath(resourceToFilterBy);
        if (repoRelativePath == null) {
            return false;
        }
        Set<String> repositoryPaths = Collections.singleton(repoRelativePath);
        if (repositoryPaths.isEmpty()) {
            return false;
        }
        if (repositoryPaths.contains("")) {
            return true;
        }
        treeWalk.setFilter(PathFilterGroup.createFromStrings(repositoryPaths));
        return true;
    }

    private TreeWalk createThreeWayTreeWalk() throws IOException {
        TreeWalk treeWalk = new TreeWalk(this.repository);
        if (!this.addResourceFilter(treeWalk, this.resource)) {
            return null;
        }
        treeWalk.setRecursive(treeWalk.getFilter().shouldBeRecursive());
        treeWalk.reset();
        if (this.headId != null) {
            treeWalk.addTree((AnyObjectId)new RevWalk(this.repository).parseTree((AnyObjectId)this.headId));
        } else {
            treeWalk.addTree((AbstractTreeIterator)new EmptyTreeIterator());
        }
        treeWalk.addTree((AbstractTreeIterator)new DirCacheIterator(DecoratableResourceHelper.getDirCache(this.repository)));
        treeWalk.addTree((AbstractTreeIterator)IteratorService.createInitialIterator((Repository)this.repository));
        return treeWalk;
    }

    private class RecursiveStateFilter
    extends TreeFilter {
        private int filesChecked = 0;
        private int targetDepth = -1;
        private final int recurseLimit;

        public RecursiveStateFilter() {
            this.recurseLimit = DecoratableResourceAdapter.this.store.getInt("decorator_recursive_limit");
        }

        public boolean include(TreeWalk treeWalk) throws MissingObjectException, IncorrectObjectTypeException, IOException {
            WorkingTreeIterator workingTreeIterator;
            if (DecoratableResourceAdapter.this.trace) {
                GitTraceLocation.getTrace().trace(GitTraceLocation.DECORATION.getLocation(), treeWalk.getPathString());
            }
            if ((workingTreeIterator = (WorkingTreeIterator)treeWalk.getTree(2, WorkingTreeIterator.class)) != null) {
                if (workingTreeIterator instanceof ContainerTreeIterator) {
                    ContainerTreeIterator workspaceIterator = (ContainerTreeIterator)workingTreeIterator;
                    ContainerTreeIterator.ResourceEntry resourceEntry = workspaceIterator.getResourceEntry();
                    if (DecoratableResourceAdapter.this.resource.equals((Object)resourceEntry.getResource()) && workspaceIterator.isEntryIgnored()) {
                        DecoratableResourceAdapter.this.ignored = true;
                        return false;
                    }
                    if (DecoratableResourceAdapter.this.resource.getFullPath().isPrefixOf(resourceEntry.getResource().getFullPath()) && treeWalk.getFileMode(0) == FileMode.MISSING && treeWalk.getFileMode(1) == FileMode.MISSING) {
                        if (DecoratableResourceAdapter.this.trace) {
                            GitTraceLocation.getTrace().trace(GitTraceLocation.DECORATION.getLocation(), "CUT");
                        }
                        return false;
                    }
                } else {
                    IPath resPath;
                    IPath wdPath = new Path(DecoratableResourceAdapter.this.repository.getWorkTree().getAbsolutePath()).append(workingTreeIterator.getEntryPathString());
                    if (wdPath.equals((Object)(resPath = DecoratableResourceAdapter.this.resource.getLocation())) && workingTreeIterator.isEntryIgnored()) {
                        DecoratableResourceAdapter.this.ignored = true;
                        return false;
                    }
                    if (resPath.isPrefixOf(wdPath) && treeWalk.getFileMode(0) == FileMode.MISSING && treeWalk.getFileMode(1) == FileMode.MISSING) {
                        if (DecoratableResourceAdapter.this.trace) {
                            GitTraceLocation.getTrace().trace(GitTraceLocation.DECORATION.getLocation(), "CUT");
                        }
                        return false;
                    }
                }
            }
            if (FileMode.TREE.equals(treeWalk.getRawMode(2))) {
                return this.shouldRecurse(treeWalk);
            }
            IDecoratableResource.Staged wasStaged = DecoratableResourceAdapter.this.staged;
            boolean wasDirty = DecoratableResourceAdapter.this.dirty;
            boolean hadConflicts = DecoratableResourceAdapter.this.conflicts;
            DecoratableResourceAdapter.this.extractResourceProperties(treeWalk);
            ++this.filesChecked;
            DecoratableResourceAdapter.this.ignored = false;
            DecoratableResourceAdapter.this.assumeValid = false;
            DecoratableResourceAdapter.this.dirty = wasDirty || DecoratableResourceAdapter.this.dirty;
            boolean bl = DecoratableResourceAdapter.this.conflicts = hadConflicts || DecoratableResourceAdapter.this.conflicts;
            if (DecoratableResourceAdapter.this.staged != wasStaged && this.filesChecked > 1) {
                DecoratableResourceAdapter.this.staged = IDecoratableResource.Staged.MODIFIED;
            }
            return false;
        }

        private boolean shouldRecurse(TreeWalk treeWalk) throws IOException {
            WorkingTreeIterator workspaceIterator = (WorkingTreeIterator)treeWalk.getTree(2, WorkingTreeIterator.class);
            if (workspaceIterator instanceof AdaptableFileTreeIterator) {
                return true;
            }
            ContainerTreeIterator.ResourceEntry resourceEntry = null;
            if (workspaceIterator != null) {
                resourceEntry = ((ContainerTreeIterator)workspaceIterator).getResourceEntry();
            }
            if (resourceEntry == null) {
                return true;
            }
            IResource visitingResource = resourceEntry.getResource();
            if (this.targetDepth == -1) {
                if (visitingResource.equals((Object)DecoratableResourceAdapter.this.resource) || visitingResource.getParent().equals((Object)DecoratableResourceAdapter.this.resource)) {
                    this.targetDepth = treeWalk.getDepth();
                } else {
                    return true;
                }
            }
            if (treeWalk.getDepth() - this.targetDepth >= this.recurseLimit) {
                if (visitingResource.equals((Object)DecoratableResourceAdapter.this.resource)) {
                    DecoratableResourceAdapter.this.extractResourceProperties(treeWalk);
                }
                return false;
            }
            return true;
        }

        public TreeFilter clone() {
            RecursiveStateFilter clone = new RecursiveStateFilter();
            clone.filesChecked = this.filesChecked;
            return clone;
        }

        public boolean shouldBeRecursive() {
            return true;
        }
    }
}

