/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.decorators;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import java.util.WeakHashMap;
import org.eclipse.core.resources.IResource;
import org.eclipse.egit.core.ContainerTreeIterator;
import org.eclipse.egit.core.IteratorService;
import org.eclipse.egit.core.project.RepositoryMapping;
import org.eclipse.egit.ui.internal.decorators.DecoratableResource;
import org.eclipse.egit.ui.internal.decorators.DecoratableResourceAdapter;
import org.eclipse.egit.ui.internal.decorators.IDecoratableResource;
import org.eclipse.jgit.dircache.DirCache;
import org.eclipse.jgit.dircache.DirCacheEntry;
import org.eclipse.jgit.dircache.DirCacheIterator;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.FileMode;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.treewalk.AbstractTreeIterator;
import org.eclipse.jgit.treewalk.EmptyTreeIterator;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.treewalk.WorkingTreeIterator;
import org.eclipse.jgit.treewalk.filter.PathFilterGroup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DecoratableResourceHelper {
    static final int T_HEAD = 0;
    static final int T_INDEX = 1;
    static final int T_WORKSPACE = 2;
    private static final Map<Repository, DirCache> repoToDirCache = new WeakHashMap<Repository, DirCache>();

    DecoratableResourceHelper() {
    }

    static IDecoratableResource[] createDecoratableResources(IResource[] resources) throws IOException {
        int i = 0;
        while (resources[i] == null) {
            if (++i < resources.length) continue;
            return null;
        }
        RepositoryMapping mapping = RepositoryMapping.getMapping((IResource)resources[i]);
        IDecoratableResource[] decoratableResources = new IDecoratableResource[resources.length];
        ArrayList<String> resourcePaths = new ArrayList<String>();
        i = 0;
        while (i < resources.length) {
            IResource resource = resources[i];
            if (resource != null && resource.getProject().isOpen()) {
                switch (resource.getType()) {
                    case 1: {
                        resourcePaths.add(mapping.getRepoRelativePath(resource));
                        break;
                    }
                    case 2: 
                    case 4: {
                        try {
                            decoratableResources[i] = new DecoratableResourceAdapter(resource);
                        }
                        catch (IOException iOException) {}
                        resourcePaths.add(null);
                    }
                }
            } else {
                resourcePaths.add(null);
            }
            ++i;
        }
        boolean containsAtLeastOnePath = false;
        for (String p : resourcePaths) {
            if (p == null) continue;
            containsAtLeastOnePath = true;
            break;
        }
        if (!containsAtLeastOnePath) {
            return decoratableResources;
        }
        TreeWalk treeWalk = DecoratableResourceHelper.createThreeWayTreeWalk(mapping, resourcePaths);
        if (treeWalk != null) {
            while (treeWalk.next()) {
                i = resourcePaths.indexOf(treeWalk.getPathString());
                if (i == -1) continue;
                try {
                    if (decoratableResources[i] != null) continue;
                    decoratableResources[i] = DecoratableResourceHelper.decorateResource(new DecoratableResource(resources[i]), treeWalk);
                }
                catch (IOException iOException) {}
            }
        }
        return decoratableResources;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static DirCache getDirCache(Repository repository) throws IOException {
        Map<Repository, DirCache> map = repoToDirCache;
        synchronized (map) {
            DirCache dirCache = repoToDirCache.get(repository);
            if (dirCache != null && !dirCache.isOutdated()) {
                return dirCache;
            }
            dirCache = repository.readDirCache();
            repoToDirCache.put(repository, dirCache);
            return dirCache;
        }
    }

    private static TreeWalk createThreeWayTreeWalk(RepositoryMapping mapping, ArrayList<String> resourcePaths) throws IOException {
        Repository repository = mapping.getRepository();
        TreeWalk treeWalk = new TreeWalk(repository);
        ArrayList<String> paths = new ArrayList<String>(resourcePaths);
        while (paths.remove(null)) {
        }
        treeWalk.setFilter(PathFilterGroup.createFromStrings(paths));
        treeWalk.setRecursive(true);
        treeWalk.reset();
        ObjectId headId = repository.resolve("HEAD");
        if (headId != null) {
            treeWalk.addTree((AnyObjectId)new RevWalk(repository).parseTree((AnyObjectId)headId));
        } else {
            treeWalk.addTree((AbstractTreeIterator)new EmptyTreeIterator());
        }
        treeWalk.addTree((AbstractTreeIterator)new DirCacheIterator(DecoratableResourceHelper.getDirCache(repository)));
        treeWalk.addTree((AbstractTreeIterator)IteratorService.createInitialIterator((Repository)repository));
        return treeWalk;
    }

    static DecoratableResource decorateResource(DecoratableResource decoratableResource, TreeWalk treeWalk) throws IOException {
        DirCacheEntry indexEntry;
        WorkingTreeIterator workingTreeIterator = (WorkingTreeIterator)treeWalk.getTree(2, WorkingTreeIterator.class);
        if (workingTreeIterator == null) {
            return null;
        }
        if (!(workingTreeIterator instanceof ContainerTreeIterator)) {
            return null;
        }
        ContainerTreeIterator workspaceIterator = (ContainerTreeIterator)workingTreeIterator;
        ContainerTreeIterator.ResourceEntry resourceEntry = workspaceIterator.getResourceEntry();
        if (resourceEntry == null) {
            return null;
        }
        if (workspaceIterator.isEntryIgnored()) {
            decoratableResource.ignored = true;
            return decoratableResource;
        }
        int mHead = treeWalk.getRawMode(0);
        int mIndex = treeWalk.getRawMode(1);
        if (mHead == FileMode.MISSING.getBits() && mIndex == FileMode.MISSING.getBits()) {
            return decoratableResource;
        }
        decoratableResource.tracked = true;
        decoratableResource.staged = mHead == FileMode.MISSING.getBits() ? IDecoratableResource.Staged.ADDED : (mIndex == FileMode.MISSING.getBits() ? IDecoratableResource.Staged.REMOVED : (mHead != mIndex || mIndex != FileMode.TREE.getBits() && !treeWalk.idEqual(0, 1) ? IDecoratableResource.Staged.MODIFIED : IDecoratableResource.Staged.NOT_STAGED));
        DirCacheIterator indexIterator = (DirCacheIterator)treeWalk.getTree(1, DirCacheIterator.class);
        DirCacheEntry dirCacheEntry = indexEntry = indexIterator != null ? indexIterator.getDirCacheEntry() : null;
        if (indexEntry == null) {
            return decoratableResource;
        }
        if (indexEntry.getStage() > 0) {
            decoratableResource.conflicts = true;
        }
        if (indexEntry.isAssumeValid()) {
            decoratableResource.dirty = false;
            decoratableResource.assumeValid = true;
        } else if (workspaceIterator.isModified(indexEntry, true)) {
            decoratableResource.dirty = true;
        }
        return decoratableResource;
    }
}

