/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.decorators;

import java.util.HashMap;
import java.util.HashSet;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.egit.ui.internal.decorators.GitLightweightDecorator;

public class GitDecoratorJob
extends Job {
    private static final long DELAY = 10L;
    private static HashMap<String, GitDecoratorJob> jobs = new HashMap();
    private HashSet<Object> elementList = new HashSet();

    public static synchronized GitDecoratorJob getJobForRepository(String gitDir) {
        GitDecoratorJob job = jobs.get(gitDir);
        if (job == null) {
            job = new GitDecoratorJob("GitDecoratorJob[" + gitDir + "]");
            job.setSystem(true);
            job.setPriority(50);
            jobs.put(gitDir, job);
        }
        return job;
    }

    private GitDecoratorJob(String name) {
        super(name);
    }

    public synchronized void addDecorationRequest(Object element) {
        if (this.elementList.add(element) && this.getState() == 0) {
            this.schedule(10L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IStatus run(IProgressMonitor monitor) {
        while (!this.elementList.isEmpty()) {
            Object[] elements;
            GitDecoratorJob gitDecoratorJob = this;
            synchronized (gitDecoratorJob) {
                elements = this.elementList.toArray(new Object[this.elementList.size()]);
                this.elementList.clear();
            }
            GitLightweightDecorator.processDecoration(elements);
        }
        return Status.OK_STATUS;
    }
}

