/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.decorators;

import java.io.IOException;
import java.util.Map;
import java.util.WeakHashMap;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.egit.core.GitProvider;
import org.eclipse.egit.core.project.RepositoryMapping;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.UIText;
import org.eclipse.egit.ui.internal.CompareUtils;
import org.eclipse.egit.ui.internal.decorators.GitQuickDiffProvider;
import org.eclipse.egit.ui.internal.trace.GitTraceLocation;
import org.eclipse.jface.text.Document;
import org.eclipse.jgit.events.ListenerHandle;
import org.eclipse.jgit.events.RefsChangedEvent;
import org.eclipse.jgit.events.RefsChangedListener;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectLoader;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevTree;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.osgi.util.NLS;
import org.eclipse.team.core.RepositoryProvider;

class GitDocument
extends Document
implements RefsChangedListener {
    private final IResource resource;
    private ObjectId lastCommit;
    private ObjectId lastTree;
    private ObjectId lastBlob;
    private ListenerHandle myRefsChangedHandle;
    static Map<GitDocument, Repository> doc2repo = new WeakHashMap<GitDocument, Repository>();

    static GitDocument create(IResource resource) throws IOException {
        if (GitTraceLocation.QUICKDIFF.isActive()) {
            GitTraceLocation.getTrace().trace(GitTraceLocation.QUICKDIFF.getLocation(), "(GitDocument) create: " + resource);
        }
        GitDocument ret = null;
        if (RepositoryProvider.getProvider((IProject)resource.getProject()) instanceof GitProvider) {
            ret = new GitDocument(resource);
            ret.populate();
            Repository repository = ret.getRepository();
            if (repository != null) {
                ret.myRefsChangedHandle = repository.getListenerList().addRefsChangedListener((RefsChangedListener)ret);
            }
        }
        return ret;
    }

    private GitDocument(IResource resource) {
        this.resource = resource;
        doc2repo.put(this, this.getRepository());
    }

    private void setResolved(AnyObjectId commit, AnyObjectId tree, AnyObjectId blob, String value) {
        this.lastCommit = commit != null ? commit.copy() : null;
        this.lastTree = tree != null ? tree.copy() : null;
        this.lastBlob = blob != null ? blob.copy() : null;
        this.set(value);
        if (blob != null) {
            if (GitTraceLocation.QUICKDIFF.isActive()) {
                GitTraceLocation.getTrace().trace(GitTraceLocation.QUICKDIFF.getLocation(), "(GitDocument) resolved " + this.resource + " to " + this.lastBlob + " in " + this.lastCommit + "/" + this.lastTree);
            } else if (GitTraceLocation.QUICKDIFF.isActive()) {
                GitTraceLocation.getTrace().trace(GitTraceLocation.QUICKDIFF.getLocation(), "(GitDocument) unresolved " + this.resource);
            }
        }
    }

    void populate() throws IOException {
        if (GitTraceLocation.QUICKDIFF.isActive()) {
            GitTraceLocation.getTrace().traceEntry(GitTraceLocation.QUICKDIFF.getLocation(), (Object)this.resource);
        }
        TreeWalk tw = null;
        RevWalk rw = null;
        try {
            RevCommit baselineCommit;
            ObjectId commitId;
            RepositoryMapping mapping = RepositoryMapping.getMapping((IResource)this.resource);
            if (mapping == null) {
                this.setResolved(null, null, null, "");
                return;
            }
            String gitPath = mapping.getRepoRelativePath(this.resource);
            Repository repository = mapping.getRepository();
            String baseline = GitQuickDiffProvider.baseline.get(repository);
            if (baseline == null) {
                baseline = "HEAD";
            }
            if ((commitId = repository.resolve(baseline)) != null) {
                if (commitId.equals((AnyObjectId)this.lastCommit)) {
                    if (GitTraceLocation.QUICKDIFF.isActive()) {
                        GitTraceLocation.getTrace().trace(GitTraceLocation.QUICKDIFF.getLocation(), "(GitDocument) already resolved");
                    }
                    return;
                }
            } else {
                String msg = NLS.bind((String)UIText.GitDocument_errorResolveQuickdiff, (Object[])new Object[]{baseline, this.resource, repository});
                Activator.logError(msg, new Throwable());
                this.setResolved(null, null, null, "");
                return;
            }
            rw = new RevWalk(repository);
            try {
                baselineCommit = rw.parseCommit((AnyObjectId)commitId);
            }
            catch (IOException err) {
                String msg = NLS.bind((String)UIText.GitDocument_errorLoadCommit, (Object[])new Object[]{commitId, baseline, this.resource, repository});
                Activator.logError(msg, err);
                this.setResolved(null, null, null, "");
                if (tw != null) {
                    tw.release();
                }
                if (rw != null) {
                    rw.release();
                }
                if (GitTraceLocation.QUICKDIFF.isActive()) {
                    GitTraceLocation.getTrace().traceExit(GitTraceLocation.QUICKDIFF.getLocation());
                }
                return;
            }
            RevTree treeId = baselineCommit.getTree();
            if (treeId.equals((AnyObjectId)this.lastTree)) {
                if (GitTraceLocation.QUICKDIFF.isActive()) {
                    GitTraceLocation.getTrace().trace(GitTraceLocation.QUICKDIFF.getLocation(), "(GitDocument) already resolved");
                }
                return;
            }
            tw = TreeWalk.forPath((Repository)repository, (String)gitPath, (RevTree)treeId);
            if (tw == null) {
                if (GitTraceLocation.QUICKDIFF.isActive()) {
                    GitTraceLocation.getTrace().trace(GitTraceLocation.QUICKDIFF.getLocation(), "(GitDocument) resource " + this.resource + " not found in " + treeId + " in " + repository + ", baseline=" + baseline);
                }
                this.setResolved(null, null, null, "");
                return;
            }
            ObjectId id = tw.getObjectId(0);
            if (id.equals((AnyObjectId)ObjectId.zeroId())) {
                this.setResolved(null, null, null, "");
                String msg = NLS.bind((String)UIText.GitDocument_errorLoadTree, (Object[])new Object[]{treeId.getName(), baseline, this.resource, repository});
                Activator.logError(msg, new Throwable());
                this.setResolved(null, null, null, "");
                return;
            }
            if (!id.equals((AnyObjectId)this.lastBlob)) {
                if (GitTraceLocation.QUICKDIFF.isActive()) {
                    GitTraceLocation.getTrace().trace(GitTraceLocation.QUICKDIFF.getLocation(), "(GitDocument) compareTo: " + baseline);
                }
                ObjectLoader loader = repository.open((AnyObjectId)id, 3);
                byte[] bytes = loader.getBytes();
                String charset = CompareUtils.getResourceEncoding(this.resource);
                String s = new String(bytes, charset);
                this.setResolved((AnyObjectId)commitId, (AnyObjectId)treeId, (AnyObjectId)id, s);
                if (GitTraceLocation.QUICKDIFF.isActive()) {
                    GitTraceLocation.getTrace().trace(GitTraceLocation.QUICKDIFF.getLocation(), "(GitDocument) has reference doc, size=" + s.length() + " bytes");
                }
            } else if (GitTraceLocation.QUICKDIFF.isActive()) {
                GitTraceLocation.getTrace().trace(GitTraceLocation.QUICKDIFF.getLocation(), "(GitDocument) already resolved");
            }
        }
        finally {
            if (tw != null) {
                tw.release();
            }
            if (rw != null) {
                rw.release();
            }
            if (GitTraceLocation.QUICKDIFF.isActive()) {
                GitTraceLocation.getTrace().traceExit(GitTraceLocation.QUICKDIFF.getLocation());
            }
        }
    }

    void dispose() {
        if (GitTraceLocation.QUICKDIFF.isActive()) {
            GitTraceLocation.getTrace().trace(GitTraceLocation.QUICKDIFF.getLocation(), "(GitDocument) dispose: " + this.resource);
        }
        doc2repo.remove((Object)this);
        if (this.myRefsChangedHandle != null) {
            this.myRefsChangedHandle.remove();
            this.myRefsChangedHandle = null;
        }
    }

    public void onRefsChanged(RefsChangedEvent e) {
        try {
            this.populate();
        }
        catch (IOException e1) {
            Activator.logError(UIText.GitDocument_errorRefreshQuickdiff, e1);
        }
    }

    private Repository getRepository() {
        RepositoryMapping mapping = RepositoryMapping.getMapping((IResource)this.resource);
        return mapping != null ? mapping.getRepository() : null;
    }

    static void refreshRelevant(Repository repository) throws IOException {
        for (Map.Entry<GitDocument, Repository> i : doc2repo.entrySet()) {
            if (i.getValue() != repository) continue;
            i.getKey().populate();
        }
    }
}

