/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.dialogs;

import java.io.IOException;
import java.util.ArrayList;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.internal.repository.RepositoriesViewContentProvider;
import org.eclipse.egit.ui.internal.repository.RepositoriesViewLabelProvider;
import org.eclipse.egit.ui.internal.repository.tree.LocalNode;
import org.eclipse.egit.ui.internal.repository.tree.RefNode;
import org.eclipse.egit.ui.internal.repository.tree.RemoteTrackingNode;
import org.eclipse.egit.ui.internal.repository.tree.RepositoryTreeNode;
import org.eclipse.egit.ui.internal.repository.tree.RepositoryTreeNodeType;
import org.eclipse.egit.ui.internal.repository.tree.TagNode;
import org.eclipse.egit.ui.internal.repository.tree.TagsNode;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.dialogs.PatternFilter;

public abstract class AbstractBranchSelectionDialog
extends TitleAreaDialog {
    protected final Repository repo;
    protected TreeViewer branchTree;
    private String selectedBranch;
    private final String refToMark;
    private final RepositoryTreeNode<Repository> localBranches;
    private final RepositoryTreeNode<Repository> remoteBranches;
    private final RepositoryTreeNode<Repository> tags;
    private boolean showLocalBranches = true;
    private boolean showRemoteBranches = true;
    private boolean showTags = true;

    public AbstractBranchSelectionDialog(Shell parentShell, Repository repository) {
        this(parentShell, repository, null);
        this.setHelpAvailable(false);
    }

    public AbstractBranchSelectionDialog(Shell parentShell, Repository repository, String refToMark) {
        super(parentShell);
        this.repo = repository;
        this.localBranches = new LocalNode(null, this.repo);
        this.remoteBranches = new RemoteTrackingNode(null, this.repo);
        this.tags = new TagsNode(null, this.repo);
        this.refToMark = refToMark;
        this.setHelpAvailable(false);
    }

    protected abstract void refNameSelected(String var1);

    protected abstract String getTitle();

    protected abstract String getMessageText();

    protected String getWindowTitle() {
        return this.getTitle();
    }

    protected final Composite createDialogArea(Composite base) {
        Composite parent = (Composite)super.createDialogArea(base);
        parent.setLayout((Layout)GridLayoutFactory.fillDefaults().create());
        FilteredTree tree = new FilteredTree(parent, 2052, new PatternFilter(), true);
        this.branchTree = tree.getViewer();
        this.branchTree.setLabelProvider((IBaseLabelProvider)new RepositoriesViewLabelProvider());
        this.branchTree.setContentProvider((IContentProvider)new RepositoriesViewContentProvider());
        GridDataFactory.fillDefaults().grab(true, true).hint(500, 300).applyTo((Control)tree);
        this.branchTree.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                String refName = AbstractBranchSelectionDialog.this.refNameFromDialog();
                AbstractBranchSelectionDialog.this.refNameSelected(refName);
            }
        });
        this.branchTree.addOpenListener(new IOpenListener(){

            public void open(OpenEvent event) {
                RepositoryTreeNode node = (RepositoryTreeNode)((IStructuredSelection)AbstractBranchSelectionDialog.this.branchTree.getSelection()).getFirstElement();
                if (node == null) {
                    return;
                }
                if (node.getType() != RepositoryTreeNodeType.REF && node.getType() != RepositoryTreeNodeType.TAG) {
                    AbstractBranchSelectionDialog.this.branchTree.setExpandedState((Object)node, !AbstractBranchSelectionDialog.this.branchTree.getExpandedState((Object)node));
                } else if (AbstractBranchSelectionDialog.this.getButton(0).isEnabled()) {
                    AbstractBranchSelectionDialog.this.okPressed();
                }
            }
        });
        this.createCustomArea(parent);
        this.setTitle(this.getTitle());
        this.setMessage(this.getMessageText());
        this.getShell().setText(this.getWindowTitle());
        AbstractBranchSelectionDialog.applyDialogFont((Control)parent);
        return parent;
    }

    public void create() {
        super.create();
        ArrayList<RepositoryTreeNode<Repository>> roots = new ArrayList<RepositoryTreeNode<Repository>>();
        if (this.showLocalBranches) {
            roots.add(this.localBranches);
        }
        if (this.showRemoteBranches) {
            roots.add(this.remoteBranches);
        }
        if (this.showTags) {
            roots.add(this.tags);
        }
        this.branchTree.setInput(roots);
        try {
            if (this.refToMark != null) {
                if (!this.markRef(this.refToMark)) {
                    this.branchTree.expandToLevel(this.localBranches, 1);
                }
            } else {
                String fullBranch = this.repo.getFullBranch();
                if (!this.markRef(fullBranch)) {
                    this.branchTree.expandToLevel(this.localBranches, 1);
                }
            }
        }
        catch (IOException iOException) {}
    }

    protected boolean markRef(String refName) {
        RepositoryTreeNode node;
        block6: {
            if (refName == null) {
                return false;
            }
            try {
                if (refName.startsWith("refs/heads/")) {
                    Ref ref = this.repo.getRef(refName);
                    node = new RefNode(this.localBranches, this.repo, ref);
                    break block6;
                }
                String mappedRef = Activator.getDefault().getRepositoryUtil().mapCommitToRef(this.repo, refName, false);
                if (mappedRef != null && mappedRef.startsWith("refs/remotes/")) {
                    Ref ref = this.repo.getRef(mappedRef);
                    node = new RefNode(this.remoteBranches, this.repo, ref);
                    break block6;
                }
                if (mappedRef != null && mappedRef.startsWith("refs/tags/")) {
                    Ref ref = this.repo.getRef(mappedRef);
                    node = new TagNode(this.tags, this.repo, ref);
                    break block6;
                }
                return false;
            }
            catch (IOException iOException) {
                return false;
            }
        }
        this.branchTree.setSelection((ISelection)new StructuredSelection((Object)node), true);
        return true;
    }

    public String getRefName() {
        return this.selectedBranch;
    }

    protected void okPressed() {
        this.selectedBranch = this.refNameFromDialog();
        super.okPressed();
    }

    protected String refNameFromDialog() {
        IStructuredSelection sel = (IStructuredSelection)this.branchTree.getSelection();
        if (sel.size() != 1) {
            return null;
        }
        RepositoryTreeNode node = (RepositoryTreeNode)sel.getFirstElement();
        if (node.getType() == RepositoryTreeNodeType.REF || node.getType() == RepositoryTreeNodeType.TAG) {
            return ((Ref)node.getObject()).getName();
        }
        return null;
    }

    protected Ref refFromDialog() {
        IStructuredSelection sel = (IStructuredSelection)this.branchTree.getSelection();
        if (sel.size() != 1) {
            return null;
        }
        RepositoryTreeNode node = (RepositoryTreeNode)sel.getFirstElement();
        if (node.getType() == RepositoryTreeNodeType.REF || node.getType() == RepositoryTreeNodeType.TAG) {
            return (Ref)node.getObject();
        }
        return null;
    }

    protected void createCustomArea(Composite parent) {
    }

    protected int getShellStyle() {
        return super.getShellStyle() | 0x10;
    }

    protected void setRootsToShow(boolean showLocalBranches, boolean showRemoteBranches, boolean showTags) {
        this.showLocalBranches = showLocalBranches;
        this.showRemoteBranches = showRemoteBranches;
        this.showTags = showTags;
    }
}

