/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.dialogs;

import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.UIText;
import org.eclipse.egit.ui.internal.ValidationUtils;
import org.eclipse.egit.ui.internal.dialogs.AbstractBranchSelectionDialog;
import org.eclipse.egit.ui.internal.repository.CreateBranchWizard;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;

public class BranchSelectionDialog
extends AbstractBranchSelectionDialog {
    private Button renameButton;
    private Button newButton;

    public BranchSelectionDialog(Shell parentShell, Repository repo) {
        super(parentShell, repo);
    }

    private InputDialog getRefNameInputDialog(String prompt, String refPrefix, String initialValue) {
        InputDialog labelDialog = new InputDialog(this.getShell(), UIText.BranchSelectionDialog_QuestionNewBranchTitle, prompt, initialValue, ValidationUtils.getRefNameInputValidator(this.repo, refPrefix, true));
        labelDialog.setBlockOnOpen(true);
        return labelDialog;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.newButton = new Button(parent, 8);
        this.newButton.setFont(JFaceResources.getDialogFont());
        this.newButton.setText(UIText.BranchSelectionDialog_NewBranch);
        this.setButtonLayoutData(this.newButton);
        ++((GridLayout)parent.getLayout()).numColumns;
        this.renameButton = new Button(parent, 8);
        this.renameButton.setFont(JFaceResources.getDialogFont());
        this.renameButton.setText(UIText.BranchSelectionDialog_Rename);
        this.setButtonLayoutData(this.renameButton);
        ++((GridLayout)parent.getLayout()).numColumns;
        this.renameButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String refPrefix;
                String refName = BranchSelectionDialog.this.refNameFromDialog();
                if (refName.startsWith("refs/heads/")) {
                    refPrefix = "refs/heads/";
                } else if (refName.startsWith("refs/remotes/")) {
                    refPrefix = "refs/remotes/";
                } else if (refName.startsWith("refs/tags/")) {
                    refPrefix = "refs/tags/";
                } else {
                    return;
                }
                String branchName = refName.substring(refPrefix.length());
                InputDialog labelDialog = BranchSelectionDialog.this.getRefNameInputDialog(NLS.bind((String)UIText.BranchSelectionDialog_QuestionNewBranchNameMessage, (Object)branchName, (Object)refPrefix), refPrefix, branchName);
                if (labelDialog.open() == 0) {
                    String newRefName = String.valueOf(refPrefix) + labelDialog.getValue();
                    try {
                        new Git(BranchSelectionDialog.this.repo).branchRename().setOldName(refName).setNewName(labelDialog.getValue()).call();
                        BranchSelectionDialog.this.branchTree.refresh();
                        BranchSelectionDialog.this.markRef(newRefName);
                    }
                    catch (Throwable e1) {
                        BranchSelectionDialog.this.reportError(e1, UIText.BranchSelectionDialog_ErrorCouldNotRenameRef, new Object[]{refName, newRefName, e1.getMessage()});
                    }
                }
            }
        });
        this.newButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CreateBranchWizard wiz = new CreateBranchWizard(BranchSelectionDialog.this.repo, BranchSelectionDialog.this.refFromDialog());
                if (new WizardDialog(BranchSelectionDialog.this.getShell(), (IWizard)wiz).open() == 0) {
                    String newRefName = wiz.getNewBranchName();
                    try {
                        BranchSelectionDialog.this.branchTree.refresh();
                        BranchSelectionDialog.this.markRef("refs/heads/" + newRefName);
                    }
                    catch (Throwable e1) {
                        BranchSelectionDialog.this.reportError(e1, UIText.BranchSelectionDialog_ErrorCouldNotCreateNewRef, new Object[]{newRefName});
                    }
                }
            }
        });
        super.createButtonsForButtonBar(parent);
        this.getButton(0).setText(UIText.BranchSelectionDialog_OkCheckout);
        this.getButton(0).setEnabled(!this.branchTree.getSelection().isEmpty());
    }

    protected String getMessageText() {
        return UIText.BranchSelectionDialog_Refs;
    }

    protected void createCustomArea(Composite parent) {
    }

    protected String getTitle() {
        return NLS.bind((String)UIText.BranchSelectionDialog_TitleCheckout, (Object[])new Object[]{this.repo.getDirectory()});
    }

    protected int getShellStyle() {
        return super.getShellStyle() | 0x10;
    }

    private void reportError(Throwable e, String message, Object ... args) {
        String msg = NLS.bind((String)message, (Object[])args);
        Activator.handleError(msg, e, true);
    }

    protected void refNameSelected(String refName) {
        boolean tagSelected = refName != null && refName.startsWith("refs/tags/");
        boolean branchSelected = refName != null && (refName.startsWith("refs/heads/") || refName.startsWith("refs/remotes/"));
        this.getButton(0).setEnabled(branchSelected || tagSelected);
        this.newButton.setEnabled(branchSelected || tagSelected);
        this.renameButton.setEnabled(branchSelected && !tagSelected);
    }
}

