/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.dialogs;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.CompareUI;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.egit.core.AdaptableFileTreeIterator;
import org.eclipse.egit.core.GitProvider;
import org.eclipse.egit.core.internal.storage.GitFileHistoryProvider;
import org.eclipse.egit.core.op.AddToIndexOperation;
import org.eclipse.egit.core.project.RepositoryMapping;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.ICommitMessageProvider;
import org.eclipse.egit.ui.UIText;
import org.eclipse.egit.ui.UIUtils;
import org.eclipse.egit.ui.internal.FileRevisionTypedElement;
import org.eclipse.egit.ui.internal.GitCompareFileRevisionEditorInput;
import org.eclipse.egit.ui.internal.dialogs.CommitItem;
import org.eclipse.egit.ui.internal.dialogs.CommitViewerComparator;
import org.eclipse.egit.ui.internal.dialogs.SpellcheckableMessageArea;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.IndexDiff;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.treewalk.WorkingTreeIterator;
import org.eclipse.jgit.treewalk.filter.PathFilterGroup;
import org.eclipse.jgit.util.ChangeIdUtil;
import org.eclipse.jgit.util.RawParseUtils;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.core.history.IFileHistory;
import org.eclipse.team.core.history.IFileRevision;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.model.WorkbenchLabelProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommitDialog
extends Dialog {
    private static final String COMMIT_MESSAGE_PROVIDER_ID = "org.eclipse.egit.ui.commitMessageProvider";
    ArrayList<CommitItem> items = new ArrayList();
    private static final String COMMITTER_VALUES_PREF = "CommitDialog.committerValues";
    private static final String AUTHOR_VALUES_PREF = "CommitDialog.authorValues";
    private static final String SHOW_UNTRACKED_PREF = "CommitDialog.showUntracked";
    SpellcheckableMessageArea commitText;
    Text authorText;
    Text committerText;
    Button amendingButton;
    Button signedOffButton;
    Button changeIdButton;
    Button showUntrackedButton;
    CheckboxTableViewer filesViewer;
    ObjectId originalChangeId;
    private Set<IFile> preselectedFiles = Collections.emptySet();
    private String commitMessage = null;
    private String author = null;
    private String committer = null;
    private String previousAuthor = null;
    private boolean signedOff = false;
    private boolean amending = false;
    private boolean amendAllowed = true;
    private boolean showUntracked = true;
    private boolean createChangeId = false;
    private boolean allowToChangeSelection = true;
    private ArrayList<IFile> selectedFiles = new ArrayList();
    private String previousCommitMessage = "";
    private UIUtils.IPreviousValueProposalHandler authorHandler;
    private UIUtils.IPreviousValueProposalHandler committerHandler;

    public CommitDialog(Shell parentShell) {
        super(parentShell);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 18, UIText.CommitDialog_SelectAll, false);
        this.createButton(parent, 19, UIText.CommitDialog_DeselectAll, false);
        this.createButton(parent, 0, UIText.CommitDialog_Commit, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        parent.getShell().setText(UIText.CommitDialog_CommitChanges);
        GridLayout layout = new GridLayout(2, false);
        container.setLayout((Layout)layout);
        Label label = new Label(container, 16384);
        label.setText(UIText.CommitDialog_CommitMessage);
        label.setLayoutData((Object)GridDataFactory.fillDefaults().span(2, 1).grab(true, false).create());
        this.commitText = new SpellcheckableMessageArea(container, this.commitMessage);
        Point size = this.commitText.getTextWidget().getSize();
        int minHeight = this.commitText.getTextWidget().getLineHeight() * 3;
        this.commitText.setLayoutData(GridDataFactory.fillDefaults().span(2, 1).grab(true, true).hint(size).minSize(size.x, minHeight).align(4, 4).create());
        this.commitText.setText(this.calculateCommitMessage());
        this.commitText.getTextWidget().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent event) {
                if (event.keyCode == 13 && (event.stateMask & 0x40000) > 0) {
                    CommitDialog.this.okPressed();
                } else if (event.keyCode == 9 && (event.stateMask & 0x20000) == 0) {
                    event.doit = false;
                    CommitDialog.this.commitText.traverse(16);
                }
            }
        });
        new Label(container, 16384).setText(UIText.CommitDialog_Author);
        this.authorText = new Text(container, 2048);
        this.authorText.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).create());
        if (this.author != null) {
            this.authorText.setText(this.author);
        }
        this.authorHandler = UIUtils.addPreviousValuesContentProposalToText(this.authorText, AUTHOR_VALUES_PREF);
        new Label(container, 16384).setText(UIText.CommitDialog_Committer);
        this.committerText = new Text(container, 2048);
        this.committerText.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).create());
        if (this.committer != null) {
            this.committerText.setText(this.committer);
        }
        this.committerText.addModifyListener(new ModifyListener(){
            String oldCommitter;
            {
                this.oldCommitter = CommitDialog.this.committerText.getText();
            }

            public void modifyText(ModifyEvent e) {
                if (CommitDialog.this.signedOffButton.getSelection()) {
                    String newCommitter = CommitDialog.this.committerText.getText();
                    String oldSignOff = CommitDialog.this.getSignedOff(this.oldCommitter);
                    String newSignOff = CommitDialog.this.getSignedOff(newCommitter);
                    CommitDialog.this.commitText.setText(CommitDialog.this.replaceSignOff(CommitDialog.this.commitText.getText(), oldSignOff, newSignOff));
                    this.oldCommitter = newCommitter;
                }
            }
        });
        this.committerHandler = UIUtils.addPreviousValuesContentProposalToText(this.committerText, COMMITTER_VALUES_PREF);
        Link preferencesLink = new Link(container, 0);
        preferencesLink.setText(UIText.CommitDialog_ConfigureLink);
        preferencesLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String preferencePageId = "org.eclipse.egit.ui.internal.preferences.CommitDialogPreferencePage";
                PreferenceDialog dialog = PreferencesUtil.createPreferenceDialogOn((Shell)CommitDialog.this.getShell(), (String)preferencePageId, (String[])new String[]{preferencePageId}, null);
                dialog.open();
                CommitDialog.this.commitText.reconfigure();
            }
        });
        this.amendingButton = new Button(container, 32);
        if (this.amending) {
            this.amendingButton.setSelection(this.amending);
            this.amendingButton.setEnabled(false);
            this.authorText.setText(this.previousAuthor);
            this.saveOriginalChangeId();
        } else if (!this.amendAllowed) {
            this.amendingButton.setEnabled(false);
            this.originalChangeId = null;
        }
        this.amendingButton.addSelectionListener(new SelectionListener(){
            boolean alreadyAdded = false;

            public void widgetSelected(SelectionEvent arg0) {
                if (!CommitDialog.this.amendingButton.getSelection()) {
                    CommitDialog.this.originalChangeId = null;
                    CommitDialog.this.authorText.setText(CommitDialog.this.author);
                } else {
                    CommitDialog.this.saveOriginalChangeId();
                    if (!this.alreadyAdded) {
                        this.alreadyAdded = true;
                        CommitDialog.this.commitText.setText(CommitDialog.this.previousCommitMessage.replaceAll("\n", Text.DELIMITER));
                    }
                    CommitDialog.this.authorText.setText(CommitDialog.this.previousAuthor);
                }
                CommitDialog.this.refreshChangeIdText();
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }
        });
        this.amendingButton.setText(UIText.CommitDialog_AmendPreviousCommit);
        this.amendingButton.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).span(2, 1).create());
        this.signedOffButton = new Button(container, 32);
        this.signedOffButton.setSelection(this.signedOff);
        this.signedOffButton.setText(UIText.CommitDialog_AddSOB);
        this.signedOffButton.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).span(2, 1).create());
        this.signedOffButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                String curText = CommitDialog.this.commitText.getText();
                if (CommitDialog.this.signedOffButton.getSelection()) {
                    CommitDialog.this.commitText.setText(CommitDialog.this.signOff(curText));
                } else {
                    if ((curText = CommitDialog.this.replaceSignOff(curText, CommitDialog.this.getSignedOff(), "")).endsWith(String.valueOf(Text.DELIMITER) + Text.DELIMITER)) {
                        curText = curText.substring(0, curText.length() - Text.DELIMITER.length());
                    }
                    CommitDialog.this.commitText.setText(curText);
                }
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }
        });
        this.changeIdButton = new Button(container, 32);
        this.changeIdButton.setText(UIText.CommitDialog_AddChangeIdLabel);
        this.changeIdButton.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).span(2, 1).create());
        this.changeIdButton.setToolTipText(UIText.CommitDialog_AddChangeIdTooltip);
        this.changeIdButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                CommitDialog.this.refreshChangeIdText();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.showUntrackedButton = new Button(container, 32);
        this.showUntrackedButton.setText(UIText.CommitDialog_ShowUntrackedFiles);
        this.showUntrackedButton.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).span(2, 1).create());
        IDialogSettings settings = Activator.getDefault().getDialogSettings();
        if (settings.get(SHOW_UNTRACKED_PREF) != null) {
            this.showUntracked = Boolean.valueOf(settings.get(SHOW_UNTRACKED_PREF));
        }
        this.showUntrackedButton.setSelection(this.showUntracked);
        this.showUntrackedButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CommitDialog.this.showUntracked = CommitDialog.this.showUntrackedButton.getSelection();
                CommitDialog.this.filesViewer.refresh(true);
            }
        });
        this.commitText.getTextWidget().addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CommitDialog.this.updateSignedOffButton();
                CommitDialog.this.updateChangeIdButton();
            }
        });
        this.updateSignedOffButton();
        this.updateChangeIdButton();
        Table resourcesTable = new Table(container, 68386);
        resourcesTable.setLayoutData((Object)GridDataFactory.fillDefaults().hint(600, 200).span(2, 1).grab(true, true).create());
        resourcesTable.addSelectionListener((SelectionListener)new CommitItemSelectionListener());
        resourcesTable.setHeaderVisible(true);
        TableColumn statCol = new TableColumn(resourcesTable, 16384);
        statCol.setText(UIText.CommitDialog_Status);
        statCol.setWidth(150);
        statCol.addSelectionListener((SelectionListener)new HeaderSelectionListener(CommitItem.Order.ByStatus));
        TableColumn resourceCol = new TableColumn(resourcesTable, 16384);
        resourceCol.setText(UIText.CommitDialog_File);
        resourceCol.setWidth(415);
        resourceCol.addSelectionListener((SelectionListener)new HeaderSelectionListener(CommitItem.Order.ByFile));
        this.filesViewer = new CheckboxTableViewer(resourcesTable);
        this.filesViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.filesViewer.setUseHashlookup(true);
        this.filesViewer.setLabelProvider((IBaseLabelProvider)new CommitLabelProvider());
        this.filesViewer.addFilter((ViewerFilter)new CommitItemFilter());
        this.filesViewer.setInput((Object)this.items.toArray());
        this.filesViewer.getTable().setMenu(this.getContextMenu());
        if (!this.allowToChangeSelection) {
            this.amendingButton.setSelection(false);
            this.amendingButton.setEnabled(false);
            this.showUntrackedButton.setSelection(false);
            this.showUntrackedButton.setEnabled(false);
            this.filesViewer.addCheckStateListener(new ICheckStateListener(){

                public void checkStateChanged(CheckStateChangedEvent event) {
                    if (!event.getChecked()) {
                        CommitDialog.this.filesViewer.setAllChecked(true);
                    }
                }
            });
            this.filesViewer.setAllGrayed(true);
            this.filesViewer.setAllChecked(true);
        } else {
            for (CommitItem item : this.items) {
                if (!this.preselectedFiles.contains(item.file) || item.status == CommitItem.Status.UNTRACKED || item.status == CommitItem.Status.ASSUME_UNCHANGED) continue;
                this.filesViewer.setChecked((Object)item, true);
            }
        }
        CommitDialog.applyDialogFont((Control)container);
        container.pack();
        return container;
    }

    private String calculateCommitMessage() {
        if (this.commitMessage != null) {
            return this.commitMessage;
        }
        if (this.amending) {
            return this.previousCommitMessage;
        }
        String calculatedCommitMessage = null;
        HashSet<IProject> resources = new HashSet<IProject>();
        for (CommitItem item : this.items) {
            IProject resource = item.file.getProject();
            resources.add(resource);
        }
        try {
            ICommitMessageProvider messageProvider = this.getCommitMessageProvider();
            if (messageProvider != null) {
                IResource[] resourcesArray = resources.toArray(new IResource[0]);
                calculatedCommitMessage = messageProvider.getMessage(resourcesArray);
            }
        }
        catch (CoreException coreException) {
            org.eclipse.egit.core.Activator.error((String)coreException.getLocalizedMessage(), (Throwable)coreException);
        }
        if (calculatedCommitMessage != null) {
            return calculatedCommitMessage;
        }
        return "";
    }

    private ICommitMessageProvider getCommitMessageProvider() throws CoreException {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] config = registry.getConfigurationElementsFor(COMMIT_MESSAGE_PROVIDER_ID);
        if (config.length > 0) {
            Object provider = config[0].createExecutableExtension("class");
            if (provider instanceof ICommitMessageProvider) {
                return (ICommitMessageProvider)provider;
            }
            org.eclipse.egit.core.Activator.logError((String)UIText.CommitDialog_WrongTypeOfCommitMessageProvider, null);
        }
        return null;
    }

    private void saveOriginalChangeId() {
        int changeIdOffset = this.findOffsetOfChangeIdLine(this.previousCommitMessage);
        if (changeIdOffset > 0) {
            int endOfChangeId = this.findNextEOL(changeIdOffset, this.previousCommitMessage);
            if (endOfChangeId < 0) {
                endOfChangeId = this.previousCommitMessage.length() - 1;
            }
            int sha1Offset = changeIdOffset + "\nChange-Id: I".length();
            try {
                this.originalChangeId = ObjectId.fromString((String)this.previousCommitMessage.substring(sha1Offset, endOfChangeId));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.originalChangeId = null;
            }
        } else {
            this.originalChangeId = null;
        }
    }

    private int findNextEOL(int oldPos, String message) {
        return message.indexOf("\n", oldPos + 1);
    }

    private int findOffsetOfChangeIdLine(String message) {
        return message.indexOf("\nChange-Id: I");
    }

    private void updateSignedOffButton() {
        String curText = this.commitText.getText();
        if (!curText.endsWith(Text.DELIMITER)) {
            curText = String.valueOf(curText) + Text.DELIMITER;
        }
        this.signedOffButton.setSelection(curText.indexOf(String.valueOf(this.getSignedOff()) + Text.DELIMITER) != -1);
    }

    private void updateChangeIdButton() {
        boolean hasId;
        String curText = this.commitText.getText();
        if (!curText.endsWith(Text.DELIMITER)) {
            curText = String.valueOf(curText) + Text.DELIMITER;
        }
        boolean bl = hasId = curText.indexOf(String.valueOf(Text.DELIMITER) + "Change-Id: ") != -1;
        if (hasId) {
            this.changeIdButton.setSelection(true);
            this.createChangeId = true;
        }
    }

    private String getSignedOff() {
        return this.getSignedOff(this.committerText.getText());
    }

    private String getSignedOff(String signer) {
        return "Signed-off-by: " + signer;
    }

    private String signOff(String input) {
        String output = input;
        if (!output.endsWith(Text.DELIMITER)) {
            output = String.valueOf(output) + Text.DELIMITER;
        }
        if (!this.getLastLine(output).matches("[A-Za-z\\-]+:.*")) {
            output = String.valueOf(output) + Text.DELIMITER;
        }
        output = String.valueOf(output) + this.getSignedOff();
        return output;
    }

    private String getLastLine(String input) {
        String output = input;
        int breakLength = Text.DELIMITER.length();
        int lastIndexOfLineBreak = output.lastIndexOf(Text.DELIMITER);
        if (lastIndexOfLineBreak != -1 && lastIndexOfLineBreak == output.length() - breakLength) {
            output = output.substring(0, output.length() - breakLength);
        }
        return (lastIndexOfLineBreak = output.lastIndexOf(Text.DELIMITER)) == -1 ? output : output.substring(lastIndexOfLineBreak + breakLength, output.length());
    }

    private String replaceSignOff(String input, String oldSignOff, String newSignOff) {
        int indexOfSignOff;
        assert (input != null);
        assert (oldSignOff != null);
        assert (newSignOff != null);
        String curText = input;
        if (!curText.endsWith(Text.DELIMITER)) {
            curText = String.valueOf(curText) + Text.DELIMITER;
        }
        if ((indexOfSignOff = curText.indexOf(String.valueOf(oldSignOff) + Text.DELIMITER)) == -1) {
            return input;
        }
        return String.valueOf(input.substring(0, indexOfSignOff)) + newSignOff + input.substring(indexOfSignOff + oldSignOff.length(), input.length());
    }

    private Menu getContextMenu() {
        if (!this.allowToChangeSelection) {
            return null;
        }
        Menu menu = new Menu((Control)this.filesViewer.getTable());
        MenuItem item = new MenuItem(menu, 8);
        item.setText(UIText.CommitDialog_AddFileOnDiskToIndex);
        item.addListener(13, new Listener(){

            public void handleEvent(Event arg0) {
                IStructuredSelection sel = (IStructuredSelection)CommitDialog.this.filesViewer.getSelection();
                if (sel.isEmpty()) {
                    return;
                }
                try {
                    ArrayList<IFile> filesToAdd = new ArrayList<IFile>();
                    for (CommitItem commitItem : sel) {
                        filesToAdd.add(commitItem.file);
                    }
                    AddToIndexOperation op = new AddToIndexOperation(filesToAdd);
                    op.execute((IProgressMonitor)new NullProgressMonitor());
                    for (CommitItem commitItem : sel) {
                        commitItem.status = CommitDialog.getFileStatus(commitItem.file);
                    }
                    CommitDialog.this.filesViewer.refresh(true);
                }
                catch (CoreException e) {
                    org.eclipse.egit.core.Activator.logError((String)UIText.CommitDialog_ErrorAddingFiles, (Throwable)e);
                    return;
                }
                catch (IOException e) {
                    org.eclipse.egit.core.Activator.logError((String)UIText.CommitDialog_ErrorAddingFiles, (Throwable)e);
                    return;
                }
            }
        });
        return menu;
    }

    private static CommitItem.Status getFileStatus(String path, IndexDiff indexDiff) {
        if (indexDiff.getAssumeUnchanged().contains(path)) {
            return CommitItem.Status.ASSUME_UNCHANGED;
        }
        if (indexDiff.getAdded().contains(path)) {
            if (indexDiff.getModified().contains(path)) {
                return CommitItem.Status.ADDED_INDEX_DIFF;
            }
            return CommitItem.Status.ADDED;
        }
        if (indexDiff.getChanged().contains(path)) {
            if (indexDiff.getModified().contains(path)) {
                return CommitItem.Status.MODIFIED_INDEX_DIFF;
            }
            return CommitItem.Status.MODIFIED;
        }
        if (indexDiff.getUntracked().contains(path)) {
            if (indexDiff.getRemoved().contains(path)) {
                return CommitItem.Status.REMOVED_UNTRACKED;
            }
            return CommitItem.Status.UNTRACKED;
        }
        if (indexDiff.getRemoved().contains(path)) {
            return CommitItem.Status.REMOVED;
        }
        if (indexDiff.getMissing().contains(path)) {
            return CommitItem.Status.REMOVED_NOT_STAGED;
        }
        if (indexDiff.getModified().contains(path)) {
            return CommitItem.Status.MODIFIED_NOT_STAGED;
        }
        return CommitItem.Status.UNKNOWN;
    }

    private static CommitItem.Status getFileStatus(IFile file) throws IOException {
        RepositoryMapping mapping = RepositoryMapping.getMapping((IResource)file);
        String path = mapping.getRepoRelativePath((IResource)file);
        Repository repo = mapping.getRepository();
        AdaptableFileTreeIterator fileTreeIterator = new AdaptableFileTreeIterator(repo, ResourcesPlugin.getWorkspace().getRoot());
        IndexDiff indexDiff = new IndexDiff(repo, "HEAD", (WorkingTreeIterator)fileTreeIterator);
        Set<String> repositoryPaths = Collections.singleton(path);
        indexDiff.setFilter(PathFilterGroup.createFromStrings(repositoryPaths));
        indexDiff.diff(null, 0, 0, "");
        return CommitDialog.getFileStatus(path, indexDiff);
    }

    public String getCommitMessage() {
        return this.commitMessage;
    }

    public void setCommitMessage(String s) {
        this.commitMessage = s;
    }

    public void setSelectedFiles(IFile[] items) {
        Collections.addAll(this.selectedFiles, items);
    }

    public IFile[] getSelectedFiles() {
        return this.selectedFiles.toArray(new IFile[0]);
    }

    public void setPreselectedFiles(Set<IFile> preselectedFiles) {
        Assert.isNotNull(preselectedFiles);
        this.preselectedFiles = preselectedFiles;
    }

    protected void okPressed() {
        this.commitMessage = this.commitText.getCommitMessage();
        this.author = this.authorText.getText().trim();
        this.committer = this.committerText.getText().trim();
        this.signedOff = this.signedOffButton.getSelection();
        this.amending = this.amendingButton.getSelection();
        Object[] checkedElements = this.filesViewer.getCheckedElements();
        this.selectedFiles.clear();
        Object[] objectArray = checkedElements;
        int n = checkedElements.length;
        int n2 = 0;
        while (n2 < n) {
            Object obj = objectArray[n2];
            this.selectedFiles.add(((CommitItem)obj).file);
            ++n2;
        }
        if (this.commitMessage.trim().length() == 0) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)UIText.CommitDialog_ErrorNoMessage, (String)UIText.CommitDialog_ErrorMustEnterCommitMessage);
            return;
        }
        boolean authorValid = false;
        if (this.author.length() > 0) {
            boolean bl = authorValid = RawParseUtils.parsePersonIdent((String)this.author) != null;
        }
        if (!authorValid) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)UIText.CommitDialog_ErrorInvalidAuthor, (String)UIText.CommitDialog_ErrorInvalidAuthorSpecified);
            return;
        }
        boolean committerValid = false;
        if (this.committer.length() > 0) {
            boolean bl = committerValid = RawParseUtils.parsePersonIdent((String)this.committer) != null;
        }
        if (!committerValid) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)UIText.CommitDialog_ErrorInvalidAuthor, (String)UIText.CommitDialog_ErrorInvalidCommitterSpecified);
            return;
        }
        if (this.selectedFiles.isEmpty() && !this.amending) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)UIText.CommitDialog_ErrorNoItemsSelected, (String)UIText.CommitDialog_ErrorNoItemsSelectedToBeCommitted);
            return;
        }
        this.authorHandler.updateProposals();
        this.committerHandler.updateProposals();
        IDialogSettings settings = Activator.getDefault().getDialogSettings();
        settings.put(SHOW_UNTRACKED_PREF, this.showUntracked);
        super.okPressed();
    }

    public void setFiles(Set<IFile> files, Map<Repository, IndexDiff> indexDiffs) {
        this.items.clear();
        for (IFile file : files) {
            RepositoryMapping repositoryMapping = RepositoryMapping.getMapping((IResource)file.getProject());
            Repository repo = repositoryMapping.getRepository();
            String path = repositoryMapping.getRepoRelativePath((IResource)file);
            CommitItem item = new CommitItem();
            item.status = CommitDialog.getFileStatus(path, indexDiffs.get(repo));
            item.file = file;
            this.items.add(item);
        }
        Collections.sort(this.items, new Comparator<CommitItem>(){

            @Override
            public int compare(CommitItem o1, CommitItem o2) {
                int diff = o1.status.ordinal() - o2.status.ordinal();
                if (diff != 0) {
                    return diff;
                }
                diff = o1.file.getProject().getName().compareTo(o2.file.getProject().getName());
                if (diff != 0) {
                    return diff;
                }
                return o1.file.getProjectRelativePath().toString().compareTo(o2.file.getProjectRelativePath().toString());
            }
        });
    }

    protected void buttonPressed(int buttonId) {
        if (18 == buttonId) {
            this.filesViewer.setAllChecked(true);
        }
        if (19 == buttonId) {
            this.filesViewer.setAllChecked(false);
        }
        super.buttonPressed(buttonId);
    }

    public String getAuthor() {
        return this.author;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public String getCommitter() {
        return this.committer;
    }

    public void setCommitter(String committer) {
        this.committer = committer;
    }

    public void setPreviousAuthor(String previousAuthor) {
        this.previousAuthor = previousAuthor;
    }

    public boolean isSignedOff() {
        return this.signedOff;
    }

    public void setSignedOff(boolean signedOff) {
        this.signedOff = signedOff;
    }

    public boolean isAmending() {
        return this.amending;
    }

    public void setAmending(boolean amending) {
        this.amending = amending;
    }

    public void setPreviousCommitMessage(String string) {
        this.previousCommitMessage = string;
    }

    public void setAmendAllowed(boolean amendAllowed) {
        this.amendAllowed = amendAllowed;
    }

    public void setAllowToChangeSelection(boolean allowToChangeSelection) {
        this.allowToChangeSelection = allowToChangeSelection;
    }

    protected int getShellStyle() {
        return super.getShellStyle() | 0x10;
    }

    public boolean getCreateChangeId() {
        return this.createChangeId;
    }

    private void refreshChangeIdText() {
        this.createChangeId = this.changeIdButton.getSelection();
        String text = this.commitText.getText().replaceAll(Text.DELIMITER, "\n");
        if (this.createChangeId) {
            String changedText = ChangeIdUtil.insertId((String)text, (ObjectId)(this.originalChangeId != null ? this.originalChangeId : ObjectId.zeroId()), (boolean)true);
            if (!text.equals(changedText)) {
                changedText = changedText.replaceAll("\n", Text.DELIMITER);
                this.commitText.setText(changedText);
            }
        } else {
            int changeIdOffset = this.findOffsetOfChangeIdLine(text);
            if (changeIdOffset > 0) {
                int endOfChangeId = this.findNextEOL(changeIdOffset, text);
                String cleanedText = String.valueOf(text.substring(0, changeIdOffset)) + text.substring(endOfChangeId);
                cleanedText = cleanedText.replaceAll("\n", Text.DELIMITER);
                this.commitText.setText(cleanedText);
            }
        }
    }

    private final class CommitItemFilter
    extends ViewerFilter {
        private CommitItemFilter() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            boolean result = true;
            if (!(CommitDialog.this.showUntracked && CommitDialog.this.allowToChangeSelection || !(element instanceof CommitItem))) {
                CommitItem item = (CommitItem)element;
                if (item.status == CommitItem.Status.UNTRACKED) {
                    result = false;
                }
            }
            return result;
        }
    }

    class CommitItemSelectionListener
    extends SelectionAdapter {
        CommitItemSelectionListener() {
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            IStructuredSelection selection = (IStructuredSelection)CommitDialog.this.filesViewer.getSelection();
            CommitItem commitItem = (CommitItem)selection.getFirstElement();
            if (commitItem == null) {
                return;
            }
            if (commitItem.status == CommitItem.Status.UNTRACKED) {
                return;
            }
            IProject project = commitItem.file.getProject();
            RepositoryMapping mapping = RepositoryMapping.getMapping((IResource)project);
            if (mapping == null) {
                return;
            }
            Repository repository = mapping.getRepository();
            try {
                ObjectId id = repository.resolve("HEAD");
                if (id == null || repository.open((AnyObjectId)id, 1).getType() != 1) {
                    return;
                }
            }
            catch (IOException iOException) {
                return;
            }
            GitProvider provider = (GitProvider)RepositoryProvider.getProvider((IProject)project);
            GitFileHistoryProvider fileHistoryProvider = (GitFileHistoryProvider)provider.getFileHistoryProvider();
            IFileHistory fileHistory = fileHistoryProvider.getFileHistoryFor((IResource)commitItem.file, 1, null);
            IFileRevision baseFile = fileHistory.getFileRevisions()[0];
            IFileRevision nextFile = fileHistoryProvider.getWorkspaceFileRevision((IResource)commitItem.file);
            FileRevisionTypedElement base = new FileRevisionTypedElement(baseFile);
            FileRevisionTypedElement next = new FileRevisionTypedElement(nextFile);
            GitCompareFileRevisionEditorInput input = new GitCompareFileRevisionEditorInput(next, base, null);
            CompareUI.openCompareDialog((CompareEditorInput)input);
        }
    }

    static class CommitLabelProvider
    extends WorkbenchLabelProvider
    implements ITableLabelProvider {
        CommitLabelProvider() {
        }

        public String getColumnText(Object obj, int columnIndex) {
            CommitItem item = (CommitItem)obj;
            switch (columnIndex) {
                case 0: {
                    return item.status.getText();
                }
                case 1: {
                    return String.valueOf(item.file.getProject().getName()) + ": " + item.file.getProjectRelativePath();
                }
            }
            return null;
        }

        public Image getColumnImage(Object element, int columnIndex) {
            if (columnIndex == 0) {
                return this.getImage(element);
            }
            return null;
        }
    }

    class HeaderSelectionListener
    extends SelectionAdapter {
        private CommitItem.Order order;
        private Boolean reversed;

        public HeaderSelectionListener(CommitItem.Order order) {
            this.order = order;
        }

        public void widgetSelected(SelectionEvent e) {
            Comparator<CommitItem> comparator;
            TableColumn column = (TableColumn)e.widget;
            Table table = column.getParent();
            if (column == table.getSortColumn()) {
                int currentDirection = table.getSortDirection();
                switch (currentDirection) {
                    case 0: {
                        this.reversed = Boolean.FALSE;
                        break;
                    }
                    case 128: {
                        this.reversed = Boolean.TRUE;
                        break;
                    }
                    default: {
                        this.reversed = null;
                        break;
                    }
                }
            } else {
                this.reversed = Boolean.FALSE;
            }
            if (this.reversed == null) {
                table.setSortColumn(null);
                table.setSortDirection(0);
                CommitDialog.this.filesViewer.setComparator(null);
                return;
            }
            table.setSortColumn(column);
            if (this.reversed.booleanValue()) {
                comparator = this.order.descending();
                table.setSortDirection(1024);
            } else {
                comparator = this.order;
                table.setSortDirection(128);
            }
            CommitDialog.this.filesViewer.setComparator((ViewerComparator)new CommitViewerComparator(comparator));
        }
    }
}

