/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.dialogs;

import java.util.Collections;
import java.util.Comparator;
import org.eclipse.core.resources.IFile;
import org.eclipse.egit.ui.UIText;

class CommitItem {
    Status status;
    IFile file;

    CommitItem() {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Order implements Comparator<CommitItem>
    {
        ByStatus{

            public int compare(CommitItem o1, CommitItem o2) {
                return o1.status.compareTo(o2.status);
            }
        }
        ,
        ByFile{

            public int compare(CommitItem o1, CommitItem o2) {
                int diff = o1.file.getProject().getName().compareTo(o2.file.getProject().getName());
                if (diff != 0) {
                    return diff;
                }
                return o1.file.getProjectRelativePath().toString().compareTo(o2.file.getProjectRelativePath().toString());
            }
        };


        public Comparator<CommitItem> ascending() {
            return this;
        }

        public Comparator<CommitItem> descending() {
            return Collections.reverseOrder(this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Status {
        ADDED(UIText.CommitDialog_StatusAdded),
        MODIFIED(UIText.CommitDialog_StatusModified),
        REMOVED(UIText.CommitDialog_StatusRemoved),
        ADDED_INDEX_DIFF(UIText.CommitDialog_StatusAddedIndexDiff),
        MODIFIED_INDEX_DIFF(UIText.CommitDialog_StatusModifiedIndexDiff),
        MODIFIED_NOT_STAGED(UIText.CommitDialog_StatusModifiedNotStaged),
        REMOVED_NOT_STAGED(UIText.CommitDialog_StatusRemovedNotStaged),
        UNTRACKED(UIText.CommitDialog_StatusUntracked),
        REMOVED_UNTRACKED(UIText.CommitDialog_StatusRemovedUntracked),
        ASSUME_UNCHANGED(UIText.CommitDialog_StatusAssumeUnchaged),
        UNKNOWN(UIText.CommitDialog_StatusUnknown);

        private final String myText;

        public String getText() {
            return this.myText;
        }

        private Status(String text) {
            this.myText = text;
        }
    }
}

