/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.dialogs;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.UIIcons;
import org.eclipse.egit.ui.UIText;
import org.eclipse.egit.ui.UIUtils;
import org.eclipse.egit.ui.internal.CompareUtils;
import org.eclipse.egit.ui.internal.SWTUtils;
import org.eclipse.egit.ui.internal.ValidationUtils;
import org.eclipse.egit.ui.internal.dialogs.CommitCombo;
import org.eclipse.egit.ui.internal.dialogs.SpellcheckableMessageArea;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevObject;
import org.eclipse.jgit.revwalk.RevSort;
import org.eclipse.jgit.revwalk.RevTag;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.ExpandableComposite;
import org.eclipse.ui.model.WorkbenchLabelProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreateTagDialog
extends TitleAreaDialog {
    public static final int CLEAR_ID = 22;
    private String tagName;
    private String tagMessage;
    private ObjectId tagCommit;
    private boolean overwriteTag;
    private RevTag tag;
    private Repository repo;
    private Text tagNameText;
    private SpellcheckableMessageArea tagMessageText;
    private Button overwriteButton;
    private TableViewer tagViewer;
    private CommitCombo commitCombo;
    private Pattern tagNamePattern;
    private final String branchName;
    private final ObjectId commitId;
    private final IInputValidator tagNameValidator;
    private final RevWalk rw;

    public CreateTagDialog(Shell parent, String branchName, Repository repo) {
        super(parent);
        this.tagNameValidator = ValidationUtils.getRefNameInputValidator(repo, "refs/tags/", false);
        this.branchName = branchName;
        this.commitId = null;
        this.repo = repo;
        this.rw = new RevWalk(repo);
        this.setHelpAvailable(false);
    }

    public CreateTagDialog(Shell parent, ObjectId commitId, Repository repo) {
        super(parent);
        this.tagNameValidator = ValidationUtils.getRefNameInputValidator(repo, "refs/tags/", false);
        this.branchName = null;
        this.commitId = commitId;
        this.repo = repo;
        this.rw = new RevWalk(repo);
        this.setHelpAvailable(false);
    }

    public ObjectId getTagCommit() {
        return this.tagCommit;
    }

    public String getTagMessage() {
        return this.tagMessage;
    }

    public String getTagName() {
        return this.tagName;
    }

    public boolean shouldOverWriteTag() {
        return this.overwriteTag;
    }

    public void setTag(RevTag tag) {
        this.tag = tag;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(UIText.CreateTagDialog_NewTag);
        newShell.setMinimumSize(600, 400);
    }

    private String getTitle() {
        String title = "";
        if (this.branchName != null) {
            title = NLS.bind((String)UIText.CreateTagDialog_questionNewTagTitle, (Object)this.branchName);
        } else if (this.commitId != null) {
            title = NLS.bind((String)UIText.CreateTagDialog_CreateTagOnCommitTitle, (Object)CompareUtils.truncatedRevision(this.commitId.getName()));
        }
        return title;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        parent.setLayout((Layout)GridLayoutFactory.swtDefaults().create());
        parent.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).create());
        Button clearButton = this.createButton(parent, 22, UIText.CreateTagDialog_clearButton, false);
        clearButton.setToolTipText(UIText.CreateTagDialog_clearButtonTooltip);
        this.setButtonLayoutData(clearButton);
        Composite margin = new Composite(parent, 0);
        margin.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).create());
        super.createButtonsForButtonBar(parent);
        this.validateInput();
    }

    public void create() {
        super.create();
        Job job = new Job(UIText.CreateTagDialog_GetTagJobName){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    final List tags = CreateTagDialog.this.getRevTags();
                    PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                        public void run() {
                            if (!CreateTagDialog.this.tagViewer.getTable().isDisposed()) {
                                CreateTagDialog.this.tagViewer.setInput((Object)tags);
                                CreateTagDialog.this.tagViewer.getTable().setEnabled(true);
                            }
                        }
                    });
                }
                catch (IOException e) {
                    CreateTagDialog.this.setErrorMessage(UIText.CreateTagDialog_ExceptionRetrievingTagsMessage);
                    return Activator.createErrorStatus(e.getMessage(), e);
                }
                return Status.OK_STATUS;
            }
        };
        job.setSystem(true);
        job.schedule();
    }

    public boolean close() {
        this.rw.dispose();
        return super.close();
    }

    protected Control createDialogArea(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        this.setTitle(this.getTitle());
        this.setMessage(UIText.CreateTagDialog_Message);
        Composite composite = (Composite)super.createDialogArea(parent);
        SashForm mainForm = new SashForm(composite, 260);
        mainForm.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).create());
        this.createLeftSection(mainForm);
        this.createExistingTagsSection((Composite)mainForm);
        mainForm.setWeights(new int[]{70, 30});
        if (this.tag != null) {
            this.setTagImpl();
        }
        CreateTagDialog.applyDialogFont((Control)parent);
        return composite;
    }

    protected void buttonPressed(int buttonId) {
        switch (buttonId) {
            case 22: {
                this.tagNameText.setText("");
                this.tagMessageText.setText("");
                if (this.commitCombo != null) {
                    this.commitCombo.clearSelection();
                    this.commitCombo.setEnabled(true);
                }
                this.tagNameText.setEnabled(true);
                this.tagMessageText.setEnabled(true);
                this.overwriteButton.setEnabled(false);
                this.overwriteButton.setSelection(false);
                break;
            }
            case 0: {
                this.tagName = this.tagNameText.getText();
                if (this.commitCombo != null) {
                    this.tagCommit = this.commitCombo.getValue();
                }
                this.tagMessage = this.tagMessageText.getText();
                this.overwriteTag = this.overwriteButton.getSelection();
            }
            default: {
                super.buttonPressed(buttonId);
            }
        }
    }

    protected boolean isResizable() {
        return true;
    }

    private void createLeftSection(SashForm mainForm) {
        Composite left = new Composite((Composite)mainForm, 16);
        left.setLayout((Layout)GridLayoutFactory.swtDefaults().margins(10, 5).create());
        left.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).create());
        Label label = new Label(left, 64);
        label.setText(UIText.CreateTagDialog_tagName);
        GridData data = new GridData(772);
        data.widthHint = this.convertHorizontalDLUsToPixels(150);
        label.setLayoutData((Object)data);
        label.setFont(left.getFont());
        this.tagNameText = new Text(left, 2052);
        this.tagNameText.setLayoutData((Object)new GridData(768));
        this.tagNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String textValue = Pattern.quote(CreateTagDialog.this.tagNameText.getText());
                CreateTagDialog.this.tagNamePattern = Pattern.compile(textValue, 2);
                CreateTagDialog.this.tagViewer.refresh();
                CreateTagDialog.this.validateInput();
            }
        });
        UIUtils.addBulbDecorator((Control)this.tagNameText, UIText.CreateTagDialog_tagNameToolTip);
        new Label(left, 64).setText(UIText.CreateTagDialog_tagMessage);
        this.tagMessageText = new SpellcheckableMessageArea(left, this.tagMessage);
        this.tagMessageText.setLayoutData(GridDataFactory.fillDefaults().minSize(50, 50).grab(true, true).create());
        this.tagMessageText.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent arg0) {
                if (arg0.keyCode == 13 && (arg0.stateMask & 0x40000) > 0) {
                    Button button = CreateTagDialog.this.getButton(0);
                    if (button != null && button.isEnabled()) {
                        CreateTagDialog.this.buttonPressed(0);
                    }
                } else if (arg0.keyCode == 9 && (arg0.stateMask & 0x20000) == 0) {
                    arg0.doit = false;
                    CreateTagDialog.this.tagMessageText.traverse(16);
                }
            }
        });
        this.tagMessageText.getTextWidget().addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CreateTagDialog.this.validateInput();
            }
        });
        this.overwriteButton = new Button(left, 32);
        this.overwriteButton.setEnabled(false);
        this.overwriteButton.setText(UIText.CreateTagDialog_overwriteTag);
        this.overwriteButton.setToolTipText(UIText.CreateTagDialog_overwriteTagToolTip);
        this.overwriteButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean state = CreateTagDialog.this.overwriteButton.getSelection();
                CreateTagDialog.this.tagNameText.setEnabled(state);
                if (CreateTagDialog.this.commitCombo != null) {
                    CreateTagDialog.this.commitCombo.setEnabled(state);
                }
                CreateTagDialog.this.tagMessageText.setEnabled(state);
                CreateTagDialog.this.validateInput();
            }
        });
        this.createAdvancedSection(left);
    }

    private void createAdvancedSection(final Composite composite) {
        if (this.commitId != null) {
            return;
        }
        ExpandableComposite advanced = new ExpandableComposite(composite, 20);
        advanced.setText(UIText.CreateTagDialog_advanced);
        advanced.setToolTipText(UIText.CreateTagDialog_advancedToolTip);
        advanced.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).create());
        Composite advancedComposite = new Composite((Composite)advanced, 64);
        advancedComposite.setLayout((Layout)GridLayoutFactory.swtDefaults().create());
        advancedComposite.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).create());
        Label advancedLabel = new Label(advancedComposite, 64);
        advancedLabel.setText(UIText.CreateTagDialog_advancedMessage);
        advancedLabel.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).create());
        this.commitCombo = new CommitCombo(advancedComposite, 0);
        this.commitCombo.setLayoutData(GridDataFactory.fillDefaults().grab(true, false).hint(300, -1).create());
        advanced.setClient((Control)advancedComposite);
        advanced.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent e) {
                if (((Boolean)e.data).booleanValue() && CreateTagDialog.this.commitCombo.getItemCount() == 0) {
                    final ArrayList commits = new ArrayList();
                    try {
                        PlatformUI.getWorkbench().getProgressService().busyCursorWhile(new IRunnableWithProgress(){

                            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                                CreateTagDialog.this.getRevCommits(commits);
                            }
                        });
                    }
                    catch (InvocationTargetException e1) {
                        Activator.logError(e1.getMessage(), e1);
                    }
                    catch (InterruptedException interruptedException) {}
                    for (RevCommit revCommit : commits) {
                        CreateTagDialog.this.commitCombo.add(revCommit);
                    }
                }
                composite.layout(true);
            }
        });
    }

    private void createExistingTagsSection(Composite parent) {
        Composite right = new Composite(parent, 0);
        right.setLayout((Layout)GridLayoutFactory.swtDefaults().create());
        right.setLayoutData((Object)GridLayoutFactory.fillDefaults().create());
        new Label(right, 64).setText(UIText.CreateTagDialog_existingTags);
        Table table = new Table(right, 2820);
        table.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).hint(80, 100).create());
        TableLayout layout = new TableLayout();
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(100, 20));
        table.setLayout((Layout)layout);
        this.tagViewer = new TableViewer(table);
        this.tagViewer.setLabelProvider((IBaseLabelProvider)new TagLabelProvider());
        this.tagViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.tagViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                CreateTagDialog.this.fillTagDialog(event.getSelection());
            }
        });
        this.tagViewer.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                String name;
                if (CreateTagDialog.this.tagNamePattern == null) {
                    return true;
                }
                if (element instanceof String) {
                    return true;
                }
                if (element instanceof Ref) {
                    Ref t = (Ref)element;
                    name = t.getName().substring(10);
                } else if (element instanceof RevTag) {
                    RevTag t = (RevTag)element;
                    name = t.getTagName();
                } else {
                    return true;
                }
                return CreateTagDialog.this.tagNamePattern.matcher(name).find();
            }
        });
        this.tagViewer.setInput((Object)new String[]{UIText.CreateTagDialog_LoadingMessageText});
        this.tagViewer.getTable().setEnabled(false);
        CreateTagDialog.applyDialogFont((Control)parent);
    }

    private void validateInput() {
        if (this.getShell() == null) {
            return;
        }
        String tagNameMessage = this.tagNameValidator.isValid(this.tagNameText.getText());
        this.setErrorMessage(tagNameMessage);
        String tagMessageVal = this.tagMessageText.getText().trim();
        Button button = this.getButton(0);
        if (button != null) {
            boolean containsTagNameAndMessage = (tagNameMessage == null || tagMessageVal.length() == 0) && tagMessageVal.length() != 0;
            boolean shouldOverwriteTag = this.overwriteButton.getSelection() && Repository.isValidRefName((String)("refs/tags/" + this.tagNameText.getText()));
            button.setEnabled(containsTagNameAndMessage || shouldOverwriteTag);
        }
    }

    private void fillTagDialog(ISelection actSelection) {
        IStructuredSelection selection = (IStructuredSelection)actSelection;
        Object firstSelected = selection.getFirstElement();
        if (!(firstSelected instanceof RevTag)) {
            this.setErrorMessage(UIText.CreateTagDialog_LightweightTagMessage);
            return;
        }
        this.tag = (RevTag)firstSelected;
        if (!this.overwriteButton.isEnabled()) {
            String tagMessageValue = this.tag.getFullMessage();
            if (tagMessageValue != null && tagMessageValue.trim().length() != 0) {
                this.overwriteButton.setEnabled(true);
            }
            this.tagNameText.setEnabled(false);
            if (this.commitCombo != null) {
                this.commitCombo.setEnabled(false);
            }
            this.tagMessageText.setEnabled(false);
        }
        this.setTagImpl();
    }

    private void setTagImpl() {
        String message;
        this.tagNameText.setText(this.tag.getTagName());
        if (this.commitCombo != null) {
            this.commitCombo.setSelectedElement((ObjectId)this.tag.getObject());
        }
        this.tagMessageText.setText((message = this.tag.getFullMessage()) != null ? message : "");
    }

    private void getRevCommits(Collection<RevCommit> commits) {
        RevWalk revWalk = new RevWalk(this.repo);
        revWalk.sort(RevSort.COMMIT_TIME_DESC, true);
        revWalk.sort(RevSort.BOUNDARY, true);
        try {
            ObjectId headId = this.repo.resolve("HEAD");
            if (headId != null) {
                revWalk.markStart(revWalk.parseCommit((AnyObjectId)headId));
            }
        }
        catch (IOException e) {
            Activator.logError(UIText.TagAction_errorWhileGettingRevCommits, e);
            this.setErrorMessage(UIText.TagAction_errorWhileGettingRevCommits);
        }
        for (RevCommit commit : revWalk) {
            commits.add(commit);
        }
    }

    private List<Object> getRevTags() throws IOException {
        ArrayList<Object> result = new ArrayList<Object>();
        Collection refs = this.repo.getRefDatabase().getRefs("refs/tags/").values();
        for (Ref ref : refs) {
            RevObject any;
            try {
                any = this.rw.parseAny((AnyObjectId)this.repo.resolve(ref.getName()));
            }
            catch (IOException e) {
                Activator.handleError(e.getMessage(), e, true);
                break;
            }
            if (any instanceof RevTag) {
                result.add(any);
                continue;
            }
            result.add(ref);
        }
        return result;
    }

    private static class TagLabelProvider
    extends WorkbenchLabelProvider
    implements ITableLabelProvider {
        private final Image IMG_TAG;
        private final Image IMG_LIGHTTAG;
        private final ResourceManager fImageCache = new LocalResourceManager(JFaceResources.getResources());

        private TagLabelProvider() {
            this.IMG_TAG = this.fImageCache.createImage(UIIcons.TAG);
            this.IMG_LIGHTTAG = SWTUtils.getDecoratedImage(this.fImageCache.createImage(UIIcons.TAG), UIIcons.OVR_LIGHTTAG);
        }

        public Image getColumnImage(Object element, int columnIndex) {
            if (element instanceof String) {
                return null;
            }
            if (element instanceof Ref) {
                return this.IMG_LIGHTTAG;
            }
            return this.IMG_TAG;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof String) {
                return (String)element;
            }
            if (element instanceof Ref) {
                return ((Ref)element).getName().substring(10);
            }
            return ((RevTag)element).getTagName();
        }

        public void dispose() {
            this.fImageCache.dispose();
            super.dispose();
        }
    }
}

