/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.fetch;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.egit.ui.UIText;
import org.eclipse.egit.ui.internal.fetch.TrackingRefUpdateContentProvider;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.RefUpdate;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.transport.FetchResult;
import org.eclipse.jgit.transport.TrackingRefUpdate;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Widget;

class FetchResultTable {
    private static final int TABLE_PREFERRED_HEIGHT = 600;
    private static final int TABLE_PREFERRED_WIDTH = 300;
    private static final int COLUMN_SRC_WEIGHT = 10;
    private static final int COLUMN_DST_WEIGHT = 10;
    private static final int COLUMN_STATUS_WEIGHT = 7;
    private final Composite tablePanel;
    private final TableViewer tableViewer;
    private final Color rejectedColor;
    private final Color updatedColor;
    private final Color upToDateColor;
    private ObjectReader reader;
    private Map<ObjectId, String> abbrevations;

    FetchResultTable(Composite parent) {
        this.tablePanel = new Composite(parent, 0);
        this.tablePanel.setLayout((Layout)new GridLayout());
        GridData layoutData = new GridData(4, 4, true, true);
        layoutData.heightHint = 600;
        layoutData.widthHint = 300;
        this.tableViewer = new TableViewer(this.tablePanel);
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.tableViewer);
        Table table = this.tableViewer.getTable();
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        this.rejectedColor = new Color((Device)parent.getDisplay(), 255, 0, 0);
        this.updatedColor = new Color((Device)parent.getDisplay(), 0, 255, 0);
        this.upToDateColor = new Color((Device)parent.getDisplay(), 245, 245, 245);
        this.tablePanel.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (FetchResultTable.this.reader != null) {
                    FetchResultTable.this.reader.release();
                }
                FetchResultTable.this.rejectedColor.dispose();
                FetchResultTable.this.updatedColor.dispose();
                FetchResultTable.this.upToDateColor.dispose();
            }
        });
        this.tableViewer.setContentProvider((IContentProvider)new TrackingRefUpdateContentProvider());
        this.tableViewer.setInput(null);
        this.createTableColumns();
    }

    void setData(Repository db, FetchResult fetchResult) {
        this.tableViewer.setInput(null);
        this.reader = db.newObjectReader();
        this.abbrevations = new HashMap<ObjectId, String>();
        this.tableViewer.setInput((Object)fetchResult);
    }

    Control getControl() {
        return this.tablePanel;
    }

    private void createTableColumns() {
        TableColumnLayout layout = new TableColumnLayout();
        this.tablePanel.setLayout((Layout)layout);
        TableViewerColumn srcViewer = this.createColumn(layout, UIText.FetchResultTable_columnSrc, 10, 16384);
        srcViewer.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((TrackingRefUpdate)element).getRemoteName();
            }
        });
        TableViewerColumn dstViewer = this.createColumn(layout, UIText.FetchResultTable_columnDst, 10, 16384);
        dstViewer.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((TrackingRefUpdate)element).getLocalName();
            }
        });
        TableViewerColumn statusViewer = this.createColumn(layout, UIText.FetchResultTable_columnStatus, 7, 16384);
        statusViewer.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                TrackingRefUpdate tru = (TrackingRefUpdate)element;
                RefUpdate.Result r = tru.getResult();
                if (r == RefUpdate.Result.LOCK_FAILURE) {
                    return UIText.FetchResultTable_statusLockFailure;
                }
                if (r == RefUpdate.Result.IO_FAILURE) {
                    return UIText.FetchResultTable_statusIOError;
                }
                if (r == RefUpdate.Result.NEW) {
                    if (tru.getRemoteName().startsWith("refs/heads/")) {
                        return UIText.FetchResultTable_statusNewBranch;
                    }
                    if (tru.getLocalName().startsWith("refs/tags/")) {
                        return UIText.FetchResultTable_statusNewTag;
                    }
                    return UIText.FetchResultTable_statusNew;
                }
                if (r == RefUpdate.Result.FORCED) {
                    String o = this.safeAbbreviate(tru.getOldObjectId());
                    String n = this.safeAbbreviate(tru.getNewObjectId());
                    return String.valueOf(o) + "..." + n;
                }
                if (r == RefUpdate.Result.FAST_FORWARD) {
                    String o = this.safeAbbreviate(tru.getOldObjectId());
                    String n = this.safeAbbreviate(tru.getNewObjectId());
                    return String.valueOf(o) + ".." + n;
                }
                if (r == RefUpdate.Result.REJECTED) {
                    return UIText.FetchResultTable_statusRejected;
                }
                if (r == RefUpdate.Result.NO_CHANGE) {
                    return UIText.FetchResultTable_statusUpToDate;
                }
                throw new IllegalArgumentException(NLS.bind((String)UIText.FetchResultTable_statusUnexpected, (Object)r));
            }

            private String safeAbbreviate(ObjectId id) {
                String abbrev = (String)FetchResultTable.this.abbrevations.get(id);
                if (abbrev == null) {
                    try {
                        abbrev = FetchResultTable.this.reader.abbreviate((AnyObjectId)id).name();
                    }
                    catch (IOException iOException) {
                        abbrev = id.name();
                    }
                    FetchResultTable.this.abbrevations.put(id, abbrev);
                }
                return abbrev;
            }

            public String getToolTipText(Object element) {
                RefUpdate.Result result = ((TrackingRefUpdate)element).getResult();
                switch (result) {
                    case FAST_FORWARD: {
                        return UIText.FetchResultTable_statusDetailFastForward;
                    }
                    case FORCED: 
                    case REJECTED: {
                        return UIText.FetchResultTable_statusDetailNonFastForward;
                    }
                    case NO_CHANGE: 
                    case NEW: {
                        return null;
                    }
                    case IO_FAILURE: {
                        return UIText.FetchResultTable_statusDetailIOError;
                    }
                    case LOCK_FAILURE: {
                        return UIText.FetchResultTable_statusDetailCouldntLock;
                    }
                }
                throw new IllegalArgumentException(NLS.bind((String)UIText.FetchResultTable_statusUnexpected, (Object)result));
            }

            public Color getBackground(Object element) {
                RefUpdate.Result result = ((TrackingRefUpdate)element).getResult();
                switch (result) {
                    case NEW: 
                    case FORCED: 
                    case FAST_FORWARD: {
                        return FetchResultTable.this.updatedColor;
                    }
                    case NO_CHANGE: {
                        return FetchResultTable.this.upToDateColor;
                    }
                    case LOCK_FAILURE: 
                    case REJECTED: 
                    case IO_FAILURE: {
                        return FetchResultTable.this.rejectedColor;
                    }
                }
                throw new IllegalArgumentException(NLS.bind((String)UIText.FetchResultTable_statusUnexpected, (Object)result));
            }
        });
    }

    private TableViewerColumn createColumn(TableColumnLayout columnLayout, String text, int weight, int style) {
        TableViewerColumn viewerColumn = new TableViewerColumn(this.tableViewer, style);
        TableColumn column = viewerColumn.getColumn();
        column.setText(text);
        columnLayout.setColumnData((Widget)column, (ColumnLayoutData)new ColumnWeightData(weight));
        return viewerColumn;
    }
}

