/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.fetch;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.UIText;
import org.eclipse.egit.ui.internal.fetch.FetchOperationUI;
import org.eclipse.egit.ui.internal.fetch.FetchResultDialog;
import org.eclipse.egit.ui.internal.fetch.SimpleFetchRefSpecWizard;
import org.eclipse.egit.ui.internal.push.RefSpecDialog;
import org.eclipse.egit.ui.internal.push.RefSpecWizard;
import org.eclipse.egit.ui.internal.repository.SelectUriWizard;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.StoredConfig;
import org.eclipse.jgit.transport.RefSpec;
import org.eclipse.jgit.transport.RemoteConfig;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.SWT;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.ExpandableComposite;

public class SimpleConfigureFetchDialog
extends TitleAreaDialog {
    private static final int DRY_RUN = 98;
    private static final int SAVE_ONLY = 97;
    private static final int REVERT = 96;
    private static final String ADVANCED_MODE_PREFERENCE = String.valueOf(SimpleConfigureFetchDialog.class.getName()) + "_ADVANCED_MODE";
    private final Repository repository;
    private RemoteConfig config;
    private Text commonUriText;
    private TableViewer specViewer;
    private Button changeCommonUri;
    private Button addRefSpec;
    private Button changeRefSpec;
    private Button addRefSpecAdvanced;

    public static Dialog getDialog(Shell shell, Repository repository) {
        RemoteConfig configToUse = SimpleConfigureFetchDialog.getConfiguredRemote(repository);
        return new SimpleConfigureFetchDialog(shell, repository, configToUse);
    }

    public static RemoteConfig getConfiguredRemote(Repository repository) {
        ArrayList allRemotes;
        String branch;
        try {
            branch = repository.getBranch();
        }
        catch (IOException e) {
            Activator.handleError(e.getMessage(), e, true);
            return null;
        }
        String remoteName = ObjectId.isId((String)branch) ? "origin" : repository.getConfig().getString("branch", branch, "remote");
        try {
            allRemotes = RemoteConfig.getAllRemoteConfigs((Config)repository.getConfig());
        }
        catch (URISyntaxException uRISyntaxException) {
            allRemotes = new ArrayList();
        }
        RemoteConfig defaultConfig = null;
        RemoteConfig configuredConfig = null;
        for (RemoteConfig config : allRemotes) {
            if (config.getName().equals("origin")) {
                defaultConfig = config;
            }
            if (remoteName == null || !config.getName().equals(remoteName)) continue;
            configuredConfig = config;
        }
        RemoteConfig configToUse = configuredConfig != null ? configuredConfig : defaultConfig;
        return configToUse;
    }

    private SimpleConfigureFetchDialog(Shell shell, Repository repository, RemoteConfig config) {
        super(shell);
        this.setHelpAvailable(false);
        this.repository = repository;
        this.config = config;
    }

    protected Control createDialogArea(Composite parent) {
        String branch;
        boolean advancedMode = Activator.getDefault().getPreferenceStore().getBoolean(ADVANCED_MODE_PREFERENCE);
        Composite main = new Composite(parent, 0);
        main.setLayout((Layout)new GridLayout(1, false));
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)main);
        Composite repositoryGroup = new Composite(main, 16);
        repositoryGroup.setLayout((Layout)new GridLayout(2, false));
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)repositoryGroup);
        Label repositoryLabel = new Label(repositoryGroup, 0);
        repositoryLabel.setText(UIText.SimpleConfigureFetchDialog_RepositoryLabel);
        Text repositoryText = new Text(repositoryGroup, 2056);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)repositoryText);
        repositoryText.setText(Activator.getDefault().getRepositoryUtil().getRepositoryName(this.repository));
        Label branchLabel = new Label(repositoryGroup, 0);
        branchLabel.setText(UIText.SimpleConfigureFetchDialog_BranchLabel);
        try {
            branch = this.repository.getBranch();
        }
        catch (IOException iOException) {
            branch = null;
        }
        if (branch == null || ObjectId.isId((String)branch)) {
            branch = UIText.SimpleConfigureFetchDialog_DetachedHeadMessage;
        }
        Text branchText = new Text(repositoryGroup, 2056);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)branchText);
        branchText.setText(branch);
        Group remoteGroup = new Group(main, 16);
        remoteGroup.setLayout((Layout)new GridLayout(1, false));
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)remoteGroup);
        remoteGroup.setText(NLS.bind((String)UIText.SimpleConfigureFetchDialog_RemoteGroupHeader, (Object)this.config.getName()));
        this.addDefaultOriginWarningIfNeeded((Composite)remoteGroup);
        Composite sameUriDetails = new Composite((Composite)remoteGroup, 0);
        sameUriDetails.setLayout((Layout)new GridLayout(4, false));
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)sameUriDetails);
        Label commonUriLabel = new Label(sameUriDetails, 0);
        commonUriLabel.setText(UIText.SimpleConfigureFetchDialog_UriLabel);
        this.commonUriText = new Text(sameUriDetails, 2056);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.commonUriText);
        this.changeCommonUri = new Button(sameUriDetails, 8);
        this.changeCommonUri.setText(UIText.SimpleConfigureFetchDialog_ChangeUriButton);
        this.changeCommonUri.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SelectUriWizard wiz = SimpleConfigureFetchDialog.this.commonUriText.getText().length() > 0 ? new SelectUriWizard(false, SimpleConfigureFetchDialog.this.commonUriText.getText()) : new SelectUriWizard(false);
                if (new WizardDialog(SimpleConfigureFetchDialog.this.getShell(), (IWizard)wiz).open() == 0) {
                    if (SimpleConfigureFetchDialog.this.commonUriText.getText().length() > 0) {
                        try {
                            SimpleConfigureFetchDialog.this.config.removeURI(new URIish(SimpleConfigureFetchDialog.this.commonUriText.getText()));
                        }
                        catch (URISyntaxException ex) {
                            Activator.handleError(ex.getMessage(), ex, true);
                        }
                    }
                    SimpleConfigureFetchDialog.this.config.addURI(wiz.getUri());
                    SimpleConfigureFetchDialog.this.updateControls();
                }
            }
        });
        final Button deleteCommonUri = new Button(sameUriDetails, 8);
        deleteCommonUri.setText(UIText.SimpleConfigureFetchDialog_DeleteUriButton);
        deleteCommonUri.setEnabled(false);
        deleteCommonUri.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SimpleConfigureFetchDialog.this.config.removeURI((URIish)SimpleConfigureFetchDialog.this.config.getURIs().get(0));
                SimpleConfigureFetchDialog.this.updateControls();
            }
        });
        this.commonUriText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                deleteCommonUri.setEnabled(SimpleConfigureFetchDialog.this.commonUriText.getText().length() > 0);
            }
        });
        final Group refSpecGroup = new Group((Composite)remoteGroup, 16);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)refSpecGroup);
        refSpecGroup.setText(UIText.SimpleConfigureFetchDialog_RefMappingGroup);
        refSpecGroup.setLayout((Layout)new GridLayout(5, false));
        ExpandableComposite advanced = new ExpandableComposite((Composite)refSpecGroup, 20);
        if (advancedMode) {
            advanced.setExpanded(true);
        }
        advanced.setText(UIText.SimpleConfigureFetchDialog_AdvancedCompositeButton);
        GridDataFactory.fillDefaults().align(1, 4).span(5, 1).grab(true, false).applyTo((Control)advanced);
        advanced.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent e) {
                Activator.getDefault().getPreferenceStore().setValue(ADVANCED_MODE_PREFERENCE, e.getState());
                GridData data = (GridData)SimpleConfigureFetchDialog.this.changeRefSpec.getLayoutData();
                data.exclude = !e.getState();
                SimpleConfigureFetchDialog.this.changeRefSpec.setVisible(!data.exclude);
                refSpecGroup.layout(true);
            }
        });
        Label refSpecLabel = new Label((Composite)refSpecGroup, 0);
        refSpecLabel.setText(UIText.SimpleConfigureFetchDialog_RefSpecLabel);
        GridDataFactory.fillDefaults().span(5, 1).applyTo((Control)refSpecLabel);
        this.specViewer = new TableViewer((Composite)refSpecGroup, 2050);
        this.specViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        GridDataFactory.fillDefaults().hint(-1, 150).span(5, 1).grab(true, true).applyTo((Control)this.specViewer.getTable());
        this.specViewer.getTable().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.stateMask == SWT.MOD1 && e.keyCode == 118) {
                    SimpleConfigureFetchDialog.this.doPaste();
                }
            }
        });
        this.addRefSpec = new Button((Composite)refSpecGroup, 8);
        this.addRefSpec.setText(UIText.SimpleConfigureFetchDialog_AddRefSpecButton);
        this.addRefSpec.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SimpleFetchRefSpecWizard wiz = new SimpleFetchRefSpecWizard(SimpleConfigureFetchDialog.this.repository, SimpleConfigureFetchDialog.this.config);
                WizardDialog dlg = new WizardDialog(SimpleConfigureFetchDialog.this.getShell(), (IWizard)wiz);
                if (dlg.open() == 0) {
                    SimpleConfigureFetchDialog.this.config.addFetchRefSpec(wiz.getSpec());
                }
                SimpleConfigureFetchDialog.this.updateControls();
            }
        });
        this.changeRefSpec = new Button((Composite)refSpecGroup, 8);
        this.changeRefSpec.setText(UIText.SimpleConfigureFetchDialog_ChangeRefSpecButton);
        this.changeRefSpec.setEnabled(false);
        GridDataFactory.fillDefaults().exclude(!advancedMode).applyTo((Control)this.changeRefSpec);
        this.changeRefSpec.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RefSpec oldSpec = (RefSpec)((IStructuredSelection)SimpleConfigureFetchDialog.this.specViewer.getSelection()).getFirstElement();
                RefSpecDialog dlg = new RefSpecDialog(SimpleConfigureFetchDialog.this.getShell(), SimpleConfigureFetchDialog.this.repository, SimpleConfigureFetchDialog.this.config, oldSpec, false);
                if (dlg.open() == 0) {
                    SimpleConfigureFetchDialog.this.config.removeFetchRefSpec(oldSpec);
                    SimpleConfigureFetchDialog.this.config.addFetchRefSpec(dlg.getSpec());
                }
                SimpleConfigureFetchDialog.this.updateControls();
            }
        });
        final Button deleteRefSpec = new Button((Composite)refSpecGroup, 8);
        deleteRefSpec.setText(UIText.SimpleConfigureFetchDialog_DeleteRefSpecButton);
        deleteRefSpec.setEnabled(false);
        deleteRefSpec.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object[] objectArray = ((IStructuredSelection)SimpleConfigureFetchDialog.this.specViewer.getSelection()).toArray();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object spec = objectArray[n2];
                    SimpleConfigureFetchDialog.this.config.removeFetchRefSpec((RefSpec)spec);
                    ++n2;
                }
                SimpleConfigureFetchDialog.this.updateControls();
            }
        });
        final Button copySpec = new Button((Composite)refSpecGroup, 8);
        copySpec.setText(UIText.SimpleConfigureFetchDialog_CopyRefSpecButton);
        copySpec.setEnabled(false);
        copySpec.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String toCopy = ((IStructuredSelection)SimpleConfigureFetchDialog.this.specViewer.getSelection()).getFirstElement().toString();
                Clipboard clipboard = new Clipboard(SimpleConfigureFetchDialog.this.getShell().getDisplay());
                try {
                    clipboard.setContents((Object[])new String[]{toCopy}, (Transfer[])new TextTransfer[]{TextTransfer.getInstance()});
                }
                finally {
                    clipboard.dispose();
                }
            }
        });
        Button pasteSpec = new Button((Composite)refSpecGroup, 8);
        pasteSpec.setText(UIText.SimpleConfigureFetchDialog_PateRefSpecButton);
        pasteSpec.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SimpleConfigureFetchDialog.this.doPaste();
            }
        });
        this.addRefSpecAdvanced = new Button((Composite)advanced, 8);
        advanced.setClient((Control)this.addRefSpecAdvanced);
        GridDataFactory.fillDefaults().align(1, 4).applyTo((Control)this.addRefSpecAdvanced);
        this.addRefSpecAdvanced.setText(UIText.SimpleConfigureFetchDialog_EditAdvancedButton);
        this.addRefSpecAdvanced.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (new WizardDialog(SimpleConfigureFetchDialog.this.getShell(), (IWizard)new RefSpecWizard(SimpleConfigureFetchDialog.this.repository, SimpleConfigureFetchDialog.this.config, false)).open() == 0) {
                    SimpleConfigureFetchDialog.this.updateControls();
                }
            }
        });
        this.specViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection sel = (IStructuredSelection)SimpleConfigureFetchDialog.this.specViewer.getSelection();
                copySpec.setEnabled(sel.size() == 1);
                SimpleConfigureFetchDialog.this.changeRefSpec.setEnabled(sel.size() == 1);
                deleteRefSpec.setEnabled(!sel.isEmpty());
            }
        });
        SimpleConfigureFetchDialog.applyDialogFont((Control)main);
        return main;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, UIText.SimpleConfigureFetchDialog_SaveAndFetchButton, true);
        this.createButton(parent, 97, UIText.SimpleConfigureFetchDialog_SaveButton, false);
        this.createButton(parent, 98, UIText.SimpleConfigureFetchDialog_DryRunButton, false);
        this.createButton(parent, 96, UIText.SimpleConfigureFetchDialog_RevertButton, false);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(UIText.SimpleConfigureFetchDialog_WindowTitle);
    }

    public void create() {
        super.create();
        String repoName = Activator.getDefault().getRepositoryUtil().getRepositoryName(this.repository);
        this.setTitle(NLS.bind((String)UIText.SimpleConfigureFetchDialog_DialogTitle, (Object)repoName, (Object)this.config.getName()));
        this.setMessage(UIText.SimpleConfigureFetchDialog_DialogMessage);
        this.updateControls();
    }

    private void updateControls() {
        this.setErrorMessage(null);
        boolean anyUri = false;
        if (!this.config.getURIs().isEmpty()) {
            this.commonUriText.setText(((URIish)this.config.getURIs().get(0)).toPrivateString());
            anyUri = true;
        } else {
            this.commonUriText.setText("");
        }
        this.specViewer.setInput((Object)this.config.getFetchRefSpecs());
        this.specViewer.getTable().setEnabled(true);
        this.addRefSpec.setEnabled(anyUri);
        this.addRefSpecAdvanced.setEnabled(anyUri);
        if (this.config.getURIs().isEmpty()) {
            this.setErrorMessage(UIText.SimpleConfigureFetchDialog_MissingUriMessage);
        } else if (this.config.getFetchRefSpecs().isEmpty()) {
            this.setErrorMessage(UIText.SimpleConfigureFetchDialog_MissingMappingMessage);
        }
        boolean anySpec = !this.config.getFetchRefSpecs().isEmpty();
        this.getButton(0).setEnabled(anyUri && anySpec);
        this.getButton(97).setEnabled(anyUri && anySpec);
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 98) {
            try {
                new ProgressMonitorDialog(this.getShell()).run(false, true, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        int timeout = Activator.getDefault().getPreferenceStore().getInt("remote_connection_timeout");
                        FetchOperationUI op = new FetchOperationUI(SimpleConfigureFetchDialog.this.repository, SimpleConfigureFetchDialog.this.config, timeout, true);
                        try {
                            FetchResultDialog dlg = new FetchResultDialog(SimpleConfigureFetchDialog.this.getShell(), SimpleConfigureFetchDialog.this.repository, op.execute(monitor), op.getSourceString());
                            dlg.showConfigureButton(false);
                            dlg.open();
                        }
                        catch (CoreException e) {
                            Activator.handleError(e.getMessage(), e, true);
                        }
                    }
                });
            }
            catch (InvocationTargetException e1) {
                Activator.handleError(e1.getMessage(), e1, true);
            }
            catch (InterruptedException interruptedException) {}
            return;
        }
        if (buttonId == 96) {
            try {
                this.config = new RemoteConfig((Config)this.repository.getConfig(), this.config.getName());
                this.updateControls();
            }
            catch (URISyntaxException e) {
                Activator.handleError(e.getMessage(), e, true);
            }
            return;
        }
        if (buttonId == 0 || buttonId == 97) {
            this.config.update((Config)this.repository.getConfig());
            try {
                this.repository.getConfig().save();
            }
            catch (IOException e) {
                Activator.handleError(e.getMessage(), e, true);
            }
            if (buttonId == 0) {
                try {
                    new ProgressMonitorDialog(this.getShell()).run(false, true, new IRunnableWithProgress(){

                        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                            int timeout = Activator.getDefault().getPreferenceStore().getInt("remote_connection_timeout");
                            FetchOperationUI op = new FetchOperationUI(SimpleConfigureFetchDialog.this.repository, SimpleConfigureFetchDialog.this.config, timeout, false);
                            op.start();
                        }
                    });
                }
                catch (InvocationTargetException e) {
                    Activator.handleError(e.getMessage(), e, true);
                }
                catch (InterruptedException e) {
                    Activator.handleError(e.getMessage(), e, true);
                }
            }
            this.okPressed();
            return;
        }
        super.buttonPressed(buttonId);
    }

    private void doPaste() {
        Clipboard clipboard = new Clipboard(this.getShell().getDisplay());
        try {
            String content = (String)clipboard.getContents((Transfer)TextTransfer.getInstance());
            if (content == null) {
                MessageDialog.openConfirm((Shell)this.getShell(), (String)UIText.SimpleConfigureFetchDialog_NothingToPasteMessage, (String)UIText.SimpleConfigureFetchDialog_EmptyClipboardMessage);
            }
            try {
                Ref source;
                RefSpec spec = new RefSpec(content);
                try {
                    source = this.repository.getRef(spec.getDestination());
                }
                catch (IOException iOException) {
                    source = null;
                }
                if (source != null || MessageDialog.openQuestion((Shell)this.getShell(), (String)UIText.SimpleConfigureFetchDialog_InvalidRefDialogTitle, (String)NLS.bind((String)UIText.SimpleConfigureFetchDialog_InvalidRefDialogMessage, (Object)spec.toString()))) {
                    this.config.addFetchRefSpec(spec);
                }
                this.updateControls();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                MessageDialog.openError((Shell)this.getShell(), (String)UIText.SimpleConfigureFetchDialog_NotRefSpecDialogTitle, (String)UIText.SimpleConfigureFetchDialog_NotRefSpecDialogMessage);
            }
        }
        finally {
            clipboard.dispose();
        }
    }

    private void addDefaultOriginWarningIfNeeded(Composite parent) {
        String currentBranch;
        ArrayList<String> otherBranches = new ArrayList<String>();
        try {
            currentBranch = this.repository.getBranch();
        }
        catch (IOException iOException) {
            return;
        }
        String currentRemote = this.config.getName();
        StoredConfig repositoryConfig = this.repository.getConfig();
        Set branches = repositoryConfig.getSubsections("branch");
        for (String branch : branches) {
            String remote;
            if (branch.equals(currentBranch) || ((remote = repositoryConfig.getString("branch", branch, "remote")) != null || !currentRemote.equals("origin")) && (remote == null || !remote.equals(currentRemote))) continue;
            otherBranches.add(branch);
        }
        if (otherBranches.isEmpty()) {
            return;
        }
        Composite warningAboutOrigin = new Composite(parent, 0);
        warningAboutOrigin.setLayout((Layout)new GridLayout(2, false));
        Label warningLabel = new Label(warningAboutOrigin, 0);
        warningLabel.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_WARN_TSK"));
        Text warningText = new Text(warningAboutOrigin, 8);
        warningText.setText(NLS.bind((String)UIText.SimpleConfigureFetchDialog_ReusedRemoteWarning, (Object)this.config.getName(), (Object)otherBranches.size()));
        warningText.setToolTipText(((Object)otherBranches).toString());
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)warningLabel);
    }
}

