/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.history;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.IParameter;
import org.eclipse.core.commands.Parameterization;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.core.resources.IResource;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.UIIcons;
import org.eclipse.egit.ui.UIText;
import org.eclipse.egit.ui.UIUtils;
import org.eclipse.egit.ui.internal.history.GraphContentProvider;
import org.eclipse.egit.ui.internal.history.GraphLabelProvider;
import org.eclipse.egit.ui.internal.history.HistoryPageInput;
import org.eclipse.egit.ui.internal.history.SWTCommit;
import org.eclipse.egit.ui.internal.history.SWTCommitList;
import org.eclipse.egit.ui.internal.history.SWTPlotRenderer;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jgit.revplot.PlotCommit;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevFlag;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.MenuDetectEvent;
import org.eclipse.swt.events.MenuDetectListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.menus.CommandContributionItem;
import org.eclipse.ui.menus.CommandContributionItemParameter;
import org.eclipse.ui.part.IPageSite;
import org.eclipse.ui.services.IServiceLocator;

class CommitGraphTable {
    private static final String LINESEP = System.getProperty("line.separator");
    private final TableViewer table;
    private Clipboard clipboard;
    private final SWTPlotRenderer renderer;
    private final Font nFont = UIUtils.getFont("org.eclipse.egit.ui.CommitGraphNormalFont");
    private final Font hFont = CommitGraphTable.highlightFont();
    private SWTCommitList allCommits;
    private HashMap<String, PlotCommit> commitsMap = null;
    private RevFlag highlight;
    private HistoryPageInput input;
    IAction copy;
    MenuListener menuListener;

    private static Font highlightFont() {
        FontData[] hData;
        Font n = UIUtils.getFont("org.eclipse.egit.ui.CommitGraphNormalFont");
        Font h = UIUtils.getFont("org.eclipse.egit.ui.CommitGraphHighlightFont");
        FontData[] nData = n.getFontData();
        if (nData.length != (hData = h.getFontData()).length) {
            return h;
        }
        int i = 0;
        while (i < nData.length) {
            if (!nData[i].equals((Object)hData[i])) {
                return h;
            }
            ++i;
        }
        return UIUtils.getBoldFont("org.eclipse.egit.ui.CommitGraphNormalFont");
    }

    CommitGraphTable(Composite parent) {
        Table rawTable = new Table(parent, 268503810);
        rawTable.setHeaderVisible(true);
        rawTable.setLinesVisible(false);
        rawTable.setFont(this.nFont);
        TableLayout layout = new TableLayout();
        rawTable.setLayout((Layout)layout);
        this.createColumns(rawTable, layout);
        this.createPaintListener(rawTable);
        this.table = new TableViewer(rawTable){

            protected Widget doFindItem(Object element) {
                return element != null ? ((SWTCommit)((Object)element)).widget : null;
            }

            protected void mapElement(Object element, Widget item) {
                ((SWTCommit)((Object)element)).widget = item;
            }
        };
        this.table.setLabelProvider((IBaseLabelProvider)new GraphLabelProvider());
        this.table.setContentProvider((IContentProvider)new GraphContentProvider());
        this.renderer = new SWTPlotRenderer(rawTable.getDisplay());
        this.clipboard = new Clipboard(rawTable.getDisplay());
        rawTable.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                CommitGraphTable.this.clipboard.dispose();
            }
        });
        this.copy = this.createStandardAction(ActionFactory.COPY);
        this.table.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                CommitGraphTable.this.copy.setEnabled(CommitGraphTable.this.canDoCopy());
            }
        });
    }

    CommitGraphTable(Composite parent, final IPageSite site, MenuManager menuMgr) {
        this(parent);
        final IAction selectAll = this.createStandardAction(ActionFactory.SELECT_ALL);
        this.getControl().addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
                site.getActionBars().setGlobalActionHandler(ActionFactory.SELECT_ALL.getId(), null);
                site.getActionBars().setGlobalActionHandler(ActionFactory.COPY.getId(), null);
                site.getActionBars().updateActionBars();
            }

            public void focusGained(FocusEvent e) {
                site.getActionBars().setGlobalActionHandler(ActionFactory.SELECT_ALL.getId(), selectAll);
                site.getActionBars().setGlobalActionHandler(ActionFactory.COPY.getId(), CommitGraphTable.this.copy);
                site.getActionBars().updateActionBars();
            }
        });
        this.getTableView().addOpenListener(new IOpenListener(){

            public void open(OpenEvent event) {
                Parameterization[] parms;
                if (CommitGraphTable.this.input == null || !CommitGraphTable.this.input.isSingleFile()) {
                    return;
                }
                ICommandService srv = (ICommandService)site.getService(ICommandService.class);
                IHandlerService hsrv = (IHandlerService)site.getService(IHandlerService.class);
                Command cmd = srv.getCommand("org.eclipse.egit.ui.history.ShowVersions");
                if (Activator.getDefault().getPreferenceStore().getBoolean("resourcehistory_compare_mode")) {
                    try {
                        IParameter parm = cmd.getParameter("org.eclipse.egit.ui.history.CompareMode");
                        parms = new Parameterization[]{new Parameterization(parm, Boolean.TRUE.toString())};
                    }
                    catch (NotDefinedException e) {
                        Activator.handleError(e.getMessage(), e, true);
                        parms = null;
                    }
                } else {
                    parms = null;
                }
                ParameterizedCommand pcmd = new ParameterizedCommand(cmd, parms);
                try {
                    hsrv.executeCommandInContext(pcmd, null, hsrv.getCurrentState());
                }
                catch (Exception e) {
                    Activator.handleError(e.getMessage(), e, true);
                }
            }
        });
        Control c = this.getControl();
        menuMgr.add((IContributionItem)new Separator("additions"));
        c.setMenu(menuMgr.createContextMenu(c));
        this.menuListener = new MenuListener(menuMgr, (ISelectionProvider)this.getTableView(), site, this.copy);
        c.addMenuDetectListener((MenuDetectListener)this.menuListener);
    }

    Control getControl() {
        return this.table.getControl();
    }

    void selectCommit(RevCommit c) {
        if (c instanceof PlotCommit) {
            this.table.setSelection((ISelection)new StructuredSelection((Object)c));
            this.table.reveal((Object)c);
        } else {
            PlotCommit swtCommit = this.commitsMap.get(c.getId().name());
            this.table.setSelection((ISelection)new StructuredSelection((Object)swtCommit));
            this.table.reveal((Object)swtCommit);
        }
    }

    void addSelectionChangedListener(ISelectionChangedListener l) {
        this.table.addPostSelectionChangedListener(l);
    }

    void removeSelectionChangedListener(ISelectionChangedListener l) {
        this.table.removePostSelectionChangedListener(l);
    }

    private boolean canDoCopy() {
        return !this.table.getSelection().isEmpty();
    }

    private void doCopy() {
        ISelection s = this.table.getSelection();
        if (s.isEmpty() || !(s instanceof IStructuredSelection)) {
            return;
        }
        IStructuredSelection iss = (IStructuredSelection)s;
        Iterator itr = iss.iterator();
        StringBuilder r = new StringBuilder();
        while (itr.hasNext()) {
            PlotCommit d = (PlotCommit)itr.next();
            if (r.length() > 0) {
                r.append(LINESEP);
            }
            r.append(d.getId().name());
        }
        this.clipboard.setContents(new Object[]{r.toString()}, new Transfer[]{TextTransfer.getInstance()}, 1);
    }

    void setInput(RevFlag hFlag, SWTCommitList list, SWTCommit[] asArray, HistoryPageInput input) {
        this.input = input;
        if (this.menuListener != null) {
            this.menuListener.setInput(input);
        }
        SWTCommitList oldList = this.allCommits;
        this.highlight = hFlag;
        this.allCommits = list;
        this.table.setInput((Object)asArray);
        if (asArray != null && asArray.length > 0) {
            if (oldList != list) {
                this.selectCommit((RevCommit)asArray[0]);
                this.initCommitsMap();
            }
        } else {
            this.table.getTable().deselectAll();
        }
    }

    private void initCommitsMap() {
        this.commitsMap = new HashMap();
        Iterator iterator = this.allCommits.iterator();
        while (iterator.hasNext()) {
            PlotCommit commit = (PlotCommit)iterator.next();
            this.commitsMap.put(commit.getId().name(), commit);
        }
    }

    private void createColumns(Table rawTable, TableLayout layout) {
        TableColumn graph = new TableColumn(rawTable, 0);
        graph.setResizable(true);
        graph.setText("");
        graph.setWidth(250);
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(20, true));
        TableColumn author = new TableColumn(rawTable, 0);
        author.setResizable(true);
        author.setText(UIText.HistoryPage_authorColumn);
        author.setWidth(250);
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(10, true));
        TableColumn date = new TableColumn(rawTable, 0);
        date.setResizable(true);
        date.setText(UIText.HistoryPage_dateColumn);
        date.setWidth(250);
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(5, true));
        TableColumn commitId = new TableColumn(rawTable, 0);
        commitId.setResizable(true);
        commitId.setText(UIText.CommitGraphTable_CommitId);
        commitId.setWidth(50);
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(3, true));
        TableColumn committer = new TableColumn(rawTable, 0);
        committer.setResizable(true);
        committer.setText(UIText.CommitGraphTable_Committer);
        committer.setWidth(100);
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(5, true));
    }

    private void createPaintListener(Table rawTable) {
        rawTable.addListener(40, new Listener(){

            public void handleEvent(Event event) {
                if (event.index >= 0 && event.index <= 4) {
                    event.detail &= 0xFFFFFFEF;
                }
            }
        });
        rawTable.addListener(42, new Listener(){

            public void handleEvent(Event event) {
                CommitGraphTable.this.doPaint(event);
            }
        });
    }

    void doPaint(Event event) {
        RevCommit c = (RevCommit)((TableItem)event.item).getData();
        if (this.highlight != null && c.has(this.highlight)) {
            event.gc.setFont(this.hFont);
        } else {
            event.gc.setFont(this.nFont);
        }
        if (event.index == 0) {
            this.renderer.paint(event);
            return;
        }
        ITableLabelProvider lbl = (ITableLabelProvider)this.table.getLabelProvider();
        String txt = lbl.getColumnText((Object)c, event.index);
        Point textsz = event.gc.textExtent(txt);
        int texty = (event.height - textsz.y) / 2;
        event.gc.drawString(txt, event.x, event.y + texty, true);
    }

    public TableViewer getTableView() {
        return this.table;
    }

    private IAction createStandardAction(final ActionFactory af) {
        final String text = af.create(PlatformUI.getWorkbench().getActiveWorkbenchWindow()).getText();
        Action action = new Action(){

            public String getActionDefinitionId() {
                return af.getCommandId();
            }

            public String getId() {
                return af.getId();
            }

            public String getText() {
                return text;
            }

            public void run() {
                if (af == ActionFactory.SELECT_ALL) {
                    CommitGraphTable.this.table.getTable().selectAll();
                }
                if (af == ActionFactory.COPY) {
                    CommitGraphTable.this.doCopy();
                }
            }
        };
        return action;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class MenuListener
    implements MenuDetectListener {
        private final MenuManager popupMgr;
        private final ISelectionProvider selectionProvider;
        private final IPageSite site;
        private final IAction copyAction;
        private HistoryPageInput input;

        MenuListener(MenuManager menuManager, ISelectionProvider selectionProvider, IPageSite site, IAction copyAction) {
            this.popupMgr = menuManager;
            this.selectionProvider = selectionProvider;
            this.site = site;
            this.copyAction = copyAction;
        }

        public void setInput(HistoryPageInput input) {
            this.input = input;
        }

        public void menuDetected(MenuDetectEvent e) {
            HashMap<String, String> parameters;
            this.popupMgr.removeAll();
            int selectionSize = ((IStructuredSelection)this.selectionProvider.getSelection()).size();
            if (this.input.isSingleFile()) {
                if (selectionSize == 1) {
                    if (this.input.getSingleFile() instanceof IResource) {
                        this.popupMgr.add((IContributionItem)this.getCommandContributionItem("org.eclipse.egit.ui.history.CompareWithWorkingTree", UIText.GitHistoryPage_CompareWithWorkingTreeMenuMenuLabel));
                    } else {
                        this.popupMgr.add((IContributionItem)this.getCommandContributionItem("org.eclipse.egit.ui.history.CompareWithWorkingTree", UIText.GitHistoryPage_CompareWithCurrentHeadMenu));
                    }
                }
                if (selectionSize > 0) {
                    this.popupMgr.add((IContributionItem)this.getCommandContributionItem("org.eclipse.egit.ui.history.ShowVersions", UIText.GitHistoryPage_OpenMenuLabel));
                    this.popupMgr.add((IContributionItem)this.getCommandContributionItem("org.eclipse.egit.ui.history.OpenInTextEditorCommand", UIText.GitHistoryPage_OpenInTextEditorLabel));
                }
            }
            if (selectionSize == 1) {
                this.popupMgr.add((IContributionItem)new Separator());
                this.popupMgr.add((IContributionItem)this.getCommandContributionItem("org.eclipse.egit.ui.history.CheckoutCommand", UIText.GitHistoryPage_CheckoutMenuLabel));
                this.popupMgr.add((IContributionItem)this.getCommandContributionItem("org.eclipse.egit.ui.history.CreateBranch", UIText.GitHistoryPage_CreateBranchMenuLabel));
                this.popupMgr.add((IContributionItem)this.getCommandContributionItem("org.eclipse.egit.ui.history.CreateTag", UIText.GitHistoryPage_CreateTagMenuLabel));
                this.popupMgr.add((IContributionItem)this.getCommandContributionItem("org.eclipse.egit.ui.history.CreatePatch", UIText.GitHistoryPage_CreatePatchMenuLabel));
                this.popupMgr.add((IContributionItem)this.getCommandContributionItem("org.eclipse.egit.ui.history.CherryPick", UIText.GitHistoryPage_cherryPickMenuItem));
                this.popupMgr.add((IContributionItem)this.getCommandContributionItem("org.eclipse.egit.ui.history.Revert", UIText.GitHistoryPage_revertMenuItem));
                this.popupMgr.add((IContributionItem)this.getCommandContributionItem("org.eclipse.egit.ui.history.Merge", UIText.GitHistoryPage_mergeMenuItem));
                this.popupMgr.add((IContributionItem)this.getCommandContributionItem("org.eclipse.egit.ui.history.RebaseCurrent", UIText.GitHistoryPage_rebaseMenuItem));
                this.popupMgr.add((IContributionItem)new Separator());
                MenuManager resetManager = new MenuManager(UIText.GitHistoryPage_ResetMenuLabel, UIIcons.RESET, "Reset");
                this.popupMgr.add((IContributionItem)resetManager);
                parameters = new HashMap();
                parameters.put("org.eclipse.egit.ui.history.ResetMode", "Soft");
                resetManager.add((IContributionItem)this.getCommandContributionItem("org.eclipse.egit.ui.history.Reset", UIText.GitHistoryPage_ResetSoftMenuLabel, parameters));
                parameters = new HashMap();
                parameters.put("org.eclipse.egit.ui.history.ResetMode", "Mixed");
                resetManager.add((IContributionItem)this.getCommandContributionItem("org.eclipse.egit.ui.history.Reset", UIText.GitHistoryPage_ResetMixedMenuLabel, parameters));
                parameters = new HashMap();
                parameters.put("org.eclipse.egit.ui.history.ResetMode", "Hard");
                resetManager.add((IContributionItem)this.getCommandContributionItem("org.eclipse.egit.ui.history.Reset", UIText.GitHistoryPage_ResetHardMenuLabel, parameters));
            } else if (selectionSize == 2) {
                this.popupMgr.add((IContributionItem)this.getCommandContributionItem("org.eclipse.egit.ui.history.CompareVersions", UIText.GitHistoryPage_CompareWithEachOtherMenuLabel));
                if (!this.input.isSingleFile()) {
                    this.popupMgr.add((IContributionItem)this.getCommandContributionItem("org.eclipse.egit.ui.history.CompareVersionsInTree", UIText.CommitGraphTable_CompareWithEachOtherInTreeMenuLabel));
                }
            }
            this.popupMgr.add((IContributionItem)new Separator());
            MenuManager quickDiffManager = new MenuManager(UIText.GitHistoryPage_QuickdiffMenuLabel, null, "Quickdiff");
            this.popupMgr.add((IContributionItem)quickDiffManager);
            quickDiffManager.add((IContributionItem)this.getCommandContributionItem("org.eclipse.egit.ui.history.SetQuickdiffBaseline", UIText.GitHistoryPage_SetAsBaselineMenuLabel));
            parameters = new HashMap<String, String>();
            parameters.put("org.eclipse.egit.ui.history.ResetQuickdiffBaselineTarget", "HEAD");
            quickDiffManager.add((IContributionItem)this.getCommandContributionItem("org.eclipse.egit.ui.history.ResetQuickdiffBaseline", UIText.GitHistoryPage_ResetBaselineToHeadMenuLabel, parameters));
            parameters = new HashMap();
            parameters.put("org.eclipse.egit.ui.history.ResetQuickdiffBaselineTarget", "HEAD^1");
            quickDiffManager.add((IContributionItem)this.getCommandContributionItem("org.eclipse.egit.ui.history.ResetQuickdiffBaseline", UIText.GitHistoryPage_ResetBaselineToParentOfHeadMenuLabel, parameters));
            this.popupMgr.add((IContributionItem)new Separator("additions"));
            this.popupMgr.add(this.copyAction);
            this.popupMgr.add((IContributionItem)new Separator());
        }

        private CommandContributionItem getCommandContributionItem(String commandId, String menuLabel) {
            CommandContributionItemParameter parameter = new CommandContributionItemParameter((IServiceLocator)this.site, commandId, commandId, 8);
            parameter.label = menuLabel;
            return new CommandContributionItem(parameter);
        }

        private CommandContributionItem getCommandContributionItem(String commandId, String menuLabel, Map<String, String> parameters) {
            CommandContributionItemParameter parameter = new CommandContributionItemParameter((IServiceLocator)this.site, commandId, commandId, 8);
            parameter.label = menuLabel;
            parameter.parameters = parameters;
            return new CommandContributionItem(parameter);
        }
    }
}

