/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.history;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.UIText;
import org.eclipse.egit.ui.UIUtils;
import org.eclipse.egit.ui.internal.CompareUtils;
import org.eclipse.egit.ui.internal.history.CommitNavigationListener;
import org.eclipse.egit.ui.internal.history.FileDiff;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.DefaultTextDoubleClickStrategy;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextDoubleClickStrategy;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jgit.diff.DiffFormatter;
import org.eclipse.jgit.diff.RawText;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revplot.PlotCommit;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevObject;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.part.IPageSite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class CommitMessageViewer
extends TextViewer
implements ISelectionChangedListener {
    private final ListenerList navListeners = new ListenerList();
    private final DateFormat fmt = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private PlotCommit<?> commit;
    private Color sys_linkColor;
    private Color sys_darkgray;
    private Color sys_hunkHeaderColor;
    private Color sys_linesAddedColor;
    private Color sys_linesRemovedColor;
    private Cursor sys_linkCursor;
    private Cursor sys_normalCursor;
    private boolean fill;
    private Repository db;
    private TreeWalk walker;
    private IPropertyChangeListener listener;
    private String currentEncoding = null;
    private static final String SPACE = " ";
    private static final String LF = "\n";

    CommitMessageViewer(Composite parent, final IPageSite site) {
        super(parent, 776);
        final StyledText t = this.getTextWidget();
        t.setFont(UIUtils.getFont("org.eclipse.egit.ui.CommitMessageFont"));
        this.sys_linkColor = t.getDisplay().getSystemColor(9);
        this.sys_darkgray = t.getDisplay().getSystemColor(16);
        this.sys_hunkHeaderColor = t.getDisplay().getSystemColor(9);
        this.sys_linesAddedColor = t.getDisplay().getSystemColor(6);
        this.sys_linesRemovedColor = t.getDisplay().getSystemColor(4);
        this.sys_linkCursor = t.getDisplay().getSystemCursor(21);
        this.sys_normalCursor = t.getCursor();
        t.addListener(5, new Listener(){

            public void handleEvent(Event e) {
                int o;
                try {
                    o = t.getOffsetAtLocation(new Point(e.x, e.y));
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    t.setCursor(CommitMessageViewer.this.sys_normalCursor);
                    return;
                }
                StyleRange r = t.getStyleRangeAtOffset(o);
                if (r instanceof ObjectLink) {
                    t.setCursor(CommitMessageViewer.this.sys_linkCursor);
                } else {
                    t.setCursor(CommitMessageViewer.this.sys_normalCursor);
                }
            }
        });
        t.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                int o;
                if (e.button != 1) {
                    return;
                }
                try {
                    o = t.getOffsetAtLocation(new Point(e.x, e.y));
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    return;
                }
                StyleRange r = t.getStyleRangeAtOffset(o);
                if (r instanceof ObjectLink) {
                    RevCommit c = ((ObjectLink)r).targetCommit;
                    Object[] objectArray = CommitMessageViewer.this.navListeners.getListeners();
                    int n = objectArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object l = objectArray[n2];
                        ((CommitNavigationListener)l).showCommit(c);
                        ++n2;
                    }
                }
            }
        });
        this.setTextDoubleClickStrategy((ITextDoubleClickStrategy)new DefaultTextDoubleClickStrategy(), "__dftl_partition_content_type");
        this.activatePlugins();
        this.listener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (event.getProperty().equals("resourcehistory_show_comment_wrap")) {
                    CommitMessageViewer.this.setWrap((Boolean)event.getNewValue());
                    return;
                }
                if (event.getProperty().equals("resourcehistory_fill_comment_paragraph")) {
                    CommitMessageViewer.this.setFill((Boolean)event.getNewValue());
                    return;
                }
            }
        };
        Action selectAll = new Action(){

            public void run() {
                CommitMessageViewer.this.doOperation(7);
            }

            public boolean isEnabled() {
                return CommitMessageViewer.this.canDoOperation(7);
            }
        };
        Action copy = new Action(){

            public void run() {
                CommitMessageViewer.this.doOperation(4);
            }

            public boolean isEnabled() {
                return CommitMessageViewer.this.canDoOperation(4);
            }
        };
        Activator.getDefault().getPreferenceStore().addPropertyChangeListener(this.listener);
        this.getControl().addFocusListener(new FocusListener((IAction)selectAll, (IAction)copy){
            private final /* synthetic */ IAction val$selectAll;
            private final /* synthetic */ IAction val$copy;
            {
                this.val$selectAll = iAction;
                this.val$copy = iAction2;
            }

            public void focusLost(FocusEvent e) {
                site.getActionBars().setGlobalActionHandler(ActionFactory.SELECT_ALL.getId(), null);
                site.getActionBars().setGlobalActionHandler(ActionFactory.COPY.getId(), null);
                site.getActionBars().updateActionBars();
            }

            public void focusGained(FocusEvent e) {
                site.getActionBars().setGlobalActionHandler(ActionFactory.SELECT_ALL.getId(), this.val$selectAll);
                site.getActionBars().setGlobalActionHandler(ActionFactory.COPY.getId(), this.val$copy);
                site.getActionBars().updateActionBars();
            }
        });
    }

    protected void handleDispose() {
        Activator.getDefault().getPreferenceStore().removePropertyChangeListener(this.listener);
        super.handleDispose();
    }

    void addCommitNavigationListener(CommitNavigationListener l) {
        this.navListeners.add((Object)l);
    }

    void removeCommitNavigationListener(CommitNavigationListener l) {
        this.navListeners.remove((Object)l);
    }

    public void setInput(Object input) {
        this.commit = (PlotCommit)input;
        this.format();
    }

    public Object getInput() {
        return this.commit;
    }

    void setTreeWalk(TreeWalk walk) {
        this.walker = walk;
    }

    private void format() {
        Matcher spm;
        String tagsString;
        Object p;
        RevCommit p2;
        if (this.commit == null) {
            this.setDocument((IDocument)new Document(UIText.CommitMessageViewer_SelectOneCommitMessage));
            return;
        }
        PersonIdent author = this.commit.getAuthorIdent();
        PersonIdent committer = this.commit.getCommitterIdent();
        StringBuilder d = new StringBuilder();
        ArrayList<StyleRange> styles = new ArrayList<StyleRange>();
        d.append(UIText.CommitMessageViewer_commit);
        d.append(SPACE);
        d.append(this.commit.getId().name());
        d.append(LF);
        if (author != null) {
            d.append(UIText.CommitMessageViewer_author);
            d.append(": ");
            d.append(author.getName());
            d.append(" <");
            d.append(author.getEmailAddress());
            d.append("> ");
            d.append(this.fmt.format(author.getWhen()));
            d.append(LF);
        }
        if (committer != null) {
            d.append(UIText.CommitMessageViewer_committer);
            d.append(": ");
            d.append(committer.getName());
            d.append(" <");
            d.append(committer.getEmailAddress());
            d.append("> ");
            d.append(this.fmt.format(committer.getWhen()));
            d.append(LF);
        }
        int i = 0;
        while (i < this.commit.getParentCount()) {
            p2 = this.commit.getParent(i);
            d.append(UIText.CommitMessageViewer_parent);
            d.append(": ");
            this.addLink(d, styles, p2);
            d.append(" (");
            d.append(p2.getShortMessage());
            d.append(")");
            d.append(LF);
            ++i;
        }
        i = 0;
        while (i < this.commit.getChildCount()) {
            p2 = this.commit.getChild(i);
            d.append(UIText.CommitMessageViewer_child);
            d.append(": ");
            this.addLink(d, styles, p2);
            d.append(" (");
            d.append(p2.getShortMessage());
            d.append(")");
            d.append(LF);
            ++i;
        }
        List<Ref> branches = this.getBranches();
        if (!branches.isEmpty()) {
            d.append(UIText.CommitMessageViewer_branches);
            d.append(": ");
            Iterator<Ref> i2 = branches.iterator();
            while (i2.hasNext()) {
                Ref head = i2.next();
                try {
                    p = new RevWalk(this.db).parseCommit((AnyObjectId)head.getObjectId());
                    this.addLink(d, this.formatHeadRef(head), styles, (RevCommit)p);
                    if (!i2.hasNext()) continue;
                    d.append(", ");
                }
                catch (MissingObjectException e) {
                    Activator.logError(e.getMessage(), e);
                }
                catch (IncorrectObjectTypeException e) {
                    Activator.logError(e.getMessage(), e);
                }
                catch (IOException e) {
                    Activator.logError(e.getMessage(), e);
                }
            }
            d.append(LF);
        }
        if ((tagsString = this.getTagsString()).length() > 0) {
            d.append(UIText.CommitMessageViewer_tags);
            d.append(": ");
            d.append(tagsString);
            d.append(LF);
        }
        try {
            Ref followingTag = this.getNextTag(false);
            if (followingTag != null) {
                d.append(UIText.CommitMessageViewer_follows);
                d.append(": ");
                p = new RevWalk(this.db).parseCommit((AnyObjectId)followingTag.getObjectId());
                this.addLink(d, this.formatTagRef(followingTag), styles, (RevCommit)p);
                d.append(LF);
            }
        }
        catch (IOException e) {
            Activator.logError(e.getMessage(), e);
        }
        try {
            Ref precedingTag = this.getNextTag(true);
            if (precedingTag != null) {
                d.append(UIText.CommitMessageViewer_precedes);
                d.append(": ");
                p = new RevWalk(this.db).parseCommit((AnyObjectId)precedingTag.getObjectId());
                this.addLink(d, this.formatTagRef(precedingTag), styles, (RevCommit)p);
                d.append(LF);
            }
        }
        catch (IOException e) {
            Activator.logError(e.getMessage(), e);
        }
        this.makeGrayText(d, styles);
        d.append(LF);
        String msg = this.commit.getFullMessage();
        p = Pattern.compile("\n([A-Z](?:[A-Za-z]+-)+by: [^\n]+)");
        if (this.fill && (spm = ((Pattern)p).matcher(msg)).find()) {
            String subMsg = msg.substring(0, spm.end());
            msg = String.valueOf(subMsg.replaceAll("([\\w.,; \t])\n(\\w)", "$1 $2")) + msg.substring(spm.end());
        }
        int h0 = d.length();
        d.append(msg);
        d.append(LF);
        this.addDiff(d, styles);
        Matcher matcher = ((Pattern)p).matcher(msg);
        while (matcher.find()) {
            styles.add(new StyleRange(h0 + matcher.start(), matcher.end() - matcher.start(), null, null, 2));
        }
        StyleRange[] arr = new StyleRange[styles.size()];
        styles.toArray(arr);
        Arrays.sort(arr, new Comparator<StyleRange>(){

            @Override
            public int compare(StyleRange o1, StyleRange o2) {
                return o1.start - o2.start;
            }
        });
        this.setDocument((IDocument)new Document(d.toString()));
        this.getTextWidget().setStyleRanges(arr);
    }

    private String getTagsString() {
        StringBuilder sb = new StringBuilder();
        Map tagsMap = this.db.getTags();
        for (String tagName : tagsMap.keySet()) {
            ObjectId peeledId = ((Ref)tagsMap.get(tagName)).getPeeledObjectId();
            if (peeledId == null || !peeledId.equals(this.commit)) continue;
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(tagName);
        }
        return sb.toString();
    }

    private String formatHeadRef(Ref ref) {
        String name = ref.getName();
        if (name.startsWith("refs/heads/")) {
            return name.substring("refs/heads/".length());
        }
        if (name.startsWith("refs/remotes/")) {
            return name.substring("refs/remotes/".length());
        }
        return name;
    }

    private String formatTagRef(Ref ref) {
        String name = ref.getName();
        if (name.startsWith("refs/tags/")) {
            return name.substring("refs/tags/".length());
        }
        return name;
    }

    private void makeGrayText(StringBuilder d, ArrayList<StyleRange> styles) {
        int p0 = 0;
        int i = 0;
        while (i < styles.size()) {
            StyleRange r = styles.get(i);
            if (p0 < r.start) {
                StyleRange nr = new StyleRange(p0, r.start - p0, this.sys_darkgray, null);
                styles.add(i, nr);
                p0 = r.start;
            } else {
                if (r.foreground == null) {
                    r.foreground = this.sys_darkgray;
                }
                p0 = r.start + r.length;
            }
            ++i;
        }
        if (d.length() - 1 > p0) {
            StyleRange nr = new StyleRange(p0, d.length() - p0, this.sys_darkgray, null);
            styles.add(nr);
        }
    }

    private void addLink(StringBuilder d, String linkLabel, ArrayList<StyleRange> styles, RevCommit to) {
        ObjectLink sr = new ObjectLink();
        sr.targetCommit = to;
        sr.foreground = this.sys_linkColor;
        sr.underline = true;
        sr.start = d.length();
        d.append(linkLabel);
        sr.length = d.length() - sr.start;
        styles.add(sr);
    }

    private void addLink(StringBuilder d, ArrayList<StyleRange> styles, RevCommit to) {
        this.addLink(d, to.getId().name(), styles, to);
    }

    private void addDiff(final StringBuilder d, final ArrayList<StyleRange> styles) {
        DiffFormatter diffFmt = new DiffFormatter(new BufferedOutputStream(new ByteArrayOutputStream(){

            public synchronized void write(byte[] b, int off, int len) {
                super.write(b, off, len);
                if (CommitMessageViewer.this.currentEncoding == null) {
                    d.append(this.toString());
                } else {
                    try {
                        d.append(this.toString(CommitMessageViewer.this.currentEncoding));
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        d.append(this.toString());
                    }
                }
                this.reset();
            }
        })){

            protected void writeHunkHeader(int aCur, int aEnd, int bCur, int bEnd) throws IOException {
                this.flush();
                int start = d.length();
                super.writeHunkHeader(aCur, aEnd, bCur, bEnd);
                this.flush();
                int end = d.length();
                styles.add(new StyleRange(start, end - start, CommitMessageViewer.this.sys_hunkHeaderColor, null));
            }

            protected void writeAddedLine(RawText b, int bCur) throws IOException {
                this.flush();
                int start = d.length();
                super.writeAddedLine(b, bCur);
                this.flush();
                int end = d.length();
                styles.add(new StyleRange(start, end - start, CommitMessageViewer.this.sys_linesAddedColor, null));
            }

            protected void writeRemovedLine(RawText b, int bCur) throws IOException {
                this.flush();
                int start = d.length();
                super.writeRemovedLine(b, bCur);
                this.flush();
                int end = d.length();
                styles.add(new StyleRange(start, end - start, CommitMessageViewer.this.sys_linesRemovedColor, null));
            }
        };
        if (this.commit.getParentCount() > 1) {
            return;
        }
        try {
            FileDiff[] diffs;
            FileDiff[] fileDiffArray = diffs = FileDiff.compute(this.walker, this.commit);
            int n = diffs.length;
            int n2 = 0;
            while (n2 < n) {
                FileDiff diff = fileDiffArray[n2];
                if (diff.getBlobs().length == 2) {
                    String path = diff.getPath();
                    this.currentEncoding = CompareUtils.getResourceEncoding(this.db, path);
                    d.append(this.formatPathLine(path)).append(LF);
                    diff.outputDiff(d, this.db, diffFmt, true);
                    diffFmt.flush();
                }
                ++n2;
            }
        }
        catch (IOException e) {
            Activator.handleError(NLS.bind((String)UIText.CommitMessageViewer_errorGettingFileDifference, (Object)this.commit.getId()), e, false);
        }
    }

    private String formatPathLine(String path) {
        int n = 80 - path.length() - 2;
        if (n < 0) {
            return path;
        }
        StringBuilder d = new StringBuilder();
        int i = 0;
        while (i < n / 2) {
            d.append("-");
            ++i;
        }
        d.append(SPACE).append(path).append(SPACE);
        while (i < n - 1) {
            d.append("-");
            ++i;
        }
        return d.toString();
    }

    private void setWrap(boolean wrap) {
        this.format();
        this.getTextWidget().setWordWrap(wrap);
    }

    private void setFill(boolean fill) {
        this.fill = fill;
        this.format();
    }

    public void setDb(Repository db) {
        this.db = db;
    }

    public void selectionChanged(SelectionChangedEvent event) {
        IStructuredSelection sel;
        Object obj;
        ISelection selection = event.getSelection();
        if (selection instanceof IStructuredSelection && (obj = (sel = (IStructuredSelection)selection).getFirstElement()) instanceof FileDiff) {
            String path = ((FileDiff)obj).getPath();
            this.findAndSelect(0, this.formatPathLine(path), true, true, false, false);
        }
    }

    private Ref getNextTag(boolean searchDescendant) throws IOException {
        RevWalk revWalk = new RevWalk(this.db);
        Map tagsMap = this.db.getTags();
        Ref tagRef = null;
        for (String tagName : tagsMap.keySet()) {
            RevCommit newTag;
            RevCommit current = revWalk.parseCommit(this.commit);
            Ref ref = (Ref)tagsMap.get(tagName);
            RevObject any = revWalk.peel(revWalk.parseAny((AnyObjectId)ref.getObjectId()));
            if (!(any instanceof RevCommit) || (newTag = (RevCommit)any).getId().equals(this.commit) || !this.isMergedInto(revWalk, newTag, current, searchDescendant)) continue;
            if (tagRef != null) {
                RevCommit oldTag = revWalk.parseCommit((AnyObjectId)tagRef.getObjectId());
                if (!this.isMergedInto(revWalk, oldTag, newTag, searchDescendant)) continue;
                tagRef = ref;
                continue;
            }
            tagRef = ref;
        }
        return tagRef;
    }

    private boolean isMergedInto(RevWalk rw, RevCommit base, RevCommit tip, boolean swap) throws IOException {
        return !swap ? rw.isMergedInto(base, tip) : rw.isMergedInto(tip, base);
    }

    private List<Ref> getBranches() {
        RevWalk revWalk = new RevWalk(this.db);
        ArrayList<Ref> result = new ArrayList<Ref>();
        try {
            HashMap refsMap = new HashMap();
            refsMap.putAll(this.db.getRefDatabase().getRefs("refs/heads/"));
            refsMap.putAll(this.db.getRefDatabase().getRefs("refs/remotes/"));
            for (String headName : refsMap.keySet()) {
                RevCommit headCommit = revWalk.parseCommit((AnyObjectId)((Ref)refsMap.get(headName)).getObjectId());
                RevCommit base = revWalk.parseCommit(this.commit);
                if (!revWalk.isMergedInto(base, headCommit)) continue;
                result.add((Ref)refsMap.get(headName));
            }
        }
        catch (IOException iOException) {}
        return result;
    }

    static class ObjectLink
    extends StyleRange {
        RevCommit targetCommit;

        ObjectLink() {
        }

        public boolean similarTo(StyleRange style) {
            if (!(style instanceof ObjectLink)) {
                return false;
            }
            if (this.targetCommit != ((ObjectLink)style).targetCommit) {
                return false;
            }
            return super.similarTo(style);
        }

        public boolean equals(Object object) {
            return super.equals(object) && this.targetCommit.equals((AnyObjectId)((ObjectLink)((Object)object)).targetCommit);
        }

        public int hashCode() {
            return super.hashCode() ^ this.targetCommit.hashCode();
        }
    }
}

