/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.history;

import java.io.IOException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.JobFamilies;
import org.eclipse.egit.ui.UIText;
import org.eclipse.egit.ui.internal.history.GitHistoryPage;
import org.eclipse.egit.ui.internal.history.SWTCommit;
import org.eclipse.egit.ui.internal.history.SWTCommitList;
import org.eclipse.egit.ui.internal.trace.GitTraceLocation;
import org.eclipse.osgi.util.NLS;

class GenerateHistoryJob
extends Job {
    private static final int BATCH_SIZE = 256;
    private final GitHistoryPage page;
    private final SWTCommitList allCommits;
    private int lastUpdateCnt;
    private long lastUpdateAt;
    private boolean trace;

    GenerateHistoryJob(GitHistoryPage ghp, SWTCommitList list) {
        super(NLS.bind((String)UIText.HistoryPage_refreshJob, (Object)Activator.getDefault().getRepositoryUtil().getRepositoryName(ghp.getInputInternal().getRepository())));
        this.page = ghp;
        this.allCommits = list;
        this.trace = GitTraceLocation.HISTORYVIEW.isActive();
    }

    protected IStatus run(IProgressMonitor monitor) {
        IStatus status = Status.OK_STATUS;
        try {
            if (this.trace) {
                GitTraceLocation.getTrace().traceEntry(GitTraceLocation.HISTORYVIEW.getLocation());
            }
            this.page.setErrorMessage(NLS.bind((String)UIText.GenerateHistoryJob_BuildingListMessage, (Object)this.page.getName()));
            try {
                while (true) {
                    int oldsz = this.allCommits.size();
                    if (this.trace) {
                        GitTraceLocation.getTrace().trace(GitTraceLocation.HISTORYVIEW.getLocation(), "Filling commit list");
                    }
                    this.allCommits.fillTo(oldsz + 256 - 1);
                    if (!monitor.isCanceled() && oldsz != this.allCommits.size()) {
                        long now = System.currentTimeMillis();
                        if (now - this.lastUpdateAt < 2000L && this.lastUpdateCnt > 0) continue;
                        this.updateUI();
                        this.lastUpdateAt = now;
                        continue;
                    }
                    break;
                }
            }
            catch (IOException e) {
                status = new Status(4, Activator.getPluginId(), UIText.GenerateHistoryJob_errorComputingHistory, (Throwable)e);
            }
            if (monitor.isCanceled()) {
                this.page.setErrorMessage(NLS.bind((String)UIText.GenerateHistoryJob_CancelMessage, (Object)this.page.getName()));
                IStatus iStatus = Status.CANCEL_STATUS;
                return iStatus;
            }
            this.updateUI();
        }
        finally {
            monitor.done();
            if (this.trace) {
                GitTraceLocation.getTrace().traceExit(GitTraceLocation.HISTORYVIEW.getLocation());
            }
        }
        return status;
    }

    void updateUI() {
        if (this.trace) {
            GitTraceLocation.getTrace().traceEntry(GitTraceLocation.HISTORYVIEW.getLocation());
        }
        try {
            if (this.allCommits.size() == this.lastUpdateCnt) {
                return;
            }
            SWTCommit[] asArray = new SWTCommit[this.allCommits.size()];
            this.allCommits.toArray((Object[])asArray);
            this.page.showCommitList(this, this.allCommits, asArray);
            this.lastUpdateCnt = this.allCommits.size();
        }
        finally {
            if (this.trace) {
                GitTraceLocation.getTrace().traceExit(GitTraceLocation.HISTORYVIEW.getLocation());
            }
        }
    }

    public boolean belongsTo(Object family) {
        if (family.equals(JobFamilies.GENERATE_HISTORY)) {
            return true;
        }
        return super.belongsTo(family);
    }
}

