/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.history;

import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.Locale;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.UIIcons;
import org.eclipse.egit.ui.UIText;
import org.eclipse.egit.ui.internal.CompareUtils;
import org.eclipse.egit.ui.internal.history.FileDiff;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.jgit.diff.DiffFormatter;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPart;

public class GitCreatePatchWizard
extends Wizard {
    private RevCommit commit;
    private TreeWalk walker;
    private Repository db;
    private LocationPage locationPage;
    private OptionsPage optionsPage;
    private String currentEncoding = null;
    private static final int INITIAL_WIDTH = 300;
    private static final int INITIAL_HEIGHT = 150;

    public static void run(IWorkbenchPart part, RevCommit commit, TreeWalk walker, Repository db) {
        String title = UIText.GitCreatePatchWizard_CreatePatchTitle;
        GitCreatePatchWizard wizard = new GitCreatePatchWizard(commit, walker, db);
        wizard.setWindowTitle(title);
        WizardDialog dialog = new WizardDialog(part.getSite().getShell(), (IWizard)wizard);
        dialog.setMinimumPageSize(300, 150);
        dialog.setHelpAvailable(false);
        dialog.open();
    }

    public GitCreatePatchWizard(RevCommit commit, TreeWalk walker, Repository db) {
        this.commit = commit;
        this.walker = walker;
        this.db = db;
    }

    public void addPages() {
        String pageTitle = UIText.GitCreatePatchWizard_SelectLocationTitle;
        String pageDescription = UIText.GitCreatePatchWizard_SelectLocationDescription;
        this.locationPage = new LocationPage(pageTitle, pageTitle, UIIcons.WIZBAN_CREATE_PATCH);
        this.locationPage.setDescription(pageDescription);
        this.addPage((IWizardPage)this.locationPage);
        pageTitle = UIText.GitCreatePatchWizard_SelectOptionsTitle;
        pageDescription = UIText.GitCreatePatchWizard_SelectOptionsDescription;
        this.optionsPage = new OptionsPage(pageTitle, pageTitle, UIIcons.WIZBAN_CREATE_PATCH);
        this.optionsPage.setDescription(pageDescription);
        this.addPage((IWizardPage)this.optionsPage);
    }

    public boolean performFinish() {
        final boolean isGit = this.optionsPage.gitFormat.getSelection();
        final boolean isFile = this.locationPage.fsRadio.getSelection();
        final String fileName = this.locationPage.fsPathText.getText();
        try {
            this.getContainer().run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) {
                    block8: {
                        final StringBuilder sb = new StringBuilder();
                        DiffFormatter diffFmt = new DiffFormatter((OutputStream)new BufferedOutputStream(new ByteArrayOutputStream(){

                            public synchronized void write(byte[] b, int off, int len) {
                                super.write(b, off, len);
                                if (GitCreatePatchWizard.this.currentEncoding == null) {
                                    sb.append(this.toString());
                                } else {
                                    try {
                                        sb.append(this.toString(GitCreatePatchWizard.this.currentEncoding));
                                    }
                                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                                        sb.append(this.toString());
                                    }
                                }
                                this.reset();
                            }
                        }));
                        if (isGit) {
                            GitCreatePatchWizard.this.writeGitPatchHeader(sb);
                        }
                        try {
                            FileDiff[] diffs;
                            FileDiff[] fileDiffArray = diffs = FileDiff.compute(GitCreatePatchWizard.this.walker, GitCreatePatchWizard.this.commit);
                            int n = diffs.length;
                            int n2 = 0;
                            while (n2 < n) {
                                FileDiff diff = fileDiffArray[n2];
                                GitCreatePatchWizard.this.currentEncoding = CompareUtils.getResourceEncoding(GitCreatePatchWizard.this.db, diff.getPath());
                                diff.outputDiff(sb, GitCreatePatchWizard.this.db, diffFmt, isGit);
                                diffFmt.flush();
                                ++n2;
                            }
                            if (isFile) {
                                BufferedWriter output = new BufferedWriter(new FileWriter(fileName));
                                try {
                                    output.write(sb.toString());
                                    break block8;
                                }
                                finally {
                                    ((Writer)output).close();
                                }
                            }
                            GitCreatePatchWizard.this.copyToClipboard(sb.toString());
                        }
                        catch (IOException e) {
                            Activator.logError("Patch file could not be written", e);
                        }
                    }
                }
            });
        }
        catch (InvocationTargetException e) {
            ((WizardPage)this.getContainer().getCurrentPage()).setErrorMessage(e.getMessage() == null ? e.getMessage() : UIText.GitCreatePatchWizard_InternalError);
            Activator.logError("Patch file was not written", e);
            return false;
        }
        catch (InterruptedException e) {
            Activator.logError("Patch file was not written", e);
            return false;
        }
        return true;
    }

    private void writeGitPatchHeader(StringBuilder sb) {
        SimpleDateFormat dtfmt = new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss Z", Locale.US);
        dtfmt.setTimeZone(this.commit.getAuthorIdent().getTimeZone());
        sb.append("From").append(" ").append(this.commit.getId().getName()).append(" ").append(dtfmt.format(System.currentTimeMillis())).append("\n");
        sb.append("From").append(": ").append(this.commit.getAuthorIdent().getName()).append(" <").append(this.commit.getAuthorIdent().getEmailAddress()).append(">\n");
        sb.append("Date").append(": ").append(dtfmt.format(this.commit.getAuthorIdent().getWhen())).append("\n");
        sb.append("Subject").append(": [PATCH] ").append(this.commit.getShortMessage());
        String message = this.commit.getFullMessage().substring(this.commit.getShortMessage().length());
        sb.append(message).append("\n\n");
    }

    private void copyToClipboard(final String content) {
        this.getShell().getDisplay().syncExec(new Runnable(){

            public void run() {
                TextTransfer plainTextTransfer = TextTransfer.getInstance();
                Clipboard clipboard = new Clipboard(GitCreatePatchWizard.this.getShell().getDisplay());
                clipboard.setContents((Object[])new String[]{content}, new Transfer[]{plainTextTransfer});
                clipboard.dispose();
            }
        });
    }

    public class LocationPage
    extends WizardPage {
        private Button cpRadio;
        private Button fsRadio;
        private Text fsPathText;
        private Button fsBrowseButton;
        private boolean pageValid;

        protected LocationPage(String pageName, String title, ImageDescriptor titleImage) {
            super(pageName, title, titleImage);
        }

        public void createControl(Composite parent) {
            Composite composite = new Composite(parent, 0);
            GridLayout gridLayout = new GridLayout();
            gridLayout.numColumns = 3;
            composite.setLayout((Layout)gridLayout);
            composite.setLayoutData((Object)new GridData(768));
            this.initializeDialogUnits((Control)composite);
            GridData gd = new GridData(32);
            gd.horizontalSpan = 3;
            this.cpRadio = new Button(composite, 16);
            this.cpRadio.setText(UIText.GitCreatePatchWizard_Clipboard);
            this.cpRadio.setLayoutData((Object)gd);
            this.cpRadio.setSelection(true);
            this.fsRadio = new Button(composite, 16);
            this.fsRadio.setText(UIText.GitCreatePatchWizard_File);
            this.fsRadio.setSelection(false);
            this.fsPathText = new Text(composite, 2048);
            gd = new GridData(768);
            this.fsPathText.setLayoutData((Object)gd);
            this.fsPathText.setText(this.createFileName());
            this.fsPathText.setEnabled(false);
            this.fsBrowseButton = new Button(composite, 8);
            this.fsBrowseButton.setText(UIText.GitCreatePatchWizard_Browse);
            GridData data = new GridData(256);
            int widthHint = this.convertHorizontalDLUsToPixels(61);
            Point minSize = this.fsBrowseButton.computeSize(-1, -1, true);
            data.widthHint = Math.max(widthHint, minSize.x);
            this.fsBrowseButton.setLayoutData((Object)data);
            this.fsBrowseButton.setEnabled(false);
            this.cpRadio.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    LocationPage.this.fsPathText.setEnabled(false);
                    LocationPage.this.fsBrowseButton.setEnabled(false);
                    LocationPage.this.validatePage();
                }
            });
            this.fsRadio.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    LocationPage.this.fsPathText.setEnabled(true);
                    LocationPage.this.fsBrowseButton.setEnabled(true);
                    LocationPage.this.fsPathText.setFocus();
                    LocationPage.this.validatePage();
                }
            });
            this.fsPathText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    LocationPage.this.validatePage();
                }
            });
            this.fsBrowseButton.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    FileDialog dialog = new FileDialog(LocationPage.this.getShell(), 40960);
                    if (LocationPage.this.pageValid) {
                        File file = new File(LocationPage.this.fsPathText.getText());
                        dialog.setFilterPath(file.getParent());
                        dialog.setFileName(file.getName());
                    } else {
                        dialog.setFileName("");
                    }
                    dialog.setText("");
                    String path = dialog.open();
                    if (path != null) {
                        LocationPage.this.fsPathText.setText(new Path(path).toOSString());
                    }
                    LocationPage.this.validatePage();
                }
            });
            Dialog.applyDialogFont((Control)composite);
            this.setControl((Control)composite);
        }

        private String createFileName() {
            String name = GitCreatePatchWizard.this.commit.getShortMessage();
            name = name.trim();
            try {
                name = URLEncoder.encode(name, "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {}
            if (name.length() > 80) {
                name = name.substring(0, 80);
            }
            while (name.endsWith(".")) {
                name = name.substring(0, name.length() - 1);
            }
            name = name.concat(".patch");
            String defaultPath = GitCreatePatchWizard.this.db.getWorkTree().getAbsolutePath();
            return new File(defaultPath, name).getPath();
        }

        protected boolean validatePage() {
            if (this.fsRadio.getSelection()) {
                this.pageValid = this.validateFilesystemLocation();
            } else if (this.cpRadio.getSelection()) {
                this.pageValid = true;
            }
            if (this.pageValid) {
                this.setMessage(null);
                this.setErrorMessage(null);
            }
            this.setPageComplete(this.pageValid);
            return this.pageValid;
        }

        private boolean validateFilesystemLocation() {
            String pathString = this.fsPathText.getText().trim();
            if (pathString.length() == 0 || !new Path("").isValidPath(pathString)) {
                this.setErrorMessage(UIText.GitCreatePatchWizard_FilesystemError);
                return false;
            }
            File file = new File(pathString);
            if (!file.isAbsolute()) {
                this.setErrorMessage(UIText.GitCreatePatchWizard_FilesystemInvalidError);
                return false;
            }
            if (file.isDirectory()) {
                this.setErrorMessage(UIText.GitCreatePatchWizard_FilesystemDirectoryError);
                return false;
            }
            if (pathString.endsWith("/") || pathString.endsWith("\\")) {
                this.setErrorMessage(UIText.GitCreatePatchWizard_FilesystemDirectoryNotExistsError);
                return false;
            }
            File parent = file.getParentFile();
            if (!parent.exists() || !parent.isDirectory()) {
                this.setErrorMessage(UIText.GitCreatePatchWizard_FilesystemDirectoryNotExistsError);
                return false;
            }
            return true;
        }
    }

    public static class OptionsPage
    extends WizardPage {
        private Button gitFormat;

        protected OptionsPage(String pageName, String title, ImageDescriptor titleImage) {
            super(pageName, title, titleImage);
        }

        public void createControl(Composite parent) {
            Composite composite = new Composite(parent, 0);
            GridLayout gridLayout = new GridLayout();
            gridLayout.numColumns = 3;
            composite.setLayout((Layout)gridLayout);
            composite.setLayoutData((Object)new GridData(768));
            GridData gd = new GridData(32);
            gd.horizontalSpan = 3;
            this.gitFormat = new Button(composite, 32);
            this.gitFormat.setText(UIText.GitCreatePatchWizard_GitFormat);
            this.gitFormat.setLayoutData((Object)gd);
            Dialog.applyDialogFont((Control)composite);
            this.setControl((Control)composite);
        }
    }
}

