/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.history;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.egit.core.project.RepositoryMapping;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.UIIcons;
import org.eclipse.egit.ui.UIPreferences;
import org.eclipse.egit.ui.UIText;
import org.eclipse.egit.ui.UIUtils;
import org.eclipse.egit.ui.internal.CompareUtils;
import org.eclipse.egit.ui.internal.history.CommitFileDiffViewer;
import org.eclipse.egit.ui.internal.history.CommitGraphTable;
import org.eclipse.egit.ui.internal.history.CommitMessageViewer;
import org.eclipse.egit.ui.internal.history.CommitNavigationListener;
import org.eclipse.egit.ui.internal.history.FindToolbar;
import org.eclipse.egit.ui.internal.history.GenerateHistoryJob;
import org.eclipse.egit.ui.internal.history.HistoryPageInput;
import org.eclipse.egit.ui.internal.history.SWTCommit;
import org.eclipse.egit.ui.internal.history.SWTCommitList;
import org.eclipse.egit.ui.internal.history.SWTWalk;
import org.eclipse.egit.ui.internal.repository.tree.FileNode;
import org.eclipse.egit.ui.internal.repository.tree.FolderNode;
import org.eclipse.egit.ui.internal.repository.tree.RepositoryTreeNode;
import org.eclipse.egit.ui.internal.trace.GitTraceLocation;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.preference.IPersistentPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.events.ListenerHandle;
import org.eclipse.jgit.events.RefsChangedEvent;
import org.eclipse.jgit.events.RefsChangedListener;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revplot.PlotCommit;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevFlag;
import org.eclipse.jgit.revwalk.RevSort;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.treewalk.filter.AndTreeFilter;
import org.eclipse.jgit.treewalk.filter.PathFilterGroup;
import org.eclipse.jgit.treewalk.filter.TreeFilter;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MenuDetectEvent;
import org.eclipse.swt.events.MenuDetectListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.team.ui.history.HistoryPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.progress.IWorkbenchSiteProgressService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GitHistoryPage
extends HistoryPage
implements RefsChangedListener {
    private static final String POPUP_ID = "org.eclipse.egit.ui.historyPageContributions";
    private static final String DESCRIPTION_PATTERN = "{0} - {1}";
    private static final String NAME_PATTERN = "{0}: {1} [{2}]";
    private static final String PREF_SHOWALLFILTER = "org.eclipse.egit.ui.githistorypage.showallfilter";
    private ShowFilter showAllFilter = ShowFilter.SHOWALLRESOURCE;
    private GitHistoryPageActions actions;
    private StyledText errorText;
    private final IPersistentPreferenceStore store = (IPersistentPreferenceStore)Activator.getDefault().getPreferenceStore();
    private ListenerHandle myRefsChangedHandle;
    private HistoryPageInput input;
    private String name;
    private boolean trace = GitTraceLocation.HISTORYVIEW.isActive();
    private Composite topControl;
    private Composite historyControl;
    private SashForm graphDetailSplit;
    private SashForm revInfoSplit;
    private CommitGraphTable graph;
    private CommitMessageViewer commentViewer;
    private CommitFileDiffViewer fileViewer;
    private FindToolbar findToolbar;
    private final MenuManager popupMgr = new MenuManager(null, "org.eclipse.egit.ui.historyPageContributions");
    private GenerateHistoryJob job;
    private SWTWalk currentWalk;
    private AnyObjectId currentHeadId;
    private RevFlag highlightFlag;
    private List<String> pathFilters;
    private Runnable refschangedRunnable;

    public static boolean canShowHistoryFor(Object object) {
        if (object instanceof HistoryPageInput) {
            return true;
        }
        if (object instanceof IResource) {
            return GitHistoryPage.typeOk((IResource)object);
        }
        if (object instanceof RepositoryTreeNode) {
            return true;
        }
        if (object instanceof IAdaptable) {
            IResource resource = (IResource)((IAdaptable)object).getAdapter(IResource.class);
            return resource == null ? false : GitHistoryPage.typeOk(resource);
        }
        return false;
    }

    private static boolean typeOk(IResource object) {
        switch (object.getType()) {
            case 1: 
            case 2: 
            case 4: {
                return true;
            }
        }
        return false;
    }

    public GitHistoryPage() {
        this.trace = GitTraceLocation.HISTORYVIEW.isActive();
        if (this.trace) {
            GitTraceLocation.getTrace().traceEntry(GitTraceLocation.HISTORYVIEW.getLocation());
        }
    }

    public void createControl(Composite parent) {
        this.trace = GitTraceLocation.HISTORYVIEW.isActive();
        if (this.trace) {
            GitTraceLocation.getTrace().traceEntry(GitTraceLocation.HISTORYVIEW.getLocation());
        }
        this.historyControl = this.createMainPanel(parent);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.historyControl);
        this.graphDetailSplit = new SashForm(this.historyControl, 512);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.graphDetailSplit);
        this.graph = new CommitGraphTable((Composite)this.graphDetailSplit, this.getSite(), this.popupMgr);
        this.revInfoSplit = new SashForm((Composite)this.graphDetailSplit, 256);
        this.commentViewer = new CommitMessageViewer((Composite)this.revInfoSplit, this.getSite());
        this.fileViewer = new CommitFileDiffViewer((Composite)this.revInfoSplit, this.getSite());
        this.findToolbar = new FindToolbar(this.historyControl);
        this.layoutSashForm(this.graphDetailSplit, "resourcehistory_graph_split");
        this.layoutSashForm(this.revInfoSplit, "resourcehistory_rev_split");
        this.attachCommitSelectionChanged();
        this.initActions();
        this.getSite().registerContextMenu(POPUP_ID, this.popupMgr, (ISelectionProvider)this.graph.getTableView());
        this.layout();
        this.myRefsChangedHandle = Repository.getGlobalListenerList().addRefsChangedListener((RefsChangedListener)this);
        if (this.trace) {
            GitTraceLocation.getTrace().traceExit(GitTraceLocation.HISTORYVIEW.getLocation());
        }
    }

    private void layoutSashForm(final SashForm sf, final String key) {
        sf.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                int[] w = sf.getWeights();
                GitHistoryPage.this.store.putValue(key, UIPreferences.intArrayToString(w));
                if (GitHistoryPage.this.store.needsSaving()) {
                    try {
                        GitHistoryPage.this.store.save();
                    }
                    catch (IOException e1) {
                        Activator.handleError(e1.getMessage(), e1, false);
                    }
                }
            }
        });
        sf.setWeights(UIPreferences.stringToIntArray(this.store.getString(key), 2));
    }

    private Composite createMainPanel(Composite parent) {
        this.topControl = new Composite(parent, 0);
        StackLayout layout = new StackLayout();
        this.topControl.setLayout((Layout)layout);
        Composite c = new Composite(this.topControl, 0);
        layout.topControl = c;
        this.errorText = new StyledText(this.topControl, 0);
        this.errorText.setFont(UIUtils.getFont("org.eclipse.egit.ui.CommitMessageFont"));
        this.errorText.setText(UIText.CommitFileDiffViewer_SelectOneCommitMessage);
        GridLayout parentLayout = new GridLayout();
        parentLayout.marginHeight = 0;
        parentLayout.marginWidth = 0;
        parentLayout.verticalSpacing = 0;
        c.setLayout((Layout)parentLayout);
        return c;
    }

    private void layout() {
        boolean showComment = this.store.getBoolean("resourcehistory_show_rev_comment");
        boolean showFiles = this.store.getBoolean("resourcehistory_show_rev_detail");
        boolean showFindToolbar = this.store.getBoolean("resourcehistory_show_findtoolbar");
        if (showComment && showFiles) {
            this.graphDetailSplit.setMaximizedControl(null);
            this.revInfoSplit.setMaximizedControl(null);
        } else if (showComment && !showFiles) {
            this.graphDetailSplit.setMaximizedControl(null);
            this.revInfoSplit.setMaximizedControl(this.commentViewer.getControl());
        } else if (!showComment && showFiles) {
            this.graphDetailSplit.setMaximizedControl(null);
            this.revInfoSplit.setMaximizedControl((Control)this.fileViewer.getControl().getParent());
        } else if (!showComment && !showFiles) {
            this.graphDetailSplit.setMaximizedControl(this.graph.getControl());
        }
        if (showFindToolbar) {
            ((GridData)this.findToolbar.getLayoutData()).heightHint = -1;
        } else {
            ((GridData)this.findToolbar.getLayoutData()).heightHint = 0;
            this.findToolbar.clear();
        }
        this.historyControl.layout();
    }

    private void attachCommitSelectionChanged() {
        this.graph.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ISelection s = event.getSelection();
                if (s.isEmpty() || !(s instanceof IStructuredSelection)) {
                    GitHistoryPage.this.commentViewer.setInput(null);
                    GitHistoryPage.this.fileViewer.setInput(null);
                    return;
                }
                IStructuredSelection sel = (IStructuredSelection)s;
                if (sel.size() > 1) {
                    GitHistoryPage.this.commentViewer.setInput(null);
                    GitHistoryPage.this.fileViewer.setInput(null);
                    return;
                }
                PlotCommit c = (PlotCommit)sel.getFirstElement();
                GitHistoryPage.this.commentViewer.setInput(c);
                GitHistoryPage.this.fileViewer.setInput(c);
            }
        });
        this.commentViewer.addCommitNavigationListener(new CommitNavigationListener(){

            public void showCommit(RevCommit c) {
                GitHistoryPage.this.graph.selectCommit(c);
            }
        });
        this.findToolbar.addSelectionListener(new Listener(){

            public void handleEvent(Event event) {
                GitHistoryPage.this.graph.selectCommit((RevCommit)event.data);
            }
        });
    }

    private void initActions() {
        try {
            this.showAllFilter = ShowFilter.valueOf(Activator.getDefault().getPreferenceStore().getString(PREF_SHOWALLFILTER));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.showAllFilter = ShowFilter.SHOWALLRESOURCE;
        }
        this.actions = new GitHistoryPageActions(this);
        this.setupToolBar();
        this.setupViewMenu();
        this.graph.getControl().addMenuDetectListener(new MenuDetectListener(){

            public void menuDetected(MenuDetectEvent e) {
                GitHistoryPage.this.popupMgr.add((IAction)((GitHistoryPage)GitHistoryPage.this).actions.showFilesAction);
                GitHistoryPage.this.popupMgr.add((IAction)((GitHistoryPage)GitHistoryPage.this).actions.showCommentAction);
            }
        });
    }

    private void setupToolBar() {
        IToolBarManager mgr = this.getSite().getActionBars().getToolBarManager();
        mgr.add(this.actions.findAction);
        mgr.add((IContributionItem)new Separator());
        mgr.add((IAction)this.actions.showAllRepoVersionsAction);
        mgr.add((IAction)this.actions.showAllProjectVersionsAction);
        mgr.add((IAction)this.actions.showAllFolderVersionsAction);
        mgr.add((IAction)this.actions.showAllResourceVersionsAction);
        mgr.add((IContributionItem)new Separator());
        mgr.add((IAction)this.actions.compareModeAction);
        mgr.add((IAction)this.actions.showAllBranchesAction);
    }

    private void setupViewMenu() {
        IMenuManager viewMenuMgr = this.getSite().getActionBars().getMenuManager();
        viewMenuMgr.add(this.actions.refreshAction);
        viewMenuMgr.add((IContributionItem)new Separator());
        MenuManager showSubMenuMgr = new MenuManager(UIText.GitHistoryPage_ShowSubMenuLabel);
        viewMenuMgr.add((IContributionItem)showSubMenuMgr);
        showSubMenuMgr.add((IAction)this.actions.showAllBranchesAction);
        showSubMenuMgr.add(this.actions.findAction);
        showSubMenuMgr.add((IAction)this.actions.showFilesAction);
        showSubMenuMgr.add((IAction)this.actions.showCommentAction);
        MenuManager filterSubMenuMgr = new MenuManager(UIText.GitHistoryPage_FilterSubMenuLabel);
        viewMenuMgr.add((IContributionItem)filterSubMenuMgr);
        filterSubMenuMgr.add((IAction)this.actions.showAllRepoVersionsAction);
        filterSubMenuMgr.add((IAction)this.actions.showAllProjectVersionsAction);
        filterSubMenuMgr.add((IAction)this.actions.showAllFolderVersionsAction);
        filterSubMenuMgr.add((IAction)this.actions.showAllResourceVersionsAction);
        viewMenuMgr.add((IContributionItem)new Separator());
        viewMenuMgr.add((IAction)this.actions.compareModeAction);
        viewMenuMgr.add((IAction)this.actions.reuseCompareEditorAction);
        viewMenuMgr.add((IContributionItem)new Separator());
        viewMenuMgr.add((IAction)this.actions.wrapCommentAction);
        viewMenuMgr.add((IAction)this.actions.fillCommentAction);
    }

    public void dispose() {
        this.trace = GitTraceLocation.HISTORYVIEW.isActive();
        if (this.trace) {
            GitTraceLocation.getTrace().traceEntry(GitTraceLocation.HISTORYVIEW.getLocation());
        }
        if (this.myRefsChangedHandle != null) {
            this.myRefsChangedHandle.remove();
            this.myRefsChangedHandle = null;
        }
        for (ActionFactory.IWorkbenchAction action : this.actions.actionsToDispose) {
            action.dispose();
        }
        this.actions.actionsToDispose.clear();
        this.cancelRefreshJob();
        if (this.popupMgr != null) {
            IContributionItem i;
            IContributionItem[] iContributionItemArray = this.popupMgr.getItems();
            int n = iContributionItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                i = iContributionItemArray[n2];
                if (i instanceof ActionFactory.IWorkbenchAction) {
                    ((ActionFactory.IWorkbenchAction)i).dispose();
                }
                ++n2;
            }
            iContributionItemArray = this.getSite().getActionBars().getMenuManager().getItems();
            n = iContributionItemArray.length;
            n2 = 0;
            while (n2 < n) {
                i = iContributionItemArray[n2];
                if (i instanceof ActionFactory.IWorkbenchAction) {
                    ((ActionFactory.IWorkbenchAction)i).dispose();
                }
                ++n2;
            }
        }
        super.dispose();
    }

    public void setFocus() {
        this.graph.getControl().setFocus();
    }

    public Control getControl() {
        return this.topControl;
    }

    public void refresh() {
        this.input = null;
        this.inputSet();
    }

    public void setCompareMode(boolean compareMode) {
        this.store.setValue("resourcehistory_compare_mode", compareMode);
    }

    public ISelectionProvider getSelectionProvider() {
        return this.graph.getTableView();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onRefsChanged(RefsChangedEvent e) {
        if (this.input == null || e.getRepository() != this.input.getRepository()) {
            return;
        }
        if (this.getControl().isDisposed()) {
            return;
        }
        GitHistoryPage gitHistoryPage = this;
        synchronized (gitHistoryPage) {
            if (this.refschangedRunnable == null) {
                this.refschangedRunnable = new Runnable(){

                    public void run() {
                        if (!GitHistoryPage.this.getControl().isDisposed()) {
                            if (GitTraceLocation.HISTORYVIEW.isActive()) {
                                GitTraceLocation.getTrace().trace(GitTraceLocation.HISTORYVIEW.getLocation(), "Executing async repository changed event");
                            }
                            GitHistoryPage.this.refschangedRunnable = null;
                            GitHistoryPage.this.initAndStartRevWalk(true);
                        }
                    }
                };
                this.getControl().getDisplay().asyncExec(this.refschangedRunnable);
            }
        }
    }

    public boolean setInput(Object object) {
        try {
            this.trace = GitTraceLocation.HISTORYVIEW.isActive();
            if (this.trace) {
                GitTraceLocation.getTrace().traceEntry(GitTraceLocation.HISTORYVIEW.getLocation(), object);
            }
            if (object == this.getInput()) {
                return true;
            }
            this.input = null;
            boolean bl = super.setInput(object);
            return bl;
        }
        finally {
            if (this.trace) {
                GitTraceLocation.getTrace().traceExit(GitTraceLocation.HISTORYVIEW.getLocation());
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean inputSet() {
        try {
            IResource resource;
            if (this.trace) {
                GitTraceLocation.getTrace().traceEntry(GitTraceLocation.HISTORYVIEW.getLocation());
            }
            if (this.input != null) {
                return true;
            }
            this.cancelRefreshJob();
            this.setErrorMessage(null);
            Object o = super.getInput();
            if (o == null) {
                this.setErrorMessage(UIText.GitHistoryPage_NoInputMessage);
                return false;
            }
            if (o instanceof IResource) {
                RepositoryMapping mapping = RepositoryMapping.getMapping((IResource)((IResource)o));
                if (mapping != null) {
                    Repository repo = mapping.getRepository();
                    this.input = new HistoryPageInput(repo, new IResource[]{(IResource)o});
                }
            } else if (o instanceof RepositoryTreeNode) {
                RepositoryTreeNode repoNode = (RepositoryTreeNode)o;
                switch (repoNode.getType()) {
                    case FILE: {
                        File file = (File)((FileNode)repoNode).getObject();
                        this.input = new HistoryPageInput(repoNode.getRepository(), new File[]{file});
                        break;
                    }
                    case FOLDER: {
                        File folder = (File)((FolderNode)repoNode).getObject();
                        this.input = new HistoryPageInput(repoNode.getRepository(), new File[]{folder});
                        break;
                    }
                    default: {
                        this.input = new HistoryPageInput(repoNode.getRepository());
                        break;
                    }
                }
            } else if (o instanceof HistoryPageInput) {
                this.input = (HistoryPageInput)o;
            } else if (o instanceof IAdaptable && (resource = (IResource)((IAdaptable)o).getAdapter(IResource.class)) != null) {
                RepositoryMapping mapping = RepositoryMapping.getMapping((IResource)resource);
                Repository repo = mapping.getRepository();
                this.input = new HistoryPageInput(repo, new IResource[]{resource});
            }
            if (this.input == null) {
                this.name = "";
                this.setErrorMessage(UIText.GitHistoryPage_NoInputMessage);
                return false;
            }
            IResource[] inResources = this.input.getItems();
            File[] inFiles = this.input.getFileList();
            if (inResources != null && inResources.length == 0) {
                this.name = "";
                this.setErrorMessage(UIText.GitHistoryPage_NoInputMessage);
                return false;
            }
            this.name = GitHistoryPage.calculateName(this.input);
            boolean filtersActive = inResources != null || inFiles != null;
            this.actions.showAllRepoVersionsAction.setEnabled(filtersActive);
            this.actions.showAllProjectVersionsAction.setEnabled(filtersActive);
            this.actions.showAllFolderVersionsAction.setEnabled(inResources != null);
            this.actions.showAllResourceVersionsAction.setEnabled(filtersActive);
            try {
                this.initAndStartRevWalk(true);
                return true;
            }
            catch (IllegalStateException e) {
                Activator.handleError(e.getMessage(), e, true);
                if (!this.trace) return false;
                GitTraceLocation.getTrace().traceExit(GitTraceLocation.HISTORYVIEW.getLocation());
                return false;
            }
        }
        finally {
            if (this.trace) {
                GitTraceLocation.getTrace().traceExit(GitTraceLocation.HISTORYVIEW.getLocation());
            }
        }
    }

    private static String calculateName(HistoryPageInput in) {
        int n;
        int n2;
        Object[] objectArray;
        String repositoryName = Activator.getDefault().getRepositoryUtil().getRepositoryName(in.getRepository());
        if (in.getItems() == null && in.getFileList() == null) {
            return NLS.bind((String)UIText.GitHistoryPage_RepositoryNamePattern, (Object)repositoryName);
        }
        if (in.getItems() != null && in.getItems().length == 1) {
            String type;
            IResource resource = in.getItems()[0];
            switch (resource.getType()) {
                case 1: {
                    type = UIText.GitHistoryPage_FileType;
                    break;
                }
                case 4: {
                    type = UIText.GitHistoryPage_ProjectType;
                    break;
                }
                default: {
                    type = UIText.GitHistoryPage_FolderType;
                }
            }
            String path = resource.getFullPath().makeRelative().toString();
            if (resource.getType() == 2) {
                path = String.valueOf(path) + '/';
            }
            return NLS.bind((String)NAME_PATTERN, (Object[])new Object[]{type, path, repositoryName});
        }
        if (in.getFileList() != null && in.getFileList().length == 1) {
            String path;
            String type;
            File resource = in.getFileList()[0];
            if (resource.isDirectory()) {
                type = UIText.GitHistoryPage_FolderType;
                path = String.valueOf(resource.getPath()) + '/';
            } else {
                type = UIText.GitHistoryPage_FileType;
                path = resource.getPath();
            }
            return NLS.bind((String)NAME_PATTERN, (Object[])new Object[]{type, path, repositoryName});
        }
        int count = 0;
        StringBuilder b = new StringBuilder();
        if (in.getItems() != null) {
            count = in.getItems().length;
            objectArray = in.getItems();
            n2 = objectArray.length;
            n = 0;
            while (n < n2) {
                IResource res = objectArray[n];
                b.append(res.getFullPath());
                if (res.getType() == 2) {
                    b.append('/');
                }
                if (b.length() > 100) {
                    b.append("...  ");
                    break;
                }
                b.append(", ");
                ++n;
            }
        }
        if (in.getFileList() != null) {
            count = in.getFileList().length;
            objectArray = in.getFileList();
            n2 = objectArray.length;
            n = 0;
            while (n < n2) {
                IResource file = objectArray[n];
                b.append(GitHistoryPage.getRepoRelativePath(in.getRepository(), (File)file));
                if (file.isDirectory()) {
                    b.append('/');
                }
                if (b.length() > 100) {
                    b.append("...  ");
                    break;
                }
                b.append(", ");
                ++n;
            }
        }
        if (b.length() > 2) {
            b.setLength(b.length() - 2);
        }
        String multiResourcePrefix = NLS.bind((String)UIText.GitHistoryPage_MultiResourcesType, (Object)count);
        return NLS.bind((String)NAME_PATTERN, (Object[])new Object[]{multiResourcePrefix, b.toString(), repositoryName});
    }

    private static String getRepoRelativePath(Repository repo, File file) {
        Path workdirPath = new Path(repo.getWorkTree().getPath());
        IPath filePath = new Path(file.getPath()).setDevice(null);
        return filePath.removeFirstSegments(workdirPath.segmentCount()).toString();
    }

    public void setErrorMessage(final String message) {
        if (this.trace) {
            GitTraceLocation.getTrace().traceEntry(GitTraceLocation.HISTORYVIEW.getLocation(), (Object)message);
        }
        this.getHistoryPageSite().getShell().getDisplay().asyncExec(new Runnable(){

            public void run() {
                if (GitHistoryPage.this.topControl.isDisposed()) {
                    return;
                }
                StackLayout layout = (StackLayout)GitHistoryPage.this.topControl.getLayout();
                if (message != null) {
                    GitHistoryPage.this.errorText.setText(message);
                    layout.topControl = GitHistoryPage.this.errorText;
                } else {
                    GitHistoryPage.this.errorText.setText("");
                    layout.topControl = GitHistoryPage.this.historyControl;
                }
                GitHistoryPage.this.topControl.layout();
            }
        });
        if (this.trace) {
            GitTraceLocation.getTrace().traceExit(GitTraceLocation.HISTORYVIEW.getLocation());
        }
    }

    public boolean isValidInput(Object object) {
        return GitHistoryPage.canShowHistoryFor(object);
    }

    public Object getAdapter(Class adapter) {
        return null;
    }

    public String getDescription() {
        String filterHint = null;
        switch (this.showAllFilter) {
            case SHOWALLREPO: {
                filterHint = UIText.GitHistoryPage_AllChangesInRepoHint;
                break;
            }
            case SHOWALLPROJECT: {
                filterHint = UIText.GitHistoryPage_AllChangesInProjectHint;
                break;
            }
            case SHOWALLFOLDER: {
                filterHint = UIText.GitHistoryPage_AllChangesInFolderHint;
                break;
            }
            case SHOWALLRESOURCE: {
                filterHint = UIText.GitHistoryPage_AllChangesOfResourceHint;
            }
        }
        return NLS.bind((String)DESCRIPTION_PATTERN, (Object)this.getName(), (Object)filterHint);
    }

    public String getName() {
        return this.name;
    }

    public HistoryPageInput getInputInternal() {
        return this.input;
    }

    void showCommitList(final Job j, final SWTCommitList list, final SWTCommit[] asArray) {
        if (this.trace) {
            GitTraceLocation.getTrace().traceEntry(GitTraceLocation.HISTORYVIEW.getLocation(), new Object[]{list, asArray});
        }
        if (this.job != j || this.graph.getControl().isDisposed()) {
            return;
        }
        this.graph.getControl().getDisplay().asyncExec(new Runnable(){

            public void run() {
                if (!GitHistoryPage.this.graph.getControl().isDisposed() && GitHistoryPage.this.job == j) {
                    GitHistoryPage.this.graph.setInput(GitHistoryPage.this.highlightFlag, list, asArray, GitHistoryPage.this.input);
                    if (GitHistoryPage.this.trace) {
                        GitTraceLocation.getTrace().trace(GitTraceLocation.HISTORYVIEW.getLocation(), "Setting input to table");
                    }
                    GitHistoryPage.this.findToolbar.setInput(GitHistoryPage.this.highlightFlag, GitHistoryPage.this.graph.getTableView().getTable(), asArray);
                    GitHistoryPage.this.setErrorMessage(null);
                }
            }
        });
        if (this.trace) {
            GitTraceLocation.getTrace().traceExit(GitTraceLocation.HISTORYVIEW.getLocation());
        }
    }

    void initAndStartRevWalk(boolean forceNewWalk) throws IllegalStateException {
        try {
            if (this.trace) {
                GitTraceLocation.getTrace().traceEntry(GitTraceLocation.HISTORYVIEW.getLocation());
            }
            this.cancelRefreshJob();
            Repository db = this.input.getRepository();
            AnyObjectId headId = this.resolveHead(db);
            ArrayList<String> paths = this.buildFilterPaths(this.input.getItems(), this.input.getFileList(), db);
            if (forceNewWalk || this.pathChange(this.pathFilters, paths) || this.currentWalk == null || !headId.equals(this.currentHeadId)) {
                this.createNewWalk(db, headId);
            } else {
                this.currentWalk.reset();
            }
            this.setWalkStartPoints(db, headId);
            TreeWalk fileWalker = this.setupFileViewer(db, paths);
            this.setupCommentViewer(db, fileWalker);
            this.scheduleNewGenerateHistoryJob();
        }
        finally {
            if (this.trace) {
                GitTraceLocation.getTrace().traceExit(GitTraceLocation.HISTORYVIEW.getLocation());
            }
        }
    }

    private AnyObjectId resolveHead(Repository db) {
        ObjectId headId;
        try {
            headId = db.resolve("HEAD");
        }
        catch (IOException iOException) {
            throw new IllegalStateException(NLS.bind((String)UIText.GitHistoryPage_errorParsingHead, (Object)Activator.getDefault().getRepositoryUtil().getRepositoryName(db)));
        }
        if (headId == null) {
            throw new IllegalStateException(NLS.bind((String)UIText.GitHistoryPage_errorParsingHead, (Object)Activator.getDefault().getRepositoryUtil().getRepositoryName(db)));
        }
        return headId;
    }

    private ArrayList<String> buildFilterPaths(IResource[] inResources, File[] inFiles, Repository db) throws IllegalStateException {
        ArrayList<String> paths;
        block18: {
            block19: {
                block17: {
                    if (inResources == null) break block17;
                    paths = new ArrayList<String>(inResources.length);
                    IResource[] iResourceArray = inResources;
                    int n = inResources.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IResource r = iResourceArray[n2];
                        RepositoryMapping map = RepositoryMapping.getMapping((IResource)r);
                        if (map != null) {
                            String path;
                            if (db != map.getRepository()) {
                                throw new IllegalStateException(UIText.AbstractHistoryCommanndHandler_NoUniqueRepository);
                            }
                            if (this.showAllFilter == ShowFilter.SHOWALLFOLDER) {
                                path = r.getParent() instanceof IWorkspaceRoot ? map.getRepoRelativePath((IResource)r.getProject()) : map.getRepoRelativePath((IResource)r.getParent());
                                if (path != null && path.length() > 0) {
                                    paths.add(path);
                                }
                            } else if (this.showAllFilter == ShowFilter.SHOWALLPROJECT) {
                                path = map.getRepoRelativePath((IResource)r.getProject());
                                if (path != null && path.length() > 0) {
                                    paths.add(path);
                                }
                            } else if (this.showAllFilter != ShowFilter.SHOWALLREPO && (path = map.getRepoRelativePath(r)) != null && path.length() > 0) {
                                paths.add(path);
                            }
                        }
                        ++n2;
                    }
                    break block18;
                }
                if (inFiles == null) break block19;
                Path workdirPath = new Path(db.getWorkTree().getPath());
                Path gitDirPath = new Path(db.getDirectory().getPath());
                int segmentCount = workdirPath.segmentCount();
                paths = new ArrayList(inFiles.length);
                File[] fileArray = inFiles;
                int n = inFiles.length;
                int n3 = 0;
                while (n3 < n) {
                    block22: {
                        Path filePath;
                        block21: {
                            File file;
                            block20: {
                                file = fileArray[n3];
                                if (this.showAllFilter != ShowFilter.SHOWALLFOLDER) break block20;
                                filePath = new Path(file.getParentFile().getPath());
                                break block21;
                            }
                            if (this.showAllFilter == ShowFilter.SHOWALLPROJECT || this.showAllFilter == ShowFilter.SHOWALLREPO) break block22;
                            filePath = new Path(file.getPath());
                        }
                        if (gitDirPath.isPrefixOf((IPath)filePath)) {
                            throw new IllegalStateException(NLS.bind((String)UIText.GitHistoryPage_FileOrFolderPartOfGitDirMessage, (Object)filePath.toOSString()));
                        }
                        IPath pathToAdd = filePath.removeFirstSegments(segmentCount).setDevice(null);
                        if (!pathToAdd.isEmpty()) {
                            paths.add(pathToAdd.toString());
                        }
                    }
                    ++n3;
                }
                break block18;
            }
            paths = new ArrayList(0);
        }
        return paths;
    }

    private boolean pathChange(List<String> o, List<String> n) {
        if (o == null) {
            return !n.isEmpty();
        }
        return !o.equals(n);
    }

    private void createNewWalk(Repository db, AnyObjectId headId) {
        this.currentHeadId = headId;
        if (this.currentWalk != null) {
            this.currentWalk.release();
        }
        this.currentWalk = new SWTWalk(db);
        this.currentWalk.sort(RevSort.COMMIT_TIME_DESC, true);
        this.currentWalk.sort(RevSort.BOUNDARY, true);
        this.highlightFlag = this.currentWalk.newFlag("highlight");
    }

    private void setWalkStartPoints(Repository db, AnyObjectId headId) {
        try {
            if (this.store.getBoolean("resourcehistory_show_all_branches")) {
                this.markStartAllRefs("refs/heads/");
                this.markStartAllRefs("refs/remotes/");
            } else {
                this.currentWalk.markStart(this.currentWalk.parseCommit(headId));
            }
        }
        catch (IOException e) {
            throw new IllegalStateException(NLS.bind((String)UIText.GitHistoryPage_errorReadingHeadCommit, (Object)headId, (Object)db.getDirectory().getAbsolutePath()), e);
        }
    }

    private void setupCommentViewer(Repository db, TreeWalk fileWalker) {
        this.commentViewer.setTreeWalk(fileWalker);
        this.commentViewer.setDb(db);
        this.commentViewer.refresh();
    }

    private TreeWalk setupFileViewer(Repository db, List<String> paths) {
        TreeWalk fileWalker = this.createFileWalker(db, paths);
        this.fileViewer.setTreeWalk(db, fileWalker);
        this.fileViewer.refresh();
        this.fileViewer.addSelectionChangedListener(this.commentViewer);
        return fileWalker;
    }

    private TreeWalk createFileWalker(Repository db, List<String> paths) {
        TreeWalk fileWalker = new TreeWalk(db);
        fileWalker.setRecursive(true);
        if (paths.size() > 0) {
            this.pathFilters = paths;
            this.currentWalk.setTreeFilter(AndTreeFilter.create((TreeFilter)PathFilterGroup.createFromStrings(paths), (TreeFilter)TreeFilter.ANY_DIFF));
            fileWalker.setFilter(this.currentWalk.getTreeFilter().clone());
        } else {
            this.pathFilters = null;
            this.currentWalk.setTreeFilter(TreeFilter.ALL);
            fileWalker.setFilter(TreeFilter.ANY_DIFF);
        }
        return fileWalker;
    }

    private void scheduleNewGenerateHistoryJob() {
        SWTCommitList list = new SWTCommitList(this.graph.getControl().getDisplay());
        list.source((RevWalk)this.currentWalk);
        final GenerateHistoryJob rj = new GenerateHistoryJob(this, list);
        rj.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                Control graphctl = GitHistoryPage.this.graph.getControl();
                if (GitHistoryPage.this.job != rj || graphctl.isDisposed()) {
                    return;
                }
                graphctl.getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        if (GitHistoryPage.this.job == rj) {
                            GitHistoryPage.this.job = null;
                        }
                    }
                });
            }
        });
        this.job = rj;
        if (this.trace) {
            GitTraceLocation.getTrace().trace(GitTraceLocation.HISTORYVIEW.getLocation(), "Scheduling GenerateHistoryJob");
        }
        this.schedule(rj);
    }

    private void schedule(Job j) {
        IWorkbenchSiteProgressService p;
        IWorkbenchPartSite site = this.getWorkbenchSite();
        if (site != null && (p = (IWorkbenchSiteProgressService)site.getAdapter(IWorkbenchSiteProgressService.class)) != null) {
            p.schedule(j, 0L, true);
            return;
        }
        j.schedule();
    }

    private IWorkbenchPartSite getWorkbenchSite() {
        IWorkbenchPart part = this.getHistoryPageSite().getPart();
        return part != null ? part.getSite() : null;
    }

    private void markStartAllRefs(String prefix) throws IOException, MissingObjectException, IncorrectObjectTypeException {
        for (Map.Entry refEntry : this.input.getRepository().getRefDatabase().getRefs(prefix).entrySet()) {
            Ref ref = (Ref)refEntry.getValue();
            if (ref.isSymbolic()) continue;
            this.currentWalk.markStart(this.currentWalk.parseCommit((AnyObjectId)ref.getObjectId()));
        }
    }

    private void cancelRefreshJob() {
        if (this.job != null && this.job.getState() != 0) {
            this.job.cancel();
            try {
                this.job.join();
            }
            catch (InterruptedException interruptedException) {
                this.cancelRefreshJob();
                return;
            }
            this.job = null;
        }
    }

    private static class GitHistoryPageActions {
        List<ActionFactory.IWorkbenchAction> actionsToDispose = new ArrayList<ActionFactory.IWorkbenchAction>();
        BooleanPrefAction wrapCommentAction;
        BooleanPrefAction fillCommentAction;
        IAction findAction;
        IAction refreshAction;
        BooleanPrefAction showCommentAction;
        BooleanPrefAction showFilesAction;
        ActionFactory.IWorkbenchAction compareModeAction;
        ActionFactory.IWorkbenchAction showAllBranchesAction;
        ActionFactory.IWorkbenchAction reuseCompareEditorAction;
        ShowFilterAction showAllRepoVersionsAction;
        ShowFilterAction showAllProjectVersionsAction;
        ShowFilterAction showAllFolderVersionsAction;
        ShowFilterAction showAllResourceVersionsAction;
        private GitHistoryPage historyPage;

        GitHistoryPageActions(GitHistoryPage historyPage) {
            this.historyPage = historyPage;
            this.createActions();
        }

        private void createActions() {
            this.createFindToolbarAction();
            this.createRefreshAction();
            this.createFilterActions();
            this.createCompareModeAction();
            this.createReuseCompareEditorAction();
            this.createShowAllBranchesAction();
            this.createShowCommentAction();
            this.createShowFilesAction();
            this.createWrapCommentAction();
            this.createFillCommentAction();
            this.wrapCommentAction.setEnabled(this.showCommentAction.isChecked());
            this.fillCommentAction.setEnabled(this.showCommentAction.isChecked());
        }

        private void createFindToolbarAction() {
            this.findAction = new Action(UIText.GitHistoryPage_FindMenuLabel, UIIcons.ELCL16_FIND){

                public void run() {
                    GitHistoryPageActions.this.historyPage.store.setValue("resourcehistory_show_findtoolbar", this.isChecked());
                    if (GitHistoryPageActions.this.historyPage.store.needsSaving()) {
                        try {
                            GitHistoryPageActions.this.historyPage.store.save();
                        }
                        catch (IOException e) {
                            Activator.handleError(e.getMessage(), e, false);
                        }
                    }
                    GitHistoryPageActions.this.historyPage.layout();
                }
            };
            this.findAction.setChecked(this.historyPage.store.getBoolean("resourcehistory_show_findtoolbar"));
            this.findAction.setToolTipText(UIText.GitHistoryPage_FindTooltip);
        }

        private void createRefreshAction() {
            this.refreshAction = new Action(UIText.GitHistoryPage_RefreshMenuLabel, UIIcons.ELCL16_REFRESH){

                public void run() {
                    GitHistoryPageActions.this.historyPage.refresh();
                }
            };
        }

        private void createFilterActions() {
            this.showAllRepoVersionsAction = new ShowFilterAction(ShowFilter.SHOWALLREPO, UIIcons.REPOSITORY, UIText.GitHistoryPage_AllInRepoMenuLabel, UIText.GitHistoryPage_AllInRepoTooltip);
            this.showAllProjectVersionsAction = new ShowFilterAction(ShowFilter.SHOWALLPROJECT, UIIcons.FILTERPROJECT, UIText.GitHistoryPage_AllInProjectMenuLabel, UIText.GitHistoryPage_AllInProjectTooltip);
            this.showAllFolderVersionsAction = new ShowFilterAction(ShowFilter.SHOWALLFOLDER, UIIcons.FILTERFOLDER, UIText.GitHistoryPage_AllInParentMenuLabel, UIText.GitHistoryPage_AllInParentTooltip);
            this.showAllResourceVersionsAction = new ShowFilterAction(ShowFilter.SHOWALLRESOURCE, UIIcons.FILTERRESOURCE, UIText.GitHistoryPage_AllOfResourceMenuLabel, UIText.GitHistoryPage_AllOfResourceTooltip);
            this.showAllRepoVersionsAction.setChecked(this.historyPage.showAllFilter == this.showAllRepoVersionsAction.filter);
            this.showAllProjectVersionsAction.setChecked(this.historyPage.showAllFilter == this.showAllProjectVersionsAction.filter);
            this.showAllFolderVersionsAction.setChecked(this.historyPage.showAllFilter == this.showAllFolderVersionsAction.filter);
            this.showAllResourceVersionsAction.setChecked(this.historyPage.showAllFilter == this.showAllResourceVersionsAction.filter);
        }

        private void createCompareModeAction() {
            this.compareModeAction = new BooleanPrefAction("resourcehistory_compare_mode", UIText.GitHistoryPage_CompareModeMenuLabel){

                void apply(boolean value) {
                }
            };
            this.compareModeAction.setImageDescriptor(UIIcons.ELCL16_COMPARE_VIEW);
            this.compareModeAction.setToolTipText(UIText.GitHistoryPage_compareMode);
            this.actionsToDispose.add(this.compareModeAction);
        }

        private void createReuseCompareEditorAction() {
            this.reuseCompareEditorAction = new CompareUtils.ReuseCompareEditorAction();
            this.actionsToDispose.add(this.reuseCompareEditorAction);
        }

        private void createShowAllBranchesAction() {
            this.showAllBranchesAction = new BooleanPrefAction("resourcehistory_show_all_branches", UIText.GitHistoryPage_ShowAllBranchesMenuLabel){

                void apply(boolean value) {
                    GitHistoryPageActions.this.historyPage.refresh();
                }
            };
            this.showAllBranchesAction.setImageDescriptor(UIIcons.BRANCH);
            this.showAllBranchesAction.setToolTipText(UIText.GitHistoryPage_showAllBranches);
            this.actionsToDispose.add(this.showAllBranchesAction);
        }

        private void createShowCommentAction() {
            this.showCommentAction = new BooleanPrefAction("resourcehistory_show_rev_comment", UIText.ResourceHistory_toggleRevComment){

                void apply(boolean value) {
                    GitHistoryPageActions.this.historyPage.layout();
                    GitHistoryPageActions.this.wrapCommentAction.setEnabled(this.isChecked());
                    GitHistoryPageActions.this.fillCommentAction.setEnabled(this.isChecked());
                }
            };
            this.actionsToDispose.add(this.showCommentAction);
        }

        private void createShowFilesAction() {
            this.showFilesAction = new BooleanPrefAction("resourcehistory_show_rev_detail", UIText.ResourceHistory_toggleRevDetail){

                void apply(boolean value) {
                    GitHistoryPageActions.this.historyPage.layout();
                }
            };
            this.actionsToDispose.add(this.showFilesAction);
        }

        private void createWrapCommentAction() {
            this.wrapCommentAction = new BooleanPrefAction("resourcehistory_show_comment_wrap", UIText.ResourceHistory_toggleCommentWrap){

                void apply(boolean wrap) {
                }
            };
            this.wrapCommentAction.apply(this.wrapCommentAction.isChecked());
            this.actionsToDispose.add(this.wrapCommentAction);
        }

        private void createFillCommentAction() {
            this.fillCommentAction = new BooleanPrefAction("resourcehistory_fill_comment_paragraph", UIText.ResourceHistory_toggleCommentFill){

                void apply(boolean fill) {
                }
            };
            this.fillCommentAction.apply(this.fillCommentAction.isChecked());
            this.actionsToDispose.add(this.fillCommentAction);
        }

        private abstract class BooleanPrefAction
        extends Action
        implements IPropertyChangeListener,
        ActionFactory.IWorkbenchAction {
            private final String prefName;

            BooleanPrefAction(String pn, String text) {
                this.setText(text);
                this.prefName = pn;
                GitHistoryPageActions.this.historyPage.store.addPropertyChangeListener((IPropertyChangeListener)this);
                this.setChecked(GitHistoryPageActions.this.historyPage.store.getBoolean(this.prefName));
            }

            public void run() {
                GitHistoryPageActions.this.historyPage.store.setValue(this.prefName, this.isChecked());
                if (GitHistoryPageActions.this.historyPage.store.needsSaving()) {
                    try {
                        GitHistoryPageActions.this.historyPage.store.save();
                    }
                    catch (IOException e) {
                        Activator.handleError(e.getMessage(), e, false);
                    }
                }
            }

            abstract void apply(boolean var1);

            public void propertyChange(PropertyChangeEvent event) {
                if (this.prefName.equals(event.getProperty())) {
                    this.setChecked(GitHistoryPageActions.this.historyPage.store.getBoolean(this.prefName));
                    this.apply(this.isChecked());
                }
            }

            public void dispose() {
                GitHistoryPageActions.this.historyPage.store.removePropertyChangeListener((IPropertyChangeListener)this);
            }
        }

        private class ShowFilterAction
        extends Action {
            private final ShowFilter filter;

            ShowFilterAction(ShowFilter filter, ImageDescriptor icon, String menuLabel, String toolTipText) {
                super(null, 2);
                this.filter = filter;
                this.setImageDescriptor(icon);
                this.setText(menuLabel);
                this.setToolTipText(toolTipText);
            }

            public void run() {
                String oldName = GitHistoryPageActions.this.historyPage.getName();
                String oldDescription = GitHistoryPageActions.this.historyPage.getDescription();
                if (!this.isChecked() && GitHistoryPageActions.this.historyPage.showAllFilter == this.filter) {
                    GitHistoryPageActions.this.historyPage.showAllFilter = ShowFilter.SHOWALLRESOURCE;
                    GitHistoryPageActions.this.showAllResourceVersionsAction.setChecked(true);
                    GitHistoryPageActions.this.historyPage.initAndStartRevWalk(false);
                }
                if (this.isChecked() && GitHistoryPageActions.this.historyPage.showAllFilter != this.filter) {
                    GitHistoryPageActions.this.historyPage.showAllFilter = this.filter;
                    if (this != GitHistoryPageActions.this.showAllRepoVersionsAction) {
                        GitHistoryPageActions.this.showAllRepoVersionsAction.setChecked(false);
                    }
                    if (this != GitHistoryPageActions.this.showAllProjectVersionsAction) {
                        GitHistoryPageActions.this.showAllProjectVersionsAction.setChecked(false);
                    }
                    if (this != GitHistoryPageActions.this.showAllFolderVersionsAction) {
                        GitHistoryPageActions.this.showAllFolderVersionsAction.setChecked(false);
                    }
                    if (this != GitHistoryPageActions.this.showAllResourceVersionsAction) {
                        GitHistoryPageActions.this.showAllResourceVersionsAction.setChecked(false);
                    }
                    GitHistoryPageActions.this.historyPage.initAndStartRevWalk(false);
                }
                GitHistoryPageActions.this.historyPage.firePropertyChange((Object)GitHistoryPageActions.this.historyPage, "org.eclipse.team.ui.name", oldName, GitHistoryPageActions.this.historyPage.getName());
                GitHistoryPageActions.this.historyPage.firePropertyChange((Object)GitHistoryPageActions.this.historyPage, "org.eclipse.team.ui.description", oldDescription, GitHistoryPageActions.this.historyPage.getDescription());
                Activator.getDefault().getPreferenceStore().setValue(GitHistoryPage.PREF_SHOWALLFILTER, GitHistoryPageActions.this.historyPage.showAllFilter.toString());
            }

            public String toString() {
                return "ShowFilter[" + this.filter.toString() + "]";
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum ShowFilter {
        SHOWALLRESOURCE,
        SHOWALLFOLDER,
        SHOWALLPROJECT,
        SHOWALLREPO;

    }
}

